/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.remote.generic;

import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.generic.ServerAdmin;
import com.sun.jmx.remote.generic.ServerSynchroMessageConnection;
import com.sun.jmx.remote.generic.SynchroCallback;
import java.io.IOException;
import java.util.Map;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.Message;
import javax.security.auth.Subject;
import jeus.management.remote.generic.MessageReader;
import jeus.management.remote.jeusmp.SocketNonblockingConnection;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JMXRemote;

public class ServerSynchroMessageNonblockingConnectionImpl
implements ServerSynchroMessageConnection,
MessageReader {
    private transient int[] connectionLock = new int[0];
    private transient MessageConnection connection;
    private transient ServerAdmin serverAdmin = null;
    private Map env;
    private transient SynchroCallback callback;
    private static final int UNCONNECTED = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 3;
    private static final int FAILED = 4;
    private static final int TERMINATED = 5;
    private int state = 1;
    private int[] stateLock = new int[0];
    private long waitConnectedState;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jmx.jmxmp");

    public ServerSynchroMessageNonblockingConnectionImpl(MessageConnection mc, Map env) {
        if (mc == null) {
            throw new IllegalArgumentException("Null message connection.");
        }
        this.env = env;
        this.waitConnectedState = DefaultConfig.getTimeoutForWaitConnectedState(env);
        this.serverAdmin = DefaultConfig.getServerAdmin(this.env);
        this.connection = mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map env) throws IOException {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 1) {
                this.connection.connect(env);
                this.connection = this.serverAdmin.connectionOpen(this.connection);
                this.state = 3;
                this.stateLock.notifyAll();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendOneWay(Message msg) throws IOException {
        if (logger.isLoggable(JeusMessage_JMXRemote._96_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._96_LEVEL, JeusMessage_JMXRemote._96);
        }
        this.checkState();
        int[] nArray = this.connectionLock;
        synchronized (this.connectionLock) {
            this.connection.writeMessage(msg);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setCallback(SynchroCallback cb) {
        if (this.callback != null) {
            throw new IllegalArgumentException("The callback has been assigned.");
        }
        if (cb == null) {
            throw new IllegalArgumentException("Null callback.");
        }
        this.callback = cb;
        ((SocketNonblockingConnection)this.connection).setMessageReader(this);
    }

    public String getConnectionId() {
        return this.connection.getConnectionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (logger.isLoggable(JeusMessage_JMXRemote._97_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._97_LEVEL, JeusMessage_JMXRemote._97);
        }
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 5) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.state = 5;
            if (logger.isLoggable(JeusMessage_JMXRemote._98_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._98_LEVEL, JeusMessage_JMXRemote._98);
            }
            if (this.connection != null) {
                this.connection.close();
            }
            this.serverAdmin.connectionClosed(this.connection);
            if (logger.isLoggable(JeusMessage_JMXRemote._99_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._99_LEVEL, JeusMessage_JMXRemote._99);
            }
            this.stateLock.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public MessageConnection getAsynchroConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readMessage(Message msg) {
        try {
            Message resp = this.callback.execute(msg);
            if (resp == null) return;
            int[] nArray = this.connectionLock;
            synchronized (this.connectionLock) {
                try {
                    this.connection.writeMessage(resp);
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
                return;
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_JMXRemote._150_LEVEL)) {
                logger.log(JeusMessage_JMXRemote._150_LEVEL, JeusMessage_JMXRemote._150, msg, t);
            }
            int[] nArray = this.stateLock;
            synchronized (this.stateLock) {
                if (this.state != 3 || this.callback == null) return;
                if (t instanceof Exception) {
                    this.callback.connectionException((Exception)t);
                } else {
                    this.callback.connectionException(new Exception(t.getMessage(), t));
                }
                // ** MonitorExit[var3_5] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionException(Exception ex) {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 3 && this.callback != null) {
                this.callback.connectionException(ex);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Subject getSubject() {
        return this.serverAdmin.getSubject(this.connection);
    }

    private void checkState() throws IOException {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 3) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.state == 5) {
                throw new IOException("The connection has been closed.");
            }
            long remainingTime = this.waitConnectedState;
            long startTime = System.currentTimeMillis();
            while (this.state != 3 && this.state != 5 && remainingTime > 0L) {
                try {
                    this.stateLock.wait(remainingTime);
                }
                catch (InterruptedException ire) {
                    break;
                }
                remainingTime = this.waitConnectedState - (System.currentTimeMillis() - startTime);
            }
            if (this.state == 3) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            throw new IOException("The connection is not currently established.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTerminated() {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.state == 5;
        }
    }
}

