/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.remote.generic;

import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.generic.ServerAdmin;
import com.sun.jmx.remote.generic.ServerSynchroMessageConnection;
import com.sun.jmx.remote.generic.SynchroMessageConnectionServer;
import java.io.IOException;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.generic.MessageConnectionServer;
import jeus.management.remote.generic.ServerSynchroMessageNonblockingConnectionImpl;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JMXRemote;
import jeus.util.properties.JeusJMXPropertyValues;

public class SynchroMessageNonblockingConnectionServerImpl
implements SynchroMessageConnectionServer {
    private MessageConnectionServer msServer;
    private Map env;
    private final ServerAdmin serverAdmin;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jmx.jmxmp");

    public SynchroMessageNonblockingConnectionServerImpl(MessageConnectionServer msServer, Map env) {
        if (msServer == null) {
            throw new IllegalArgumentException("Null MessageConnectionServer");
        }
        this.msServer = msServer;
        this.env = env;
        this.serverAdmin = DefaultConfig.getServerAdmin(this.env);
    }

    public void start(Map env) throws IOException {
        if (logger.isLoggable(JeusMessage_JMXRemote._100_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._100_LEVEL, JeusMessage_JMXRemote._100);
        }
        this.msServer.start(env);
    }

    public ServerSynchroMessageConnection accept() throws IOException {
        if (logger.isLoggable(JeusMessage_JMXRemote._101_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._101_LEVEL, JeusMessage_JMXRemote._101);
        }
        return new ServerSynchroMessageNonblockingConnectionImpl(this.msServer.accept(), this.env);
    }

    public void stop() throws IOException {
        if (logger.isLoggable(JeusMessage_JMXRemote._102_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._102_LEVEL, JeusMessage_JMXRemote._102);
        }
        if (!JeusJMXPropertyValues.jmxConnectorState.equals("STOPPING") && logger.isLoggable(JeusMessage_JMXRemote._156_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._156_LEVEL, JeusMessage_JMXRemote._156, (Object)JeusJMXPropertyValues.jmxConnectorState);
            Thread.dumpStack();
        }
        this.msServer.stop();
    }

    public JMXServiceURL getAddress() {
        return this.msServer.getAddress();
    }

    public MessageConnectionServer getAsynchronConnection() {
        return this.msServer;
    }
}

