/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.remote.jeusmp;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.generic.MessageConnectionServer;
import jeus.management.remote.jeusmp.SocketNonblockingConnection;
import jeus.util.Queue;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JMXRemote;
import jeus.util.net.VirtualListener;
import jeus.util.oneport.OnePortServer;

public class OneSocketNonblockingConnectionServer
implements MessageConnectionServer,
VirtualListener {
    private Map env;
    private JMXServiceURL addr;
    private final Queue queue = new Queue();
    private String id;
    private static JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jmx.jmxmp");

    public OneSocketNonblockingConnectionServer(JMXServiceURL url, Map env) {
        this.addr = url;
        this.env = env;
        this.id = url.getURLPath();
    }

    public void start(Map env) throws IOException {
        OnePortServer.getInstance().register(this);
        HashMap newEnv = new HashMap();
        if (this.env != null) {
            newEnv.putAll(this.env);
        }
        if (env != null) {
            newEnv.putAll(env);
        }
        this.env = newEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConnection accept() throws IOException {
        if (logger.isLoggable(JeusMessage_JMXRemote._114_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._114_LEVEL, JeusMessage_JMXRemote._114);
        }
        while (true) {
            Queue queue = this.queue;
            synchronized (queue) {
                Socket socket;
                try {
                    socket = (Socket)this.queue.getFront();
                    while (socket == null) {
                        this.queue.wait();
                        socket = (Socket)this.queue.getFront();
                    }
                }
                catch (InterruptedException e) {
                    if (logger.isLoggable(JeusMessage_JMXRemote._155_LEVEL)) {
                        logger.log(JeusMessage_JMXRemote._155_LEVEL, JeusMessage_JMXRemote._155, (Throwable)e);
                    }
                    continue;
                }
                try {
                    return new SocketNonblockingConnection(socket);
                }
                catch (IOException e) {
                    if (logger.isLoggable(JeusMessage_JMXRemote._154_LEVEL)) {
                        logger.log(JeusMessage_JMXRemote._154_LEVEL, JeusMessage_JMXRemote._154, (Throwable)e);
                    }
                    socket.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        OnePortServer.getInstance().unregister(this);
        Queue queue = this.queue;
        synchronized (queue) {
            Socket socket;
            while ((socket = (Socket)this.queue.getFront()) != null) {
                try {
                    socket.shutdownInput();
                }
                catch (IOException e) {
                }
                catch (UnsupportedOperationException uoe) {
                    // empty catch block
                }
                try {
                    socket.shutdownOutput();
                }
                catch (IOException e) {
                }
                catch (UnsupportedOperationException uoe) {
                    // empty catch block
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public JMXServiceURL getAddress() {
        return this.addr;
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSocket(Socket socket) throws IOException {
        Queue queue = this.queue;
        synchronized (queue) {
            this.queue.add(socket);
            this.queue.notify();
        }
    }
}

