/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.remote.jeusmp;

import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.socket.SocketConnectionIf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.Message;
import javax.net.ssl.SSLSocket;
import javax.security.auth.Subject;
import jeus.io.Connector;
import jeus.io.Selector;
import jeus.io.handler.StreamContentReceiver;
import jeus.io.helper.IOComponentCreator;
import jeus.io.helper.JeusIOComponentCreator;
import jeus.io.impl.StreamHandlerImpl;
import jeus.management.remote.generic.MessageReader;
import jeus.util.JeusRuntimeException;
import jeus.util.PooledExecutorFactory;
import jeus.util.Queue;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JMXRemote;
import jeus.util.properties.JeusJMXProperties;

public class SocketNonblockingConnection
implements SocketConnectionIf,
MessageConnection,
StreamContentReceiver {
    private Subject subject;
    Socket sock;
    String addr;
    int port;
    ClassLoader defaultClassLoader;
    private final String defaultConnectionId = "Uninitialized connection id";
    static final int UNCONNECTED = 1;
    static final int CONNECTING = 2;
    static final int CONNECTED = 4;
    static final int FAILED = 8;
    static final int TERMINATED = 16;
    int state = 1;
    int[] stateLock = new int[0];
    long waitConnectedState = 1000L;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jmx.jmxmp");
    protected MessageReader messageReader;
    protected Queue messageQueue = new Queue();
    private static final Executor executor;
    private boolean exceptionOccurred;
    int checktmout;
    private StreamHandlerImpl endpoint;
    public static IOComponentCreator creator;
    private static Selector selector;

    public SocketNonblockingConnection(Socket socket) throws IOException {
        if (logger.isLoggable(JeusMessage_JMXRemote._107_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._107_LEVEL, JeusMessage_JMXRemote._107, (Object)socket);
        }
        this.sock = socket;
        this.addr = this.sock.getInetAddress().getHostName();
        this.port = this.sock.getPort();
        this.replaceStreams(null, null);
    }

    public SocketNonblockingConnection(String addr, int port, int checktmout) {
        if (logger.isLoggable(JeusMessage_JMXRemote._108_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._108_LEVEL, JeusMessage_JMXRemote._108, new Object[]{addr, new Integer(port)});
        }
        this.addr = addr;
        this.port = port;
        this.checktmout = checktmout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map env) throws IOException {
        this.waitConnectedState = DefaultConfig.getTimeoutForWaitConnectedState(env);
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            this.makeQueue();
            if (this.state == 1) {
                if (logger.isLoggable(JeusMessage_JMXRemote._104_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote._104_LEVEL, JeusMessage_JMXRemote._104);
                }
                this.state = 2;
                this.stateLock.notifyAll();
                if (this.sock == null) {
                    Connector connector = creator.createConnector(null, null);
                    this.sock = connector.connect(this.addr, this.port, null, 0, 0);
                    if (this.checktmout > 0) {
                        this.sock.setSoTimeout(this.checktmout);
                    }
                    this.replaceStreams(null, null);
                }
                if (env != null) {
                    this.defaultClassLoader = (ClassLoader)env.get("jmx.remote.default.class.loader");
                }
                this.state = 4;
                this.stateLock.notifyAll();
            } else if (this.state == 8 || this.state == 4) {
                if (logger.isLoggable(JeusMessage_JMXRemote._105_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote._105_LEVEL, JeusMessage_JMXRemote._105);
                }
                if (this.state == 4) {
                    this.state = 8;
                    this.stateLock.notifyAll();
                    this.closeSocket();
                }
                this.state = 2;
                this.stateLock.notifyAll();
                Connector connector = creator.createConnector(null, null);
                this.sock = connector.connect(this.addr, this.port, null, 0, 0);
                if (this.checktmout > 0) {
                    this.sock.setSoTimeout(this.checktmout);
                }
                this.replaceStreams(null, null);
                this.state = 4;
                this.stateLock.notifyAll();
            } else {
                if (this.state == 16) {
                    throw new IllegalStateException("The connection has been closed.");
                }
                if (logger.isLoggable(JeusMessage_JMXRemote._106_LEVEL)) {
                    logger.log(JeusMessage_JMXRemote._106_LEVEL, JeusMessage_JMXRemote._106);
                }
                this.checkState();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Socket getSocket() {
        throw new JeusRuntimeException("Not supported");
    }

    public void setSocket(Socket s) throws IOException {
        throw new JeusRuntimeException("Not supported");
    }

    public void replaceStreams(InputStream is, OutputStream os) throws IOException {
        if (this.endpoint != null) {
            selector.removeSelectItem(this.endpoint);
        }
        this.endpoint = creator.createStreamHandler((Object)this.sock, (StreamContentReceiver)this, this.defaultClassLoader, null, null);
        this.endpoint.setSocket(this.sock);
        selector.addSelectItem(this.endpoint);
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message readMessage() throws IOException, ClassNotFoundException {
        Object msg;
        this.checkState();
        SocketNonblockingConnection socketNonblockingConnection = this;
        synchronized (socketNonblockingConnection) {
            msg = this.messageQueue.getFront();
            while (msg == null) {
                if (this.exceptionOccurred) {
                    throw new IOException("Exception occurred but no exception transfered from the other side");
                }
                try {
                    this.wait(20000L);
                }
                catch (InterruptedException e) {
                    throw new IOException();
                }
                msg = this.messageQueue.getFront();
            }
            if (this.exceptionOccurred) {
                if (msg instanceof IOException) {
                    throw (IOException)msg;
                }
                ((Exception)msg).printStackTrace();
                throw new IOException("Exception occurred during receiving message");
            }
        }
        return (Message)msg;
    }

    public void writeMessage(Message msg) throws IOException {
        if (logger.isLoggable(JeusMessage_JMXRemote._109_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._109_LEVEL, JeusMessage_JMXRemote._109);
        }
        this.checkState();
        this.endpoint.write(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (logger.isLoggable(JeusMessage_JMXRemote._110_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._110_LEVEL, JeusMessage_JMXRemote._110);
        }
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            block10: {
                if (this.state == 16) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.state = 16;
                if (this.sock instanceof SSLSocket) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ire) {
                        // empty catch block
                    }
                }
                try {
                    this.endpoint.close(null);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(JeusMessage_JMXRemote._111_LEVEL)) break block10;
                    logger.log(JeusMessage_JMXRemote._111_LEVEL, JeusMessage_JMXRemote._111, (Throwable)e);
                }
            }
            this.stateLock.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getConnectionId() {
        if (this.sock == null) {
            return "Uninitialized connection id";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("jmxmp://").append(this.sock.getInetAddress().getHostName()).append(":").append(this.sock.getPort()).append(" ");
        if (this.subject != null) {
            Set<Principal> principals = this.subject.getPrincipals();
            String sep = "";
            for (Principal p : principals) {
                String n = p.getName().replace(' ', '_').replace(';', ':');
                buf.append(sep).append(n);
                sep = ";";
            }
        }
        buf.append(" ").append(System.identityHashCode(this));
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkState() throws IllegalStateException {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 4) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.state == 16) {
                throw new IllegalStateException("The connection has been closed.");
            }
            long waitingTime = this.waitConnectedState;
            long endTime = System.currentTimeMillis() + waitingTime;
            while (this.state != 4 && this.state != 16 && waitingTime > 0L) {
                try {
                    this.stateLock.wait(waitingTime);
                }
                catch (InterruptedException ire) {
                    break;
                }
                waitingTime = endTime - System.currentTimeMillis();
            }
            if (this.state != 4) {
                throw new IllegalStateException("The connection is not currently established.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageReader(MessageReader messageReader) {
        SocketNonblockingConnection socketNonblockingConnection = this;
        synchronized (socketNonblockingConnection) {
            Object[] msgs = this.messageQueue.getAll();
            for (int i = 0; i < msgs.length; ++i) {
                Message msg = (Message)msgs[i];
                messageReader.readMessage(msg);
            }
            this.messageQueue = null;
            this.messageReader = messageReader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveContent(final Object obj, StreamHandlerImpl streamReader, byte[] header) {
        MessageReader reader = null;
        SocketNonblockingConnection socketNonblockingConnection = this;
        synchronized (socketNonblockingConnection) {
            if (this.messageReader != null) {
                reader = this.messageReader;
            } else {
                this.messageQueue.add(obj);
                this.notify();
            }
        }
        if (reader != null) {
            final MessageReader messageReader = reader;
            executor.execute(new Runnable(){

                public void run() {
                    messageReader.readMessage((Message)obj);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveException(final Exception exception, StreamHandlerImpl streamReader) {
        MessageReader reader = null;
        SocketNonblockingConnection socketNonblockingConnection = this;
        synchronized (socketNonblockingConnection) {
            if (this.messageReader != null) {
                reader = this.messageReader;
            } else {
                this.messageQueue.add(exception);
                this.exceptionOccurred = true;
                this.notifyAll();
            }
        }
        if (reader != null) {
            final MessageReader messageReader = reader;
            executor.execute(new Runnable(){

                public void run() {
                    messageReader.connectionException(exception);
                }
            });
        }
    }

    public void writeDone() {
    }

    protected void closeSocket() {
        try {
            this.sock.shutdownInput();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            this.sock.shutdownOutput();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeQueue() {
        SocketNonblockingConnection socketNonblockingConnection = this;
        synchronized (socketNonblockingConnection) {
            this.messageReader = null;
            Queue newQueue = new Queue();
            if (this.messageQueue != null && !this.messageQueue.isEmpty()) {
                Object[] items = this.messageQueue.getAll();
                for (int i = 0; i < items.length; ++i) {
                    newQueue.add(items[i]);
                }
            }
            this.messageQueue = newQueue;
        }
    }

    static {
        creator = JeusIOComponentCreator.DEFAULT_CREATOR;
        executor = PooledExecutorFactory.createThreadPoolExecutor("JMXMP", JeusJMXProperties.JMXMP_THREAD_MIN, JeusJMXProperties.JMXMP_THREAD_MAX, JeusJMXProperties.JMXMP_THREAD_KEEPALIVE);
        selector = creator.createSelector("JMXMPSelector", 1, false);
    }
}

