/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.remote.jeusmp;

import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.generic.MessageConnectionServer;
import jeus.io.Acceptor;
import jeus.io.SocketListener;
import jeus.io.helper.JeusIOComponentCreator;
import jeus.management.remote.jeusmp.SocketNonblockingConnection;
import jeus.util.Queue;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JMXRemote;
import jeus.util.properties.JeusNetPropertyValues;

public class SocketNonblockingConnectionServer
implements MessageConnectionServer,
SocketListener {
    private JMXServiceURL addr;
    private boolean wildcard;
    private Map env;
    private static final String DEFAULT_PROTOCOL = "jmxmp";
    private static final int DEFAULT_BACKLOG = 100;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.jmx.jmxmp");
    private final Queue queue = new Queue();
    private Acceptor acceptor;

    public SocketNonblockingConnectionServer(JMXServiceURL addr, Map env) throws IOException {
        if (logger.isLoggable(JeusMessage_JMXRemote._112_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._112_LEVEL, JeusMessage_JMXRemote._112, (Object)addr);
        }
        if (addr == null) {
            throw new NullPointerException("Null address.");
        }
        if (!DEFAULT_PROTOCOL.equalsIgnoreCase(addr.getProtocol())) {
            throw new MalformedURLException("Unknown protocol: " + addr.getProtocol());
        }
        String wildcardS = null;
        if (env != null) {
            wildcardS = (String)env.get("jmx.remote.server.address.wildcard");
        }
        this.wildcard = wildcardS == null ? true : wildcardS.equalsIgnoreCase("true");
        this.addr = addr;
    }

    public void start(Map env) throws IOException {
        if (logger.isLoggable(JeusMessage_JMXRemote._113_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._113_LEVEL, JeusMessage_JMXRemote._113);
        }
        HashMap newEnv = new HashMap();
        if (this.env != null) {
            newEnv.putAll(this.env);
        }
        if (env != null) {
            newEnv.putAll(env);
        }
        int port = this.addr.getPort();
        String host = this.addr.getHost();
        if (host.equals("")) {
            host = JeusNetPropertyValues.LOCAL_FULL_HOSTNAME;
        }
        if (this.wildcard) {
            ServerSocket ss = new ServerSocket(0, 100, JeusNetPropertyValues.getByName(host));
            ss.close();
        }
        InetAddress address = this.wildcard ? null : JeusNetPropertyValues.getByName(host);
        try {
            this.acceptor = JeusIOComponentCreator.DEFAULT_CREATOR.createAcceptor(port, this, null, 100, address, Boolean.toString(DefaultConfig.getServerReuseAddress(newEnv)));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)e).getTargetException();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Exception) {
                    e = (Exception)t;
                }
            }
            IOException ioe = new IOException(e.toString());
            EnvHelp.initCause(ioe, e);
            throw ioe;
        }
        this.addr = new JMXServiceURL(DEFAULT_PROTOCOL, host, port);
        Thread thread = new Thread((Runnable)this.acceptor, "SocketNonblockingConnectionServer[" + this.addr.toString() + "]");
        thread.setDaemon(true);
        thread.start();
        this.env = newEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConnection accept() throws IOException {
        if (logger.isLoggable(JeusMessage_JMXRemote._114_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._114_LEVEL, JeusMessage_JMXRemote._114);
        }
        while (true) {
            Queue queue = this.queue;
            synchronized (queue) {
                Socket socket;
                try {
                    socket = (Socket)this.queue.getFront();
                    while (socket == null) {
                        this.queue.wait();
                        socket = (Socket)this.queue.getFront();
                    }
                }
                catch (InterruptedException e) {
                    if (logger.isLoggable(JeusMessage_JMXRemote._155_LEVEL)) {
                        logger.log(JeusMessage_JMXRemote._155_LEVEL, JeusMessage_JMXRemote._155, (Throwable)e);
                    }
                    continue;
                }
                try {
                    return new SocketNonblockingConnection(socket);
                }
                catch (IOException e) {
                    if (logger.isLoggable(JeusMessage_JMXRemote._154_LEVEL)) {
                        logger.log(JeusMessage_JMXRemote._154_LEVEL, JeusMessage_JMXRemote._154, (Throwable)e);
                    }
                    socket.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSocket(Socket socket) throws IOException {
        Queue queue = this.queue;
        synchronized (queue) {
            this.queue.add(socket);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        if (logger.isLoggable(JeusMessage_JMXRemote._115_LEVEL)) {
            logger.log(JeusMessage_JMXRemote._115_LEVEL, JeusMessage_JMXRemote._115);
        }
        if (this.acceptor != null) {
            this.acceptor.stop();
        }
        Queue queue = this.queue;
        synchronized (queue) {
            Socket socket;
            while ((socket = (Socket)this.queue.getFront()) != null) {
                try {
                    socket.shutdownInput();
                }
                catch (IOException e) {
                }
                catch (UnsupportedOperationException uoe) {
                    // empty catch block
                }
                try {
                    socket.shutdownOutput();
                }
                catch (IOException e) {
                }
                catch (UnsupportedOperationException uoe) {
                    // empty catch block
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public JMXServiceURL getAddress() {
        return this.addr;
    }
}

