/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.remote.security;

import com.sun.jmx.remote.generic.ProfileClient;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.ProfileMessage;
import jeus.management.remote.message.JeusSecurityMessage;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.util.JeusRuntimeException;
import jeus.util.message.JeusMessage_JMXRemote;

public class JeusSecurityClientHandler
implements ProfileClient {
    private Subject subject;
    private boolean completed = false;
    private String profile = null;
    public static final String JEUS_SUBJECT = "jeus.subject";
    public static final String JEUS_SUBJECT_PRINCIPAL = "jeus.subject.principal";
    public static final String JEUS_SUBJECT_CREDENTIAL = "jeus.subject.credential";
    public static final String USE_JNDI_SECURITY_KEY = "USE_SECURITY_FOR_MEJB_UTILITY";

    public JeusSecurityClientHandler(String profile, Map env) {
        this.profile = profile;
        this.subject = (Subject)env.get(JEUS_SUBJECT);
        if (this.subject == null) {
            String principal = (String)env.get(JEUS_SUBJECT_PRINCIPAL);
            String credential = (String)env.get(JEUS_SUBJECT_CREDENTIAL);
            if (principal != null && credential != null) {
                this.subject = Subject.makeSubject(principal, credential);
            }
        }
    }

    public void initialize(MessageConnection mc) throws IOException {
    }

    public ProfileMessage produceMessage() throws IOException {
        try {
            return new JeusSecurityMessage(this.profile, this.subject.serialize());
        }
        catch (Exception e) {
            throw new JeusRuntimeException(e);
        }
    }

    public void consumeMessage(ProfileMessage pm) throws IOException {
        if (!(pm instanceof JeusSecurityMessage)) {
            throw new IOException("Unexpected profile message type: " + pm.getClass().getName());
        }
        JeusSecurityMessage challenge = (JeusSecurityMessage)pm;
        if (!challenge.isAuthenticated()) {
            throw new IOException("This user is NOT allowed to connect JMX Connector");
        }
        this.completed = true;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public void activate() throws IOException {
    }

    public void terminate() throws IOException {
    }

    public String getName() {
        return this.profile;
    }

    public static Subject putSubject(Hashtable jndiEnv) {
        Subject s;
        if (jndiEnv.get(USE_JNDI_SECURITY_KEY) != null) {
            String user = (String)jndiEnv.get("java.naming.security.principal");
            String password = (String)jndiEnv.get("java.naming.security.credentials");
            s = Subject.makeSubject(user, password);
        } else {
            try {
                s = LoginService.getCurrentSubject();
            }
            catch (Exception e) {
                throw new JeusRuntimeException(JeusMessage_JMXRemote._74, (Throwable)e);
            }
        }
        try {
            if (s != null) {
                jndiEnv.put(JEUS_SUBJECT, s);
            }
        }
        catch (Exception e) {
            throw new JeusRuntimeException(e);
        }
        return s;
    }
}

