/*
 * Decompiled with CFR 0.152.
 */
package jeus.management.remote.security;

import com.sun.jmx.remote.generic.ProfileServer;
import java.io.IOException;
import java.util.Map;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.ProfileMessage;
import javax.security.auth.Subject;
import jeus.management.remote.message.JeusSecurityMessage;
import jeus.security.base.CodeSubject;
import jeus.security.base.SecurityException;
import jeus.security.spi.LoginService;
import jeus.util.JeusRuntimeException;
import jeus.util.message.JeusMessage_JMXRemote;

public class JeusSecurityServerHandler
implements ProfileServer {
    private boolean completed;
    private JeusSecurityMessage response;
    private String profile;
    private jeus.security.base.Subject subject;

    public JeusSecurityServerHandler(String profile, Map env) {
        this.profile = profile;
    }

    public void initialize(MessageConnection mc, Subject s) throws IOException {
    }

    public ProfileMessage produceMessage() throws IOException {
        this.response.init();
        this.response.setAuthenticated(true);
        return this.response;
    }

    public void consumeMessage(ProfileMessage pm) throws IOException {
        if (!(pm instanceof JeusSecurityMessage)) {
            throw new IOException("Unexpected profile message type: " + pm.getClass().getName());
        }
        this.response = (JeusSecurityMessage)pm;
        try {
            this.subject = jeus.security.base.Subject.deserialize(this.response.getSubjectSerialized());
            if (!(this.subject instanceof CodeSubject) && this.subject.getPrincipal().getName().equals(CodeSubject.CODE_PRINCIPAL_NAME)) {
                throw new JeusRuntimeException("The principal name should not be the same with the name of code subject principal : " + CodeSubject.CODE_PRINCIPAL_NAME);
            }
            LoginService.login(this.subject);
            LoginService.logout();
        }
        catch (SecurityException e) {
            throw new JeusRuntimeException(JeusMessage_JMXRemote.JMX_45, e.getMessage());
        }
        catch (Throwable e) {
            throw new JeusRuntimeException("Exception occurred", e);
        }
        this.completed = true;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public Subject activate() throws IOException {
        try {
            return this.subject.toJAASSubject();
        }
        catch (Exception e) {
            throw new JeusRuntimeException(e);
        }
    }

    public void terminate() throws IOException {
        this.subject = null;
    }

    public String getName() {
        return this.profile;
    }
}

