/*
 * Decompiled with CFR 0.152.
 */
package jeus.net;

public class SocketIDParser {
    private static final byte STATE_PROTOCOL = 0;
    private static final byte STATE_SOCKET_ADDRESS = 1;
    private static final byte STATE_VIRTUAL_ID = 2;
    private static final byte STATE_FINISH = 3;
    public static final int INDEX_HOST = 0;
    public static final int INDEX_PORT = 1;
    public static final int INDEX_VIRTUAL_ID = 2;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] parse(String address) {
        String[] results = new String[3];
        String[] tokens = address.trim().split("/");
        int state = 0;
        block5: for (String token : tokens) {
            switch (state) {
                case 0: {
                    if (token.equalsIgnoreCase("jeus:") || token.length() == 0) {
                        state = 1;
                        continue block5;
                    }
                }
                case 1: {
                    int idx;
                    if (token.contains("[")) {
                        if (!token.contains("]")) throw new IllegalArgumentException("Invalid ipv6 expression");
                        idx = token.indexOf("]");
                        results[0] = token.substring(token.indexOf("[") + 1, idx);
                        if (token.indexOf(":", idx + 1) >= 0) {
                            results[1] = token.substring(token.lastIndexOf(":") + 1);
                        }
                    } else if (token.contains(":")) {
                        idx = token.indexOf(":");
                        results[0] = token.substring(0, idx);
                        results[1] = token.substring(idx + 1);
                    } else {
                        results[0] = token;
                    }
                    state = 2;
                    continue block5;
                }
                case 2: {
                    results[2] = token;
                    state = 3;
                    continue block5;
                }
            }
        }
        return results;
    }
}

