/*
 * Decompiled with CFR 0.152.
 */
package jeus.net;

import java.io.IOException;
import java.net.Socket;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import jeus.io.handler.StreamContentReceiver;
import jeus.io.handler.StreamHandler;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.protocol.message.MessageConstant;
import jeus.net.AcceptorConnectionListener;
import jeus.net.ConnectionListener;
import jeus.net.Endpoint;
import jeus.net.MessageHandler;
import jeus.net.NetworkControlPacket;
import jeus.net.NoListenID;
import jeus.net.ReplyListener;
import jeus.net.SocketID;
import jeus.net.impl.ConnectionManager;
import jeus.net.impl.CrossConnectionException;
import jeus.net.impl.NodeInfo;
import jeus.net.impl.SocketStream14;
import jeus.util.ByteUtil;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;
import jeus.util.properties.JeusNetProperties;

public class SocketStream
implements StreamContentReceiver {
    public static final SocketStream[] DUMMY_ARRAY = new SocketStream[0];
    protected Socket socket;
    protected SocketID socketID;
    protected StreamHandlerImpl endpoint;
    protected boolean closed;
    protected boolean established;
    protected ConnectionListener listener;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.net");
    protected boolean isCrossClosed;
    private AtomicInteger seq = new AtomicInteger(0);
    protected Map replyListenerTable = new ConcurrentHashMap();
    protected static final byte[] BUFFER_LENGTH_FOR_REPLY_BYTES = ByteUtil.convertToByte(8);
    protected static final byte[] BUFFER_LENGTH_FOR_REPLY_REQUEST_BYTES = ByteUtil.convertToByte(12);
    protected static final ThreadLocal currentReplySequence = new ThreadLocal();
    protected String socketString = "";
    protected SocketID localSocketID;
    private boolean onlyByteTransfer;
    protected ConnectionManager connectionManager;
    public static final int NO_CLOSE = 0;
    public static final int DESTROY_CALLED = 1;
    public static final int CLOSE_ACK_ARRIVED = 2;
    public static final int CLOSE_REQUEST_ARRIVED = 3;
    public static final int EXCEPTION_CLOSE = 4;
    public static final int CROSS_CONNECTION_CLOSE = 5;
    protected int closeState = 0;
    private boolean closeAckSent = false;
    private final Object closeStateLock = new Object();
    private static final Integer NO_REPLY_SEQ_INT = new Integer(-1);

    public SocketStream(Socket socket, ConnectionManager connectionManager, ConnectionListener listener, boolean onlyByteTransfer) {
        this.socket = socket;
        this.listener = listener;
        this.localSocketID = connectionManager.getLocalListenSocketID();
        this.onlyByteTransfer = onlyByteTransfer;
        this.setSocketLog();
        if (logger.isLoggable(JeusMessage_Network._412_LEVEL)) {
            logger.log(JeusMessage_Network._412_LEVEL, JeusMessage_Network._412, (Object)this.socketString);
        }
        this.connectionManager = connectionManager;
    }

    public void receiveContent(Object obj, StreamHandlerImpl reader, byte[] header) {
        boolean isControlPacket;
        boolean isReplyPacket;
        int magic;
        if (logger.isLoggable(JeusMessage_Network._900_LEVEL)) {
            logger.log(JeusMessage_Network._900_LEVEL, JeusMessage_Network._900, (Object)this);
        }
        if (header != null) {
            String log;
            magic = ByteUtil.convertToInt(header);
            switch (magic) {
                case 126311407: {
                    isReplyPacket = false;
                    log = "REQEUST_MAGIC";
                    break;
                }
                case 126311422: {
                    log = "REPLY_MAGIC";
                    isReplyPacket = true;
                    break;
                }
                case 126311423: {
                    log = "REPLY_REQEUST_MAGIC";
                    isReplyPacket = true;
                    break;
                }
                case 126311406: {
                    log = "NETWORK_CONTROL_PACKET_MAGIC";
                    obj = NetworkControlPacket.convertByte((byte[])obj, (StreamHandler)this.endpoint);
                    isReplyPacket = false;
                    break;
                }
                case 126311150: {
                    log = "NETWORK_CONTROL_PACKET_REQUEST_MAGIC";
                    obj = NetworkControlPacket.convertByte((byte[])obj, (StreamHandler)this.endpoint);
                    isReplyPacket = false;
                    break;
                }
                case 126311662: {
                    log = "NETWORK_CONTROL_PACKET_REPLY_MAGIC";
                    obj = NetworkControlPacket.convertByte((byte[])obj, (StreamHandler)this.endpoint);
                    isReplyPacket = true;
                    break;
                }
                case 126311918: {
                    log = "NETWORK_CONTROL_PACKET_REQUEST_REPLY_MAGIC";
                    obj = NetworkControlPacket.convertByte((byte[])obj, (StreamHandler)this.endpoint);
                    isReplyPacket = true;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            if (logger.isLoggable(JeusMessage_Network._901_LEVEL)) {
                logger.log(JeusMessage_Network._901_LEVEL, JeusMessage_Network._901, new Object[]{log, this});
            }
        } else {
            magic = 0;
            isReplyPacket = false;
        }
        if (obj instanceof NetworkControlPacket) {
            isControlPacket = true;
            magic = -1;
            if (logger.isLoggable(JeusMessage_Network._902_LEVEL)) {
                logger.log(JeusMessage_Network._902_LEVEL, JeusMessage_Network._902, (Object)this);
            }
        } else {
            isControlPacket = false;
            if (logger.isLoggable(JeusMessage_Network._903_LEVEL)) {
                logger.log(JeusMessage_Network._903_LEVEL, JeusMessage_Network._903, (Object)this);
            }
        }
        MessageProcessor processor = new MessageProcessor(obj, header, magic);
        if (isControlPacket) {
            processor.run();
        } else {
            this.callDelegateTask(processor, isReplyPacket, obj);
        }
    }

    protected void callDelegateTask(MessageProcessor processor, boolean replyPacket, Object obj) {
        if (logger.isLoggable(JeusMessage_Network._904_LEVEL)) {
            logger.log(JeusMessage_Network._904_LEVEL, JeusMessage_Network._904, new Object[]{this.listener, this});
        }
        this.listener.runDelegatedTask(processor, replyPacket, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveException(Exception exception, StreamHandlerImpl reader) {
        int prevCloseState;
        if (logger.isLoggable(JeusMessage_Network._905_LEVEL)) {
            logger.log(JeusMessage_Network._905_LEVEL, JeusMessage_Network._905, (Object)this);
        }
        if (this.closeState == 2 || this.closeState == 3 && this.closeAckSent) {
            Object object = this.closeStateLock;
            synchronized (object) {
                this.closeStateLock.notifyAll();
            }
            return;
        }
        Object object = this.closeStateLock;
        synchronized (object) {
            prevCloseState = this.closeState;
            this.closeState = exception instanceof CrossConnectionException ? 5 : 4;
        }
        if (prevCloseState == 0) {
            this.shutdown(exception);
        } else {
            if (logger.isLoggable(JeusMessage_Network._935_LEVEL)) {
                logger.log(JeusMessage_Network._935_LEVEL, JeusMessage_Network._935, new Object[]{this, this.getCurrentCloseState(prevCloseState)}, (Throwable)exception);
            }
            object = this.closeStateLock;
            synchronized (object) {
                this.closeStateLock.notifyAll();
            }
        }
    }

    public void writeDone() {
        this.listener.writeDone(this);
    }

    private String getCurrentCloseState(int state) {
        switch (state) {
            case 0: {
                return "NO_CLOSE";
            }
            case 1: {
                return "DESTROY_CALLED";
            }
            case 2: {
                return "CLOSE_ACK_ARRIVED";
            }
            case 3: {
                return "CLOSE_REQUEST_ARRIVED";
            }
            case 4: {
                return "EXCEPTION_CLOSE";
            }
            case 5: {
                return "CROSS_CONNECTION_CLOSE";
            }
        }
        return "unavailable close state";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown(Exception ex) {
        SocketStream socketStream = this;
        synchronized (socketStream) {
            if (this.closed) {
                if (logger.isLoggable(JeusMessage_Network._906_LEVEL)) {
                    logger.log(JeusMessage_Network._906_LEVEL, JeusMessage_Network._906, (Object)this);
                }
                return;
            }
            this.closed = true;
            this.notifyWaiter();
        }
        Collection replyListeners = this.clearReplyListeners();
        for (ReplyListener listener : replyListeners) {
            listener.connectionClosed(ex, this);
        }
        this.connectionManager.remove(this);
        this.finishCloseState(ex);
    }

    protected void finishCloseState(final Exception ex) {
        Runnable r;
        switch (this.closeState) {
            case 4: {
                if (logger.isLoggable(JeusMessage_Network._907_LEVEL)) {
                    logger.log(JeusMessage_Network._907_LEVEL, JeusMessage_Network._907, new Object[]{this, ex == null || ex.getMessage() == null ? "" : ex.toString()});
                }
                if (logger.isLoggable(JeusMessage_Network._940_LEVEL)) {
                    logger.log(JeusMessage_Network._940_LEVEL, JeusMessage_Network._940, this, (Throwable)ex);
                }
                this.close(ex);
                return;
            }
            case 1: {
                if (logger.isLoggable(JeusMessage_Network._936_LEVEL)) {
                    logger.log(JeusMessage_Network._936_LEVEL, JeusMessage_Network._936, (Object)this);
                }
                r = this.createCloserRunnable(null);
                break;
            }
            case 5: {
                if (logger.isLoggable(JeusMessage_Network._937_LEVEL)) {
                    logger.log(JeusMessage_Network._937_LEVEL, JeusMessage_Network._937, this, (Throwable)ex);
                }
                r = this.createCloserRunnable(ex);
                break;
            }
            case 2: 
            case 3: {
                if (logger.isLoggable(JeusMessage_Network._908_LEVEL)) {
                    logger.log(JeusMessage_Network._908_LEVEL, JeusMessage_Network._908, (Object)this);
                }
                r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Object object = SocketStream.this.closeStateLock;
                            synchronized (object) {
                                if (SocketStream.this.closeState != 4) {
                                    try {
                                        if (logger.isLoggable(JeusMessage_Network._909_LEVEL)) {
                                            logger.log(JeusMessage_Network._909_LEVEL, JeusMessage_Network._909, new Object[]{String.valueOf(JeusNetProperties.TIMEWAIT), this});
                                        }
                                        SocketStream.this.closeStateLock.wait(JeusNetProperties.TIMEWAIT);
                                    }
                                    catch (InterruptedException ex2) {
                                        ex2.printStackTrace();
                                    }
                                }
                            }
                            if (SocketStream.this.closeState == 4) {
                                if (logger.isLoggable(JeusMessage_Network._935_LEVEL)) {
                                    logger.log(JeusMessage_Network._935_LEVEL, JeusMessage_Network._935, this, (Throwable)ex);
                                }
                            } else if (logger.isLoggable(JeusMessage_Network._911_LEVEL)) {
                                logger.log(JeusMessage_Network._911_LEVEL, JeusMessage_Network._911, (Object)this);
                            }
                            SocketStream.this.close(null);
                        }
                        finally {
                            Endpoint.closerThreadList.remove(Thread.currentThread());
                        }
                    }
                };
                break;
            }
            default: {
                throw new RuntimeException("not allowed : " + this.closeState);
            }
        }
        try {
            if (logger.isLoggable(JeusMessage_Network._938_LEVEL)) {
                logger.log(JeusMessage_Network._938_LEVEL, JeusMessage_Network._938, (Object)this);
            }
            this.sendShutdownPacket(ex);
            if (this.closeState == 3) {
                this.closeAckSent = true;
            }
            Thread closer = new Thread(r);
            closer.setName("socket closer " + this);
            Endpoint.closerThreadList.add(closer);
            closer.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.close(ex);
        }
    }

    private Runnable createCloserRunnable(final Exception ex) {
        if (logger.isLoggable(JeusMessage_Network._912_LEVEL)) {
            logger.log(JeusMessage_Network._912_LEVEL, JeusMessage_Network._912, (Object)this);
        }
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Object object = SocketStream.this.closeStateLock;
                    synchronized (object) {
                        if (SocketStream.this.closeState != 2 && SocketStream.this.closeState != 4) {
                            try {
                                if (logger.isLoggable(JeusMessage_Network._913_LEVEL)) {
                                    logger.log(JeusMessage_Network._913_LEVEL, JeusMessage_Network._913, (Object)this);
                                }
                                SocketStream.this.closeStateLock.wait(JeusNetProperties.TIMEWAIT);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (SocketStream.this.closeState == 2) {
                        if (logger.isLoggable(JeusMessage_Network._914_LEVEL)) {
                            logger.log(JeusMessage_Network._914_LEVEL, JeusMessage_Network._914, (Object)this);
                        }
                    } else if (SocketStream.this.closeState == 4) {
                        if (logger.isLoggable(JeusMessage_Network._935_LEVEL)) {
                            logger.log(JeusMessage_Network._935_LEVEL, JeusMessage_Network._935, (Object)this);
                        }
                    } else if (logger.isLoggable(JeusMessage_Network._916_LEVEL)) {
                        logger.log(JeusMessage_Network._916_LEVEL, JeusMessage_Network._916, (Object)this);
                    }
                    SocketStream.this.close(ex);
                }
                finally {
                    Endpoint.closerThreadList.remove(Thread.currentThread());
                }
            }
        };
        return r;
    }

    public void sendShutdownPacket(Exception ex) throws IOException {
        if (ex instanceof CrossConnectionException) {
            this.write(NetworkControlPacket.CLOSE_CROSS_CONNECTION_PACKET);
        } else {
            this.write(NetworkControlPacket.CLOSE_PACKET);
        }
        if (logger.isLoggable(JeusMessage_Network._939_LEVEL)) {
            logger.log(JeusMessage_Network._939_LEVEL, JeusMessage_Network._939, (Object)this);
        }
    }

    void close(Exception ex) {
        if (logger.isLoggable(JeusMessage_Network._917_LEVEL)) {
            logger.log(JeusMessage_Network._917_LEVEL, JeusMessage_Network._917, (Object)this);
        }
        try {
            this.closeSocket();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.listener.connectionClosed(ex, this);
    }

    private void closeSocket() throws IOException {
        if (this.endpoint != null) {
            this.endpoint.close(null);
        }
        if (this.socket != null) {
            this.socket = null;
        }
    }

    protected synchronized void notifyWaiter() {
        if (logger.isLoggable(JeusMessage_Network._918_LEVEL)) {
            logger.log(JeusMessage_Network._918_LEVEL, JeusMessage_Network._918, (Object)this);
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processCloseMessage() {
        CrossConnectionException ex;
        Object object = this.closeStateLock;
        synchronized (object) {
            if (this.isCrossClosed) {
                if (logger.isLoggable(JeusMessage_Network._919_LEVEL)) {
                    logger.log(JeusMessage_Network._919_LEVEL, JeusMessage_Network._919, (Object)this);
                }
                this.closeState = 5;
                ex = new CrossConnectionException("received cross connection close request packet");
            } else if (this.closeState == 1) {
                if (logger.isLoggable(JeusMessage_Network._920_LEVEL)) {
                    logger.log(JeusMessage_Network._920_LEVEL, JeusMessage_Network._920, (Object)this);
                }
                this.closeState = 2;
                this.closeStateLock.notifyAll();
                ex = null;
            } else if (this.closeState == 0) {
                if (logger.isLoggable(JeusMessage_Network._921_LEVEL)) {
                    logger.log(JeusMessage_Network._921_LEVEL, JeusMessage_Network._921, (Object)this);
                }
                this.closeState = 3;
                ex = null;
            } else {
                return;
            }
        }
        this.shutdown(ex);
    }

    public void setClientSocketID(int connectionType) {
        this.socketID = new NodeInfo(this.getHostName(), this.getPort(), "", connectionType);
        this.socketID.setNotConnectable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (logger.isLoggable(JeusMessage_Network._922_LEVEL)) {
            logger.log(JeusMessage_Network._922_LEVEL, JeusMessage_Network._922, (Object)this);
        }
        Object object = this.closeStateLock;
        synchronized (object) {
            if (this.closeState != 0) {
                if (logger.isLoggable(JeusMessage_Network._923_LEVEL)) {
                    logger.log(JeusMessage_Network._923_LEVEL, JeusMessage_Network._923, (Object)this);
                }
                return;
            }
            this.closeState = 1;
        }
        this.shutdown(null);
    }

    public static SocketStream createSocketStream(Socket socket, ConnectionManager connectionManager, ConnectionListener listener, boolean onlyByteTransfer) {
        if (JeusBootstrapPropertyValues.isUpperJDK4()) {
            return new SocketStream14(socket, connectionManager, listener, onlyByteTransfer);
        }
        return new SocketStream(socket, connectionManager, listener, onlyByteTransfer);
    }

    public int getCloseState() {
        return this.closeState;
    }

    public StreamHandlerImpl getEndpoint() {
        return this.endpoint;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean write(Object message, ReplyListener receiver) throws IOException {
        boolean result;
        if (this.endpoint == null) {
            throw new IOException("connection is not established");
        }
        if (!this.endpoint.canWriteAsByte(message) && this.onlyByteTransfer) {
            if (!(message instanceof NetworkControlPacket)) throw new IllegalStateException("This SocketStream configured to transfer only bytes");
            byte[] msgBytes = NetworkControlPacket.convertByte((NetworkControlPacket)message, (StreamHandler)this.endpoint);
            byte[] requestHeader = this.makeRequestHeader(receiver, MessageConstant.NETWORK_CONTROL_PACKET_REQUEST_MAGIC_BYTES);
            result = this.endpoint.write(msgBytes, requestHeader);
        } else {
            byte[] requestHeader = this.makeRequestHeader(receiver);
            result = this.endpoint.write(message, requestHeader);
        }
        if (!logger.isLoggable(JeusMessage_Network._413_LEVEL)) return result;
        logger.log(JeusMessage_Network._413_LEVEL, JeusMessage_Network._413, new Object[]{message, this.socketString});
        return result;
    }

    public boolean write(byte[] message, ReplyListener receiver) throws IOException {
        return this.write(message, 0, message.length, receiver);
    }

    public boolean write(byte[] message, int offset, int length, ReplyListener receiver) throws IOException {
        if (this.endpoint == null) {
            throw new IOException("connection is not established");
        }
        byte[] requestHeader = this.makeRequestHeader(receiver);
        boolean result = this.endpoint.write(message, requestHeader);
        if (logger.isLoggable(JeusMessage_Network._413_LEVEL)) {
            logger.log(JeusMessage_Network._413_LEVEL, JeusMessage_Network._413, new Object[]{message, this.socketString});
        }
        return result;
    }

    protected byte[] makeRequestHeader(ReplyListener receiver) {
        return this.makeRequestHeader(receiver, MessageConstant.REQEUST_MAGIC_BYTES);
    }

    protected byte[] makeRequestHeader(ReplyListener receiver, byte[] header) {
        int msgSeq = this.registerReplyListener(receiver);
        byte[] requestHeader = new byte[8];
        System.arraycopy(header, 0, requestHeader, 0, header.length);
        ByteUtil.putInt(requestHeader, 4, msgSeq);
        return requestHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int registerReplyListener(ReplyListener receiver) {
        int msgSeq = this.seq.getAndIncrement();
        SocketStream socketStream = this;
        synchronized (socketStream) {
            if (this.closed) {
                throw new RuntimeException("The connection is already closed");
            }
            this.replyListenerTable.put(new Integer(msgSeq), receiver);
        }
        receiver.registerSocketStream(this, msgSeq);
        return msgSeq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean write(Object message) throws IOException {
        boolean result;
        if (this.endpoint == null) {
            throw new IOException("connection is not established");
        }
        if (!this.endpoint.canWriteAsByte(message) && this.onlyByteTransfer) {
            if (!(message instanceof NetworkControlPacket)) throw new IllegalStateException("This SocketStream configured to transfer only bytes");
            byte[] msgBytes = NetworkControlPacket.convertByte((NetworkControlPacket)message, (StreamHandler)this.endpoint);
            result = this.endpoint.write(msgBytes, MessageConstant.NETWORK_CONTROL_PACKET_MAGIC_BYTES);
        } else {
            result = this.endpoint.write(message);
        }
        if (!logger.isLoggable(JeusMessage_Network._413_LEVEL)) return result;
        logger.log(JeusMessage_Network._413_LEVEL, JeusMessage_Network._413, new Object[]{message, this.socketString});
        return result;
    }

    public boolean write(byte[] message) throws IOException {
        if (this.endpoint == null) {
            throw new IOException("connection is not established");
        }
        boolean result = this.endpoint.write(message);
        if (logger.isLoggable(JeusMessage_Network._413_LEVEL)) {
            logger.log(JeusMessage_Network._413_LEVEL, JeusMessage_Network._413, new Object[]{message, this.socketString});
        }
        return result;
    }

    public boolean write(byte[] message, int offset, int length) throws IOException {
        if (this.endpoint == null) {
            throw new IOException("connection is not established");
        }
        boolean result = this.endpoint.write(message, offset, length);
        if (logger.isLoggable(JeusMessage_Network._413_LEVEL)) {
            logger.log(JeusMessage_Network._413_LEVEL, JeusMessage_Network._413, new Object[]{message, this.socketString});
        }
        return result;
    }

    public ConnectionListener getListener() {
        return this.listener;
    }

    public String getIP() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHostName() {
        long time = System.currentTimeMillis();
        try {
            String string = this.socket.getInetAddress().getHostName();
            return string;
        }
        finally {
            if (System.currentTimeMillis() - time > JeusNetProperties.HOST_NAME_TIMEOUT) {
                logger.log(JeusMessage_Network._1029_LEVEL, JeusMessage_Network._1029, (Object)this.socket.getInetAddress());
            }
        }
    }

    public String getLocalIP() {
        return this.socket.getLocalAddress().getHostAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public String getLocalHostName() {
        return this.socket.getLocalAddress().getHostName();
    }

    public void setSocketID(SocketID socketID) {
        this.socketID = socketID;
        this.setSocketLog();
    }

    public SocketID getSocketID() {
        return this.socketID;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public boolean isEstablished() {
        return this.established;
    }

    public String toString() {
        return "[SocketStream(remote : " + (this.socketID == null ? "NULL" : this.socketID.toString()) + ", local : " + this.localSocketID + ", " + super.toString() + ")]";
    }

    public boolean isCrossClosed() {
        return this.isCrossClosed;
    }

    public void setEndpoint(StreamHandlerImpl endpoint) {
        this.endpoint = endpoint;
    }

    public Collection clearReplyListeners() {
        Map table = this.replyListenerTable;
        this.replyListenerTable = null;
        return table.values();
    }

    public boolean writeReply(byte[] message) throws IOException {
        Integer seqInt = (Integer)currentReplySequence.get();
        if (seqInt == null) {
            throw new RuntimeException("No reply sequence in this thread");
        }
        return this.writeReply(message, (int)seqInt, (ReplyListener)null);
    }

    public boolean writeReply(byte[] message, int replyID) throws IOException {
        return this.writeReply(message, replyID, (ReplyListener)null);
    }

    public boolean writeReply(byte[] message, ReplyListener replyListener) throws IOException {
        Integer seqInt = (Integer)currentReplySequence.get();
        if (seqInt == null) {
            throw new RuntimeException("No reply sequence in this thread");
        }
        return this.writeReply(message, (int)seqInt, replyListener);
    }

    public boolean writeReply(byte[] message, int offset, int length, int replyID) throws IOException {
        return this.writeReply(message, offset, length, replyID, null);
    }

    public boolean writeReply(byte[] message, int offset, int length, int replyID, ReplyListener replyListener) throws IOException {
        if (this.endpoint == null) {
            throw new IOException("connection is not established");
        }
        byte[] requestHeader = this.getReplyHeader(replyID, replyListener);
        boolean result = this.endpoint.write(message, offset, length, requestHeader);
        if (logger.isLoggable(JeusMessage_Network._414_LEVEL)) {
            logger.log(JeusMessage_Network._414_LEVEL, JeusMessage_Network._414, new Object[]{message, this.socketString});
        }
        return result;
    }

    public boolean writeReply(byte[] message, int replyID, ReplyListener replyListener) throws IOException {
        return this.writeReply(message, 0, message.length, replyID, replyListener);
    }

    public boolean writeReply(Object obj) throws IOException {
        return this.writeReply(obj, null);
    }

    public boolean writeReply(Object obj, int replyID) throws IOException {
        return this.writeReply(obj, replyID, null);
    }

    public boolean writeReply(Object obj, ReplyListener replyListener) throws IOException {
        Integer seqInt = (Integer)currentReplySequence.get();
        if (seqInt == null) {
            throw new RuntimeException("No reply sequence in this thread");
        }
        return this.writeReply(obj, (int)seqInt, replyListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean writeReply(Object obj, int seqInt, ReplyListener replyListener) throws IOException {
        boolean result;
        if (!this.endpoint.canWriteAsByte(obj) && this.onlyByteTransfer) {
            if (!(obj instanceof NetworkControlPacket)) throw new IllegalStateException("This SocketStream configured to transfer only bytes");
            byte[] msgBytes = NetworkControlPacket.convertByte((NetworkControlPacket)obj, (StreamHandler)this.endpoint);
            byte[] replyHeader = this.getReplyHeader(seqInt, replyListener, MessageConstant.NETWORK_CONTROL_PACKET_REPLY_MAGIC_BYTES, MessageConstant.NETWORK_CONTROL_PACKET_REPLY_REQUEST_MAGIC_BYTES);
            result = this.endpoint.write(msgBytes, replyHeader);
        } else {
            byte[] replyHeader = this.getReplyHeader(seqInt, replyListener);
            result = this.endpoint.write(obj, replyHeader);
        }
        if (!logger.isLoggable(JeusMessage_Network._414_LEVEL)) return result;
        logger.log(JeusMessage_Network._414_LEVEL, JeusMessage_Network._414, new Object[]{obj, this.socketString});
        return result;
    }

    protected byte[] getReplyHeader(int seq, ReplyListener replyListener) throws IOException {
        return this.getReplyHeader(seq, replyListener, MessageConstant.REPLY_MAGIC_BYTES, MessageConstant.REPLY_REQEUST_MAGIC_BYTES);
    }

    protected byte[] getReplyHeader(int seq, ReplyListener replyListener, byte[] replyMagic, byte[] requestReplyMagic) throws IOException {
        byte[] replyHeader;
        if (this.endpoint == null) {
            throw new IOException("connection is not established");
        }
        if (seq < 0) {
            throw new RuntimeException("No reply sequence in this thread");
        }
        if (replyListener == null) {
            replyHeader = new byte[8];
            System.arraycopy(replyMagic, 0, replyHeader, 0, replyMagic.length);
            ByteUtil.putInt(replyHeader, 4, seq);
        } else {
            replyHeader = new byte[12];
            System.arraycopy(requestReplyMagic, 0, replyHeader, 0, requestReplyMagic.length);
            ByteUtil.putInt(replyHeader, 4, seq);
            ByteUtil.putInt(replyHeader, 8, this.registerReplyListener(replyListener));
        }
        return replyHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterReplyListener(int seq) {
        SocketStream socketStream = this;
        synchronized (socketStream) {
            if (!this.closed) {
                this.replyListenerTable.remove(new Integer(seq));
            }
        }
    }

    protected void setSocketLog() {
        block2: {
            try {
                this.socketString = this.socket.toString();
            }
            catch (Throwable t) {
                if (this.getSocketID() == null) break block2;
                this.socketString = this.getSocketID().toString();
            }
        }
    }

    public SocketID getLocalSocketID() {
        return this.localSocketID;
    }

    public int getReplyID() {
        Integer seqInt = (Integer)currentReplySequence.get();
        if (seqInt == null) {
            throw new RuntimeException("No reply sequence in this thread");
        }
        return seqInt;
    }

    public class MessageProcessor
    implements Runnable {
        private Object packet;
        private byte[] header;
        private int magicNumber;

        MessageProcessor(Object packet, byte[] header, int magicNumber) {
            this.packet = packet;
            this.header = header;
            this.magicNumber = magicNumber;
        }

        public void run() {
            try {
                switch (this.magicNumber) {
                    case -1: {
                        if (logger.isLoggable(JeusMessage_Network._924_LEVEL)) {
                            logger.log(JeusMessage_Network._924_LEVEL, JeusMessage_Network._924, (Object)this);
                        }
                        this.handleControlPacket((NetworkControlPacket)this.packet);
                        break;
                    }
                    case 0: {
                        if (logger.isLoggable(JeusMessage_Network._925_LEVEL)) {
                            logger.log(JeusMessage_Network._925_LEVEL, JeusMessage_Network._925, (Object)this);
                        }
                        SocketStream.this.listener.receiveMessage(this.packet, SocketStream.this, null);
                        break;
                    }
                    case 126311150: 
                    case 126311407: {
                        int seq = this.getSequenceNumber();
                        if (logger.isLoggable(JeusMessage_Network._926_LEVEL)) {
                            logger.log(JeusMessage_Network._926_LEVEL, JeusMessage_Network._926, new Object[]{Integer.toString(seq), this});
                        }
                        this.callRequestHandler(SocketStream.this.listener, this.packet, null, new Integer(seq));
                        break;
                    }
                    case 126311422: 
                    case 126311662: {
                        Integer key;
                        ReplyListener replyListener;
                        int seq = this.getSequenceNumber();
                        if (logger.isLoggable(JeusMessage_Network._927_LEVEL)) {
                            logger.log(JeusMessage_Network._927_LEVEL, JeusMessage_Network._927, new Object[]{Integer.toString(seq), this});
                        }
                        if ((replyListener = this.getReplyListener(key = new Integer(seq))) == null) {
                            if (logger.isLoggable(JeusMessage_Network._928_LEVEL)) {
                                logger.log(JeusMessage_Network._928_LEVEL, JeusMessage_Network._928, new Object[]{Integer.toString(seq), this, this.packet});
                            }
                            break;
                        }
                        replyListener.receiveMessage(this.packet, SocketStream.this, new Object[]{key, null});
                        break;
                    }
                    case 126311423: 
                    case 126311918: {
                        Integer key;
                        ReplyListener replyListener;
                        int seq = this.getSequenceNumber();
                        if (logger.isLoggable(JeusMessage_Network._929_LEVEL)) {
                            logger.log(JeusMessage_Network._929_LEVEL, JeusMessage_Network._929, new Object[]{Integer.toString(seq), this});
                        }
                        if ((replyListener = this.getReplyListener(key = new Integer(seq))) == null) {
                            if (logger.isLoggable(JeusMessage_Network._928_LEVEL)) {
                                logger.log(JeusMessage_Network._928_LEVEL, JeusMessage_Network._928, new Object[]{Integer.toString(seq), this, this.packet});
                            }
                            break;
                        }
                        seq = ByteUtil.convertToInt(this.header, 8);
                        this.callRequestHandler(replyListener, this.packet, key, new Integer(seq));
                        break;
                    }
                    default: {
                        if (logger.isLoggable(JeusMessage_Network._930_LEVEL)) {
                            logger.log(JeusMessage_Network._930_LEVEL, JeusMessage_Network._930, new Object[]{Integer.toString(this.magicNumber), this});
                        }
                        throw new RuntimeException();
                    }
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(JeusMessage_Network._931_LEVEL)) {
                    logger.log(JeusMessage_Network._931_LEVEL, JeusMessage_Network._931, (Object)this);
                }
                SocketStream.this.receiveException(e, null);
            }
        }

        private int getSequenceNumber() {
            int seq;
            if (logger.isLoggable(JeusMessage_Network._932_LEVEL)) {
                logger.log(JeusMessage_Network._932_LEVEL, JeusMessage_Network._932, (Object)this);
            }
            if ((seq = ByteUtil.convertToInt(this.header, 4)) < 0) {
                throw new RuntimeException("negative seq received");
            }
            return seq;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void callRequestHandler(MessageHandler listener, Object buf, Integer seqAimedByThisReply, Integer seqToReply) throws Exception {
            currentReplySequence.set(seqToReply);
            try {
                listener.receiveMessage(buf, SocketStream.this, new Object[]{seqAimedByThisReply, seqToReply});
            }
            finally {
                currentReplySequence.set(NO_REPLY_SEQ_INT);
            }
        }

        private void handleControlPacket(NetworkControlPacket msg) throws Exception {
            if (logger.isLoggable(JeusMessage_Network._933_LEVEL)) {
                logger.log(JeusMessage_Network._933_LEVEL, JeusMessage_Network._933, new Object[]{msg, msg.getSocketID(), this});
            }
            switch (msg.getCode()) {
                case 1: {
                    SocketID peerSocketID = msg.getSocketID();
                    if (peerSocketID instanceof NoListenID) {
                        SocketStream.this.setClientSocketID(peerSocketID.getConnectionType());
                        this.acceptConnection(msg);
                        break;
                    }
                    SocketStream.this.setSocketID(peerSocketID);
                    this.acceptConnectionWithLock(msg);
                    break;
                }
                case 2: {
                    this.connectionAccepted(msg);
                    SocketStream.this.notifyWaiter();
                    break;
                }
                case 4: {
                    SocketStream.this.processCloseMessage();
                    break;
                }
                case 8: {
                    SocketStream.this.isCrossClosed = true;
                    SocketStream.this.processCloseMessage();
                    break;
                }
                case 5: {
                    this.processPingMessage();
                    break;
                }
                case 6: {
                    this.processPingAckMessage(msg);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }

        private void processPingAckMessage(NetworkControlPacket msg) throws Exception {
            int seq = this.getSequenceNumber();
            Integer key = new Integer(seq);
            ReplyListener replyListener = this.getReplyListener(key);
            if (replyListener == null) {
                if (logger.isLoggable(JeusMessage_Network._934_LEVEL)) {
                    logger.log(JeusMessage_Network._934_LEVEL, JeusMessage_Network._934, new Object[]{msg.getSocketID(), this});
                }
            } else {
                replyListener.receiveMessage(this.packet, SocketStream.this, new Object[]{key, null});
            }
        }

        private synchronized ReplyListener getReplyListener(Integer key) {
            if (!SocketStream.this.closed) {
                return (ReplyListener)SocketStream.this.replyListenerTable.get(key);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processPingMessage() throws IOException {
            int seq = this.getSequenceNumber();
            currentReplySequence.set(new Integer(seq));
            try {
                NetworkControlPacket packet = new NetworkControlPacket(6, SocketStream.this.localSocketID.getConnectionType());
                packet.setSocketID(SocketStream.this.localSocketID);
                SocketStream.this.writeReply(packet);
            }
            finally {
                currentReplySequence.set(NO_REPLY_SEQ_INT);
            }
        }

        private void connectionAccepted(NetworkControlPacket msg) throws Exception {
            int connectionType = msg.getConnectionType();
            SocketStream.this.listener.connectionAccepted(SocketStream.this, connectionType, msg.getData());
            SocketStream.this.connectionManager.addConnection(SocketStream.this, connectionType);
            SocketStream.this.established = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acceptConnectionWithLock(NetworkControlPacket msg) throws IOException {
            SocketStream.this.connectionManager.getAcceptTicket(SocketStream.this.socketID);
            try {
                this.acceptConnection(msg);
            }
            finally {
                SocketStream.this.connectionManager.releaseTicket(SocketStream.this.socketID);
            }
        }

        private void acceptConnection(NetworkControlPacket msg) throws IOException {
            NetworkControlPacket packet = new NetworkControlPacket(2, SocketStream.this.localSocketID.getConnectionType());
            packet.setSocketID(SocketStream.this.localSocketID);
            int connectionType = msg.getConnectionType();
            ((AcceptorConnectionListener)SocketStream.this.listener).connectionAllowed(SocketStream.this, packet, connectionType, msg.getData());
            SocketStream.this.connectionManager.addConnection(SocketStream.this, connectionType);
        }
    }
}

