/*
 * Decompiled with CFR 0.152.
 */
package jeus.net.impl;

import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jeus.io.Selector;
import jeus.io.SocketListener;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.handler.StreamContentReceiver;
import jeus.io.helper.IOComponentCreator;
import jeus.io.impl.StreamHandlerImpl;
import jeus.net.AcceptorConnectionListener;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.impl.ConnectionManager;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;

public abstract class Acceptor
implements SocketListener {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.net");
    protected ConnectionManager connectionManager;
    private StreamContentHandlerCreator contentHandlerCreator;
    private ConnectionListenerFactory listenerFactory;
    protected IOComponentCreator creator;
    protected Selector selector;
    protected Object sslContext;
    private boolean onlyByteTransfer;
    private Map sslProperties;
    private static final Map DEFAULT_SSL_PROPERTIES;

    public Acceptor(Selector selector, IOComponentCreator creator, ConnectionManager connectionManager, StreamContentHandlerCreator contentHandlerCreator, ConnectionListenerFactory listenerFactory, Object sslContext, boolean onlyByteTransfer) {
        this(selector, creator, connectionManager, contentHandlerCreator, listenerFactory, sslContext, null, onlyByteTransfer);
    }

    public Acceptor(Selector selector, IOComponentCreator creator, ConnectionManager connectionManager, StreamContentHandlerCreator contentHandlerCreator, ConnectionListenerFactory listenerFactory, Object sslContext, Map sslProperties, boolean onlyByteTransfer) {
        if (logger.isLoggable(JeusMessage_Network._500_LEVEL)) {
            logger.log(JeusMessage_Network._500_LEVEL, JeusMessage_Network._500, (Object)creator.creatorName);
        }
        this.creator = creator;
        this.connectionManager = connectionManager;
        this.contentHandlerCreator = contentHandlerCreator;
        this.listenerFactory = listenerFactory;
        this.sslContext = sslContext;
        this.sslProperties = sslProperties == null ? DEFAULT_SSL_PROPERTIES : sslProperties;
        this.selector = selector;
        this.onlyByteTransfer = onlyByteTransfer;
    }

    public abstract void init(String var1, SocketID var2) throws IOException;

    public void onSocket(Socket socket) {
        try {
            if (logger.isLoggable(JeusMessage_Network._501_LEVEL)) {
                logger.log(JeusMessage_Network._501_LEVEL, JeusMessage_Network._501, (Object)socket);
            }
            if (logger.isLoggable(JeusMessage_Network._502_LEVEL)) {
                logger.log(JeusMessage_Network._502_LEVEL, JeusMessage_Network._502, (Object)socket);
            }
            ConnectionListener listener = this.listenerFactory.createConnectionListener(socket, null);
            if (logger.isLoggable(JeusMessage_Network._503_LEVEL)) {
                logger.log(JeusMessage_Network._503_LEVEL, JeusMessage_Network._503, (Object)socket);
            }
            SocketStream sockStream = SocketStream.createSocketStream(socket, this.connectionManager, listener, this.onlyByteTransfer);
            ((AcceptorConnectionListener)listener).connectionEstablished(sockStream);
            if (logger.isLoggable(JeusMessage_Network._504_LEVEL)) {
                logger.log(JeusMessage_Network._504_LEVEL, JeusMessage_Network._504, (Object)socket);
            }
            StreamHandlerImpl endpoint = this.creator.createStreamHandler((Object)socket, (StreamContentReceiver)sockStream, this.contentHandlerCreator, this.sslContext, this.sslProperties);
            sockStream.setEndpoint(endpoint);
            if (logger.isLoggable(JeusMessage_Network._505_LEVEL)) {
                logger.log(JeusMessage_Network._505_LEVEL, JeusMessage_Network._505, new Object[]{socket, this.connectionManager == null ? null : this.connectionManager.getLocalListenSocketID()});
            }
            this.selector.addSelectItem(endpoint);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public abstract void destroy();

    public abstract int getServerSocketPort();

    static {
        HashMap<String, Boolean> defaultSSLProperties = new HashMap<String, Boolean>();
        defaultSSLProperties.put("useClientMode", Boolean.FALSE);
        DEFAULT_SSL_PROPERTIES = Collections.unmodifiableMap(defaultSSLProperties);
    }
}

