/*
 * Decompiled with CFR 0.152.
 */
package jeus.net.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import jeus.io.Selector;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.helper.IOComponentCreator;
import jeus.net.ConnectionListenerFactory;
import jeus.net.SocketID;
import jeus.net.impl.Acceptor;
import jeus.net.impl.ConnectionManager;
import jeus.util.message.JeusMessage_Network;
import jeus.util.properties.JeusNetProperties;

public class ServerSocketAcceptor
extends Acceptor {
    private jeus.io.Acceptor ioAcceptor;
    private int backlog;

    public ServerSocketAcceptor(Selector selector, IOComponentCreator creator, ConnectionManager connectionManager, StreamContentHandlerCreator contentHandlerCreator, ConnectionListenerFactory listenerFactory, Object sslContext, boolean onlyByteTransfer, int backlog) {
        this(selector, creator, connectionManager, contentHandlerCreator, listenerFactory, sslContext, null, onlyByteTransfer, backlog);
    }

    public ServerSocketAcceptor(Selector selector, IOComponentCreator creator, ConnectionManager connectionManager, StreamContentHandlerCreator contentHandlerCreator, ConnectionListenerFactory listenerFactory, Object sslContext, Map sslProperties, boolean onlyByteTransfer, int backlog) {
        super(selector, creator, connectionManager, contentHandlerCreator, listenerFactory, sslContext, sslProperties, onlyByteTransfer);
        this.backlog = backlog;
        if (logger.isLoggable(JeusMessage_Network._803_LEVEL)) {
            logger.log(JeusMessage_Network._803_LEVEL, JeusMessage_Network._803, (Object)(connectionManager == null ? null : connectionManager.getLocalListenSocketID()));
        }
    }

    public void init(String name, SocketID listenSocketID) throws IOException {
        if (logger.isLoggable(JeusMessage_Network._804_LEVEL)) {
            logger.log(JeusMessage_Network._804_LEVEL, JeusMessage_Network._804, this.connectionManager == null ? null : this.connectionManager.getLocalListenSocketID());
        }
        InetAddress listenHost = null;
        if (listenSocketID.getHost() != null) {
            listenHost = InetAddress.getByName(listenSocketID.getHost());
        }
        this.ioAcceptor = this.creator.createAcceptor(listenSocketID.getBasePort(), this, this.sslContext, this.backlog, listenHost, JeusNetProperties.REUSE_ADDRESS);
        Thread acceptorThread = new Thread((Runnable)this.ioAcceptor, name);
        acceptorThread.setDaemon(true);
        acceptorThread.start();
    }

    public void destroy() {
        if (logger.isLoggable(JeusMessage_Network._805_LEVEL)) {
            logger.log(JeusMessage_Network._805_LEVEL, JeusMessage_Network._805, this.connectionManager == null ? null : this.connectionManager.getLocalListenSocketID());
        }
        this.ioAcceptor.stop();
    }

    public int getServerSocketPort() {
        return this.ioAcceptor.getRealListenPort();
    }
}

