/*
 * Decompiled with CFR 0.152.
 */
package jeus.net.impl;

import jeus.net.ConnectorException;
import jeus.net.Endpoint;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.SocketStreamResurrectListener;
import jeus.util.ScheduleTask;

public class SocketStreamWatchTask
extends ScheduleTask {
    private SocketID socketID;
    private SocketStreamResurrectListener listener;
    private Object piggybackedData;
    private int connectTimeout;
    private int readTimeout;
    private Endpoint endpoint;

    public SocketStreamWatchTask(SocketID socketID, SocketStreamResurrectListener listener, Endpoint endpoint, Object piggybackedData, int connectTimeout, int readTimeout) {
        this.socketID = socketID;
        this.listener = listener;
        this.endpoint = endpoint;
        this.piggybackedData = piggybackedData;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public void run() {
        try {
            SocketStream sockStream = this.endpoint.getSocketStream(this.socketID, 1, this.piggybackedData, this.connectTimeout, this.readTimeout);
            this.cancel();
            this.listener.connectionActivated(sockStream);
        }
        catch (ConnectorException e) {
            this.listener.connectionNotActivated(this.socketID, this);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public synchronized void cancel() {
        this.endpoint.cancelWatchSocketStream(this.socketID);
    }

    public void cancelTimer() {
        super.cancel();
    }
}

