/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.http;

import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeus.rmi.http.ServletClientException;
import jeus.rmi.http.ServletCommandHandler;
import jeus.rmi.http.ServletForwardCommand;
import jeus.rmi.http.ServletServerException;
import jeus.util.logging.JeusLogger;

public class ServletHandler
extends HttpServlet {
    private int ContentLength;
    private String QueryString;
    private String RequestMethod;
    private String ServerName;
    private int ServerPort;
    private static ServletCommandHandler[] commands = new ServletCommandHandler[]{new ServletForwardCommand()};
    private static Hashtable commandLookup = new Hashtable();
    private JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.rmi");

    public void service(HttpServletRequest req, HttpServletResponse res) {
        ServletOutputStream out = null;
        try {
            String param;
            String command;
            this.ContentLength = req.getContentLength();
            this.QueryString = req.getQueryString();
            this.RequestMethod = req.getMethod();
            this.ServerName = req.getServerName();
            this.ServerPort = req.getServerPort();
            out = res.getOutputStream();
            int delim = this.QueryString.indexOf("=");
            if (delim == -1) {
                command = this.QueryString;
                param = "";
            } else {
                command = this.QueryString.substring(0, delim);
                param = this.QueryString.substring(delim + 1);
            }
            ServletCommandHandler handler = (ServletCommandHandler)commandLookup.get(command);
            if (handler != null) {
                try {
                    handler.execute(param, req, res);
                }
                catch (ServletClientException e) {
                    this.returnClientError(res, "client error: " + e.getMessage());
                    this.logger.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                }
                catch (ServletServerException e) {
                    this.returnServerError(res, "internal server error: " + e.getMessage());
                    this.logger.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                }
            } else {
                this.returnClientError(res, "invalid command: " + command);
            }
        }
        catch (Exception e) {
            try {
                this.returnServerError(res, "internal error: " + e.getMessage());
            }
            catch (IOException io) {
                this.logger.log(Level.SEVERE, io.getMessage(), (Throwable)io);
            }
        }
    }

    public void returnClientError(HttpServletResponse res, String message) throws IOException {
        res.sendError(400, "Java RMI Client Error : " + message);
    }

    public void returnServerError(HttpServletResponse res, String message) throws IOException {
        res.sendError(500, "Java RMI Server Error : " + message);
    }

    static {
        for (int i = 0; i < commands.length; ++i) {
            commandLookup.put(commands[i].getName(), commands[i]);
        }
    }
}

