/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.runtime;

import java.security.AccessController;
import java.util.LinkedList;
import jeus.rmi.impl.runtime.Executor;
import jeus.rmi.impl.runtime.NewThreadAction;
import jeus.util.properties.JeusRMIProperties;

public final class ThreadPool
implements Executor {
    private static final long idleTimeout = JeusRMIProperties.THREAD_POOL_IDLE_TO;
    private static final int maxThreadCount = JeusRMIProperties.THREAD_POOL_MAX;
    private final ThreadGroup threadGroup;
    private final Object lock = new Object();
    private int totalThreads = 0;
    private int idleThreads = 0;
    private int maxThreads = -1;
    private final LinkedList queue = new LinkedList();

    ThreadPool(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
        if (maxThreadCount > 0) {
            this.maxThreads = maxThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable, String name) {
        Task task = new Task(runnable, name);
        Object object = this.lock;
        synchronized (object) {
            if (this.maxThreads > 0) {
                if (this.queue.size() < this.idleThreads || this.totalThreads >= this.maxThreads) {
                    this.queue.addLast(task);
                    this.lock.notify();
                } else {
                    Thread t = (Thread)AccessController.doPrivileged(new NewThreadAction(this.threadGroup, new Worker(task), name, true));
                    t.start();
                    ++this.totalThreads;
                }
            } else if (this.queue.size() < this.idleThreads) {
                this.queue.addLast(task);
                this.lock.notify();
            } else {
                Thread t = (Thread)AccessController.doPrivileged(new NewThreadAction(this.threadGroup, new Worker(task), name, true));
                t.start();
                ++this.totalThreads;
            }
        }
    }

    private class Worker
    implements Runnable {
        private Task first;

        Worker(Task first) {
            this.first = first;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                Task task = this.first;
                this.first = null;
                while (true) {
                    task.runnable.run();
                    Object object = ThreadPool.this.lock;
                    synchronized (object) {
                        if (ThreadPool.this.queue.isEmpty()) {
                            block14: {
                                Object var5_4;
                                Thread.currentThread().setName("RMI Idle");
                                ThreadPool.this.idleThreads++;
                                try {
                                    try {
                                        ThreadPool.this.lock.wait(idleTimeout);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        var5_4 = null;
                                        ThreadPool.this.idleThreads--;
                                        break block14;
                                    }
                                    var5_4 = null;
                                }
                                catch (Throwable throwable) {
                                    var5_4 = null;
                                    ThreadPool.this.idleThreads--;
                                    throw throwable;
                                }
                                ThreadPool.this.idleThreads--;
                            }
                            if (ThreadPool.this.queue.isEmpty()) {
                                // MONITOREXIT @DISABLED, blocks:[0, 6, 11, 12, 13] lbl33 : MonitorExitStatement: MONITOREXIT : object
                                Object var8_6 = null;
                                break;
                            }
                        }
                        task = (Task)ThreadPool.this.queue.removeFirst();
                        Thread.currentThread().setName("RMI " + task.name);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Object object = ThreadPool.this.lock;
                synchronized (object) {
                    ThreadPool.this.totalThreads--;
                    throw throwable;
                }
            }
            Object object = ThreadPool.this.lock;
            synchronized (object) {
                ThreadPool.this.totalThreads--;
                return;
            }
        }
    }

    private static class Task {
        final Runnable runnable;
        final String name;

        Task(Runnable runnable, String name) {
            this.runnable = runnable;
            this.name = name;
        }
    }
}

