/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.SkeletonNotFoundException;
import jeus.rmi.impl.server.UnicastRef;
import jeus.rmi.impl.server.UnicastRef2;
import jeus.rmi.impl.transport.Endpoint;
import jeus.rmi.impl.transport.EndpointCreator;
import jeus.rmi.impl.transport.LiveRef;
import jeus.rmi.spec.server.LogStream;
import jeus.rmi.spec.server.ObjID;
import jeus.rmi.spec.server.RemoteRef;
import jeus.rmi.spec.server.RemoteStub;
import jeus.rmi.spec.server.Skeleton;
import jeus.util.properties.JeusRMIProperties;

public final class RemoteProxy
extends RemoteStub {
    static int logLevel = LogStream.parseLevel(JeusRMIProperties.SERVER_LOG_LEVEL);
    private static Class[] stubConsParamTypes = new Class[]{RemoteRef.class};

    private RemoteProxy() {
    }

    public static RemoteStub getStub(Remote object, RemoteRef ref) throws StubNotFoundException {
        Class cl = null;
        try {
            cl = RemoteProxy.getRemoteClass(object.getClass());
            return RemoteProxy.getStub(cl.getName(), cl, ref);
        }
        catch (ClassNotFoundException ex) {
            throw new StubNotFoundException("Object does not implement an interface that extends java.rmi.Remote: " + object.getClass().getName());
        }
    }

    public static RemoteStub getStub(String classname, RemoteRef ref) throws StubNotFoundException {
        return RemoteProxy.getStub(classname, null, ref);
    }

    public static RemoteStub getStub(String classname, Class fromClass, RemoteRef ref) throws StubNotFoundException {
        String stubname = classname + "_Stub";
        RemoteStub stub = null;
        try {
            Class stubcl = RemoteProxy.loadClassFromClass(stubname, fromClass);
            Constructor cons = stubcl.getConstructor(stubConsParamTypes);
            stub = (RemoteStub)cons.newInstance(ref);
        }
        catch (ClassNotFoundException e) {
            throw new StubNotFoundException("Stub class not found: " + stubname, e);
        }
        catch (NoSuchMethodException e) {
            throw new StubNotFoundException("Stub class missing constructor: " + stubname, e);
        }
        catch (InstantiationException e) {
            throw new StubNotFoundException("Can't create instance of stub class: " + stubname, e);
        }
        catch (IllegalAccessException e) {
            throw new StubNotFoundException("Stub class constructor not public: " + stubname, e);
        }
        catch (InvocationTargetException e) {
            throw new StubNotFoundException("Exception creating instance of stub class: " + stubname, e);
        }
        catch (ClassCastException e) {
            throw new StubNotFoundException("Stub class not instance of RemoteStub: " + stubname, e);
        }
        return stub;
    }

    public static RemoteStub getStub(String stubname, int id, String host, int port) throws RemoteException {
        ObjID objID = new ObjID(id);
        Endpoint ep = EndpointCreator.createEndpoint(host, port);
        LiveRef ref = new LiveRef(objID, ep, false);
        return RemoteProxy.getStub(stubname, (RemoteRef)new UnicastRef(ref));
    }

    public static RemoteStub getStub(String stubname, int id, String host, int port, RMIClientSocketFactory csf) throws RemoteException {
        ObjID objID = new ObjID(id);
        Endpoint ep = EndpointCreator.createEndpoint(host, port, csf, null);
        LiveRef ref = new LiveRef(objID, ep, false);
        return RemoteProxy.getStub(stubname, (RemoteRef)new UnicastRef2(ref));
    }

    public static Skeleton getSkeleton(Remote object) throws SkeletonNotFoundException {
        Class cl;
        try {
            cl = RemoteProxy.getRemoteClass(object.getClass());
        }
        catch (ClassNotFoundException ex) {
            throw new SkeletonNotFoundException("Object does not implement an interface that extends java.rmi.Remote: " + object.getClass().getName());
        }
        String skelname = cl.getName() + "_Skel";
        try {
            Class skelcl = RemoteProxy.loadClassFromClass(skelname, cl);
            return (Skeleton)skelcl.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new SkeletonNotFoundException("Skeleton class not found: " + skelname, ex);
        }
        catch (InstantiationException ex) {
            throw new SkeletonNotFoundException("Can't create skeleton: " + skelname, ex);
        }
        catch (IllegalAccessException ex) {
            throw new SkeletonNotFoundException("No public constructor: " + skelname, ex);
        }
        catch (ClassCastException ex) {
            throw new SkeletonNotFoundException("Skeleton not of correct class: " + skelname, ex);
        }
    }

    private static Class loadClassFromClass(String classname, Class fromClass) throws ClassNotFoundException {
        ClassLoader loader = null;
        if (fromClass != null) {
            loader = fromClass.getClassLoader();
        }
        if (loader != null) {
            return loader.loadClass(classname);
        }
        return Class.forName(classname);
    }

    static Class getRemoteClass(Class cl) throws ClassNotFoundException {
        while (cl != null) {
            Class<?>[] interfaces = cl.getInterfaces();
            for (int i = interfaces.length - 1; i >= 0; --i) {
                if (!Remote.class.isAssignableFrom(interfaces[i])) continue;
                return cl;
            }
            cl = cl.getSuperclass();
        }
        throw new ClassNotFoundException("class does not implement java.rmi.Remote");
    }

    public String[] getRemoteInterfaces() {
        return new String[0];
    }

    public String getImpleName() {
        return null;
    }
}

