/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import jeus.ejb.bean.rmi.JEUSRMIStub;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.server.RemoteProxy;
import jeus.rmi.impl.transport.ClientStreamRemoteCall;
import jeus.rmi.impl.transport.Connection;
import jeus.rmi.impl.transport.LiveRef;
import jeus.rmi.spec.ClientInterceptor;
import jeus.rmi.spec.RemoteCall;
import jeus.rmi.spec.server.Operation;
import jeus.rmi.spec.server.RemoteObject;
import jeus.rmi.spec.server.RemoteObjectInvocationHandler;
import jeus.rmi.spec.server.RemoteRef;
import jeus.util.properties.JeusRMIProperties;

public class UnicastRef
implements RemoteRef {
    public static final Log clientRefLog = Log.getLog("jeus.rmi.client.ref", "transport", RemoteProxy.logLevel);
    public static final Log clientCallLog;
    protected LiveRef ref;

    public UnicastRef() {
    }

    public UnicastRef(LiveRef liveRef) {
        this.ref = liveRef;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Remote obj, Method method, Object[] params, long opnum, boolean isSimpleParams, byte returnTypeNumber, boolean isVoidReturn, int methodNum) throws Exception {
        if (clientRefLog.isLoggable(Log.VERBOSE)) {
            clientRefLog.log(Log.VERBOSE, "method: " + method);
        }
        if (clientCallLog.isLoggable(Log.VERBOSE)) {
            this.logClientCall(obj, method);
        }
        Connection conn = this.ref.getChannel().newConnection();
        RemoteCall call = null;
        boolean reuse = true;
        boolean alreadyFreed = false;
        try {
            try {
                Object object;
                block31: {
                    if (clientRefLog.isLoggable(Log.VERBOSE)) {
                        clientRefLog.log(Log.VERBOSE, "opnum = " + opnum);
                    }
                    call = new ClientStreamRemoteCall(conn, this.ref.getObjID(), -1, opnum, isSimpleParams, returnTypeNumber, isVoidReturn, method, obj.getClass().getClassLoader());
                    ClientInterceptor interceptor = null;
                    if (obj instanceof JEUSRMIStub) {
                        interceptor = ((JEUSRMIStub)obj).getClientInterceptor();
                    } else if (obj instanceof Proxy) {
                        interceptor = ((RemoteObjectInvocationHandler)Proxy.getInvocationHandler(obj)).getClientInterceptor();
                    }
                    call.setClientIntercepter(interceptor);
                    DataOutput dout = null;
                    try {
                        int i;
                        Class<?>[] types;
                        if (isSimpleParams) {
                            dout = call.getDataOutputStream();
                            types = method.getParameterTypes();
                            for (i = 0; i < types.length; ++i) {
                                UnicastRef.marshalDataValue(types[i], params[i], dout);
                            }
                        } else {
                            dout = call.getOutputStream();
                            types = method.getParameterTypes();
                            for (i = 0; i < types.length; ++i) {
                                UnicastRef.marshalValue(types[i], params[i], (ObjectOutput)dout);
                            }
                        }
                    }
                    catch (IOException e) {
                        clientRefLog.log(Log.BRIEF, "IOException marshalling arguments: ", e);
                        throw new MarshalException("error marshalling arguments", e);
                    }
                    call.executeCall();
                    if (!isVoidReturn) break block31;
                    Object e = null;
                    Object var21_25 = null;
                    if (!alreadyFreed) {
                        if (clientRefLog.isLoggable(Log.BRIEF)) {
                            clientRefLog.log(Log.BRIEF, "free connection (reuse = " + reuse + ")");
                        }
                        this.ref.getChannel().free(conn, reuse);
                    }
                    if (call == null) return e;
                    call.releaseOutputStream();
                    call.releaseInputStream();
                    return e;
                }
                try {
                    ObjectInput in = call.getInputStream();
                    Class<?> rtype = method.getReturnType();
                    Object returnValue = UnicastRef.unmarshalValue(rtype, in);
                    alreadyFreed = true;
                    this.ref.getChannel().free(conn, true);
                    object = returnValue;
                }
                catch (RemoteException e) {
                    clientRefLog.log(Log.BRIEF, "RMIException during invoke return: ", e);
                    throw e;
                }
                catch (IOException e) {
                    clientRefLog.log(Log.BRIEF, "IOException unmarshalling return: ", e);
                    throw new UnmarshalException("error unmarshalling return", e);
                }
                catch (ClassNotFoundException e) {
                    clientRefLog.log(Log.BRIEF, "ClassNotFoundException unmarshalling return: ", e);
                    throw new UnmarshalException("error unmarshalling return", e);
                }
                Object var21_26 = null;
                if (!alreadyFreed) {
                    if (clientRefLog.isLoggable(Log.BRIEF)) {
                        clientRefLog.log(Log.BRIEF, "free connection (reuse = " + reuse + ")");
                    }
                    this.ref.getChannel().free(conn, reuse);
                }
                if (call == null) return object;
                call.releaseOutputStream();
                call.releaseInputStream();
                return object;
            }
            catch (RuntimeException e) {
                if (call != null) {
                    if (((ClientStreamRemoteCall)call).getServerException() == e) throw e;
                }
                reuse = false;
                throw e;
            }
            catch (RemoteException e) {
                reuse = false;
                throw e;
            }
            catch (Error e) {
                reuse = false;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var21_27 = null;
            if (!alreadyFreed) {
                if (clientRefLog.isLoggable(Log.BRIEF)) {
                    clientRefLog.log(Log.BRIEF, "free connection (reuse = " + reuse + ")");
                }
                this.ref.getChannel().free(conn, reuse);
            }
            if (call == null) throw throwable;
            call.releaseOutputStream();
            call.releaseInputStream();
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void marshalValue(Class type, Object value, ObjectOutput out) throws IOException {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                out.writeInt((Integer)value);
                return;
            } else if (type == Boolean.TYPE) {
                out.writeBoolean((Boolean)value);
                return;
            } else if (type == Byte.TYPE) {
                out.writeByte(((Byte)value).byteValue());
                return;
            } else if (type == Character.TYPE) {
                out.writeChar(((Character)value).charValue());
                return;
            } else if (type == Short.TYPE) {
                out.writeShort(((Short)value).shortValue());
                return;
            } else if (type == Long.TYPE) {
                out.writeLong((Long)value);
                return;
            } else if (type == Float.TYPE) {
                out.writeFloat(((Float)value).floatValue());
                return;
            } else {
                if (type != Double.TYPE) throw new Error("Unrecognized primitive type: " + type);
                out.writeDouble((Double)value);
            }
            return;
        } else {
            out.writeObject(value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void marshalDataValue(Class type, Object value, DataOutput out) throws IOException {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                out.writeInt((Integer)value);
                return;
            } else if (type == Boolean.TYPE) {
                out.writeBoolean((Boolean)value);
                return;
            } else if (type == Byte.TYPE) {
                out.writeByte(((Byte)value).byteValue());
                return;
            } else if (type == Character.TYPE) {
                out.writeChar(((Character)value).charValue());
                return;
            } else if (type == Short.TYPE) {
                out.writeShort(((Short)value).shortValue());
                return;
            } else if (type == Long.TYPE) {
                out.writeLong((Long)value);
                return;
            } else if (type == Float.TYPE) {
                out.writeFloat(((Float)value).floatValue());
                return;
            } else {
                if (type != Double.TYPE) throw new Error("Unrecognized primitive type: " + type);
                out.writeDouble((Double)value);
            }
            return;
        } else if (type == int[].class) {
            RemoteCall.writeIntArray(out, (int[])value);
            return;
        } else if (type == boolean[].class) {
            RemoteCall.writeBooleanArray(out, (boolean[])value);
            return;
        } else if (type == byte[].class) {
            RemoteCall.writeByteArray(out, (byte[])value);
            return;
        } else if (type == char[].class) {
            RemoteCall.writeCharArray(out, (char[])value);
            return;
        } else if (type == short[].class) {
            RemoteCall.writeShortArray(out, (short[])value);
            return;
        } else if (type == long[].class) {
            RemoteCall.writeLongArray(out, (long[])value);
            return;
        } else if (type == float[].class) {
            RemoteCall.writeFloatArray(out, (float[])value);
            return;
        } else if (type == double[].class) {
            RemoteCall.writeDoubleArray(out, (double[])value);
            return;
        } else {
            if (type != String.class) throw new Error("Unrecognized Object type: " + type);
            RemoteCall.writeUTF(out, (String)value);
        }
    }

    protected static Object unmarshalDataValue(Class type, DataInput in) throws IOException, ClassNotFoundException {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return new Integer(in.readInt());
            }
            if (type == Boolean.TYPE) {
                return in.readBoolean();
            }
            if (type == Byte.TYPE) {
                return new Byte(in.readByte());
            }
            if (type == Character.TYPE) {
                return new Character(in.readChar());
            }
            if (type == Short.TYPE) {
                return new Short(in.readShort());
            }
            if (type == Long.TYPE) {
                return new Long(in.readLong());
            }
            if (type == Float.TYPE) {
                return new Float(in.readFloat());
            }
            if (type == Double.TYPE) {
                return new Double(in.readDouble());
            }
            throw new Error("Unrecognized primitive type: " + type);
        }
        if (type == int[].class) {
            return RemoteCall.readIntArray(in);
        }
        if (type == boolean[].class) {
            return RemoteCall.readBooleanArray(in);
        }
        if (type == byte[].class) {
            return RemoteCall.readByteArray(in);
        }
        if (type == char[].class) {
            return RemoteCall.readCharArray(in);
        }
        if (type == short[].class) {
            return RemoteCall.readShortArray(in);
        }
        if (type == long[].class) {
            return RemoteCall.readLongArray(in);
        }
        if (type == float[].class) {
            return RemoteCall.readFloatArray(in);
        }
        if (type == double[].class) {
            return RemoteCall.readDoubleArray(in);
        }
        if (type == String.class) {
            return RemoteCall.readUTF(in);
        }
        throw new Error("Unrecognized Object type: " + type);
    }

    protected static Object unmarshalValue(Class type, ObjectInput in) throws IOException, ClassNotFoundException {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return new Integer(in.readInt());
            }
            if (type == Boolean.TYPE) {
                return in.readBoolean();
            }
            if (type == Byte.TYPE) {
                return new Byte(in.readByte());
            }
            if (type == Character.TYPE) {
                return new Character(in.readChar());
            }
            if (type == Short.TYPE) {
                return new Short(in.readShort());
            }
            if (type == Long.TYPE) {
                return new Long(in.readLong());
            }
            if (type == Float.TYPE) {
                return new Float(in.readFloat());
            }
            if (type == Double.TYPE) {
                return new Double(in.readDouble());
            }
            throw new Error("Unrecognized primitive type: " + type);
        }
        return in.readObject();
    }

    public RemoteCall newCall(RemoteObject obj, Operation[] ops, int opnum, long hash, Method method, boolean isSimpleParams, byte returnTypeNumber, boolean isVoidReturn) throws RemoteException {
        clientRefLog.log(Log.BRIEF, "get connection");
        Connection conn = this.ref.getChannel().newConnection();
        try {
            clientRefLog.log(Log.VERBOSE, "create call context");
            if (clientCallLog.isLoggable(Log.VERBOSE)) {
                this.logClientCall(obj, ops[opnum]);
            }
            ClientStreamRemoteCall call = new ClientStreamRemoteCall(conn, this.ref.getObjID(), opnum, hash, isSimpleParams, returnTypeNumber, isVoidReturn, method, obj.getClass().getClassLoader());
            return call;
        }
        catch (RemoteException e) {
            this.ref.getChannel().free(conn, false);
            throw e;
        }
    }

    public void invoke(RemoteCall call) throws Exception {
        try {
            clientRefLog.log(Log.VERBOSE, "execute call");
            call.executeCall();
        }
        catch (RemoteException e) {
            clientRefLog.log(Log.BRIEF, "exception: ", e);
            this.free(call, false);
            throw e;
        }
        catch (Error e) {
            clientRefLog.log(Log.BRIEF, "error: ", e);
            this.free(call, false);
            throw e;
        }
        catch (RuntimeException e) {
            clientRefLog.log(Log.BRIEF, "exception: ", e);
            this.free(call, false);
            throw e;
        }
        catch (Exception e) {
            clientRefLog.log(Log.BRIEF, "exception: ", e);
            this.free(call, true);
            throw e;
        }
    }

    private void free(RemoteCall call, boolean reuse) throws RemoteException {
        Connection conn = call.getConnection();
        this.ref.getChannel().free(conn, reuse);
    }

    public void done(RemoteCall call) throws RemoteException {
        clientRefLog.log(Log.BRIEF, "free connection (reuse = true)");
        this.free(call, true);
    }

    void logClientCall(Object obj, Object method) {
        clientCallLog.log(Log.VERBOSE, "outbound call: " + this.ref + " : " + obj.getClass().getName() + this.ref.getObjID().toString() + ": " + method);
    }

    public String getRefClass(ObjectOutput out) {
        return "UnicastRef";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.ref.write(out, false);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ref = LiveRef.read(in, false);
    }

    public String remoteToString() {
        return "RemoteStub [ref: " + this.ref + "]";
    }

    public int remoteHashCode() {
        return this.ref.hashCode();
    }

    public boolean remoteEquals(RemoteRef sub) {
        if (sub instanceof UnicastRef) {
            return this.ref.remoteEquals(((UnicastRef)sub).ref);
        }
        return false;
    }

    static {
        boolean logCalls = JeusRMIProperties.ENABLE_CLIENT_LOG;
        clientCallLog = Log.getLog("jeus.rmi.client.call", "RMI", logCalls);
    }
}

