/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.rmi.UnmarshalException;
import java.util.HashMap;
import java.util.Map;
import jeus.net.helper.MsgSync;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.server.UnicastRef;
import jeus.rmi.impl.transport.Connection;
import jeus.rmi.impl.transport.Endpoint;
import jeus.rmi.impl.transport.Transport;
import jeus.rmi.impl.transport.net.JeusConnection;
import jeus.rmi.impl.transport.net.help.RMIPropertiesConstant;
import jeus.rmi.spec.ClientInterceptor;
import jeus.rmi.spec.InterceptorContextProvider;
import jeus.rmi.spec.RemoteCall;
import jeus.rmi.spec.server.ObjID;
import jeus.util.properties.JeusRMIProperties;

public final class ClientStreamRemoteCall
extends RemoteCall
implements InterceptorContextProvider {
    protected Exception serverException = null;
    private ClassLoader firstClassLoader;
    private Map context = new HashMap();

    public ClientStreamRemoteCall(Connection c, ObjID id, int op, long hash, boolean _isSimpleParams, byte _returnTypeNumber, boolean _isVoidReturn, Method method, ClassLoader _cl) throws RemoteException {
        this.isSimpleParams = _isSimpleParams;
        this.returnTypeNumber = _returnTypeNumber;
        this.isVoidReturn = _isVoidReturn;
        this.method = method;
        this.firstClassLoader = _cl;
        try {
            this.conn = c;
            Transport.transportLog.log(Log.VERBOSE, "write remote call header...");
            if (JeusRMIProperties.USE_JEUS_NETWORK) {
                if (RMIPropertiesConstant.useChannel) {
                    ((JeusConnection)this.conn).intializeBuffer(2);
                }
                this.dout = this.getDataOutputStream();
                this.dout.write(2);
            } else {
                this.dout = this.getDataOutputStream();
            }
            this.dout.write(80);
            id.write(this.dout);
            this.dout.writeLong(hash);
        }
        catch (IOException e) {
            throw new MarshalException("Error marshaling call header", e);
        }
        catch (Exception e) {
            throw new UnexpectedException("Unable to set information from CallContext", e);
        }
    }

    public ObjectOutput getOutputStream(boolean resultStream) throws IOException {
        if (this.out == null) {
            Transport.transportLog.log(Log.VERBOSE, "getting output stream");
            this.out = this.conn.getObjectOutput();
        }
        return this.out;
    }

    public DataOutput getDataOutputStream() throws IOException {
        if (this.dout == null) {
            this.dout = this.conn.getDataOutput();
        }
        return this.dout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseOutputStream() throws IOException {
        try {
            if (this.out != null) {
                try {
                    this.out.flush();
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    throw throwable;
                }
            }
            this.conn.releaseOutputStream();
            Object var4_4 = null;
            this.out = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.out = null;
            throw throwable;
        }
    }

    public ObjectInput getInnerInputStream() throws IOException {
        if (this.in == null) {
            Transport.transportLog.log(Log.VERBOSE, "getting input stream");
            this.in = this.conn.getObjectInput(this.firstClassLoader);
        }
        return this.in;
    }

    public ObjectInput getInputStream() throws IOException {
        return this;
    }

    public DataInput getDataInputStream() throws IOException {
        if (this.din == null) {
            this.din = this.conn.getDataInput();
        }
        return this.din;
    }

    public ObjectOutput getResultStream(boolean success) throws IOException, StreamCorruptedException {
        throw new StreamCorruptedException("should not be called");
    }

    public void executeCall() throws Exception {
        byte returnType;
        DataInputStream rd;
        ClientInterceptor clientIntercepter = this.getClientIntercepter();
        if (clientIntercepter != null) {
            clientIntercepter.intercept(this.isSimpleParams ? this.getDataOutputStream() : this.getOutputStream(), this);
        }
        this.releaseOutputStream();
        if (JeusRMIProperties.USE_JEUS_NETWORK) {
            MsgSync sync = new MsgSync(JeusRMIProperties.WAIT_TIME_OUT);
            try {
                ((JeusConnection)this.conn).write(sync);
                if (Transport.transportLog.isLoggable(Log.BRIEF)) {
                    Transport.transportLog.log(Log.BRIEF, " Call Message Send ");
                }
            }
            catch (IOException e) {
                throw new MarshalException("Occured Exception during writing call message", e);
            }
            try {
                Object object = sync.waitReply();
                if (!(object instanceof byte[])) {
                    throw new IOException("received Exception msg : " + object);
                }
                byte[] resultMsg = (byte[])object;
                if (Transport.transportLog.isLoggable(Log.BRIEF)) {
                    Transport.transportLog.log(Log.BRIEF, " Result Message is received ");
                }
                ((JeusConnection)this.conn).setByteArrayInputStream(resultMsg);
                byte msgType = this.conn.getDataInput().readByte();
                if (msgType != 3) {
                    throw new IOException("unknown message : " + resultMsg[0]);
                }
            }
            catch (IOException e) {
                throw new UnmarshalException("Occured Exception during reading call result message", e);
            }
        }
        try {
            rd = (DataInputStream)this.getDataInputStream();
            byte op = rd.readByte();
            if (this.isVoidReturn) {
                if (op == 85) {
                    if (clientIntercepter != null) {
                        clientIntercepter.afterIntercept(this.getDataInputStream(), this);
                    }
                    return;
                }
                if (op != 2) {
                    throw new UnmarshalException("Transport return code invalid: " + op);
                }
            } else if (op != 1 && op != 2) {
                if (Transport.transportLog.isLoggable(Log.BRIEF)) {
                    Transport.transportLog.log(Log.BRIEF, "Transport return code invalid: " + op);
                }
                throw new UnmarshalException("Transport return code invalid: " + op);
            }
            returnType = op;
        }
        catch (UnmarshalException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UnmarshalException("Error unmarshaling return header", e);
        }
        switch (returnType) {
            case 1: {
                switch (this.returnTypeNumber) {
                    case 1: {
                        this.int_Response_Value = rd.readInt();
                        break;
                    }
                    case 2: {
                        this.boolean_Response_Value = rd.readBoolean();
                        break;
                    }
                    case 3: {
                        this.byte_Response_Value = rd.readByte();
                        break;
                    }
                    case 4: {
                        this.char_Response_Value = rd.readChar();
                        break;
                    }
                    case 5: {
                        this.short_Response_Value = rd.readShort();
                        break;
                    }
                    case 6: {
                        this.long_Response_Value = rd.readLong();
                        break;
                    }
                    case 7: {
                        this.float_Response_Value = rd.readFloat();
                        break;
                    }
                    case 8: {
                        this.double_Response_Value = rd.readDouble();
                        break;
                    }
                    case 9: {
                        this.int_ARRARY_Response_Value = ClientStreamRemoteCall.readIntArray(rd);
                        break;
                    }
                    case 10: {
                        this.boolean_ARRARY_Response_Value = ClientStreamRemoteCall.readBooleanArray(rd);
                        break;
                    }
                    case 11: {
                        this.byte_ARRARY_Response_Value = ClientStreamRemoteCall.readByteArray(rd);
                        break;
                    }
                    case 12: {
                        this.char_ARRARY_Response_Value = ClientStreamRemoteCall.readCharArray(rd);
                        break;
                    }
                    case 13: {
                        this.short_ARRARY_Response_Value = ClientStreamRemoteCall.readShortArray(rd);
                        break;
                    }
                    case 14: {
                        this.long_ARRARY_Response_Value = ClientStreamRemoteCall.readLongArray(rd);
                        break;
                    }
                    case 15: {
                        this.float_ARRARY_Response_Value = ClientStreamRemoteCall.readFloatArray(rd);
                        break;
                    }
                    case 16: {
                        this.double_ARRARY_Response_Value = ClientStreamRemoteCall.readDoubleArray(rd);
                        break;
                    }
                    case 17: {
                        byte isNull = rd.readByte();
                        if (isNull == 0) {
                            this.string_Response_Value = null;
                            break;
                        }
                        byte _isUTF = rd.readByte();
                        if (_isUTF == 2) {
                            this.string_Response_Value = rd.readUTF();
                            break;
                        }
                        this.getInnerInputStream();
                        this.string_Response_Value = (String)this.in.readObject();
                        break;
                    }
                    case 18: {
                        byte isNull = rd.readByte();
                        if (isNull == 0) {
                            this.object_Response_Value = null;
                            break;
                        }
                        byte _isUTF = rd.readByte();
                        if (_isUTF == 2) {
                            this.object_Response_Value = rd.readUTF();
                            break;
                        }
                        this.getInnerInputStream();
                        this.object_Response_Value = this.in.readObject();
                    }
                }
                if (clientIntercepter == null) break;
                clientIntercepter.afterIntercept(this.getDataInputStream(), this);
                break;
            }
            case 2: {
                Object ex;
                this.getInnerInputStream();
                try {
                    ex = this.in.readObject();
                }
                catch (Exception e) {
                    throw new UnmarshalException("Error unmarshaling return", e);
                }
                if (ex instanceof Exception) {
                    if (clientIntercepter != null) {
                        try {
                            clientIntercepter.exceptionOccurred((Exception)ex, this);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                    this.exceptionReceivedFromServer((Exception)ex);
                } else {
                    throw new UnmarshalException("Return type not Exception");
                }
            }
            default: {
                if (Transport.transportLog.isLoggable(Log.BRIEF)) {
                    Transport.transportLog.log(Log.BRIEF, "Return code invalid: " + returnType);
                }
                throw new UnmarshalException("Return code invalid: " + returnType);
            }
        }
    }

    private void exceptionReceivedFromServer(Exception ex) throws Exception {
        this.serverException = ex;
        StackTraceElement[] serverTrace = ex.getStackTrace();
        StackTraceElement[] clientTrace = new Throwable().getStackTrace();
        StackTraceElement[] combinedTrace = new StackTraceElement[serverTrace.length + clientTrace.length];
        System.arraycopy(serverTrace, 0, combinedTrace, 0, serverTrace.length);
        System.arraycopy(clientTrace, 0, combinedTrace, serverTrace.length, clientTrace.length);
        ex.setStackTrace(combinedTrace);
        if (UnicastRef.clientCallLog.isLoggable(Log.BRIEF)) {
            Endpoint ep = this.conn.getChannel().getEndpoint();
            UnicastRef.clientCallLog.log(Log.BRIEF, "outbound call received exception: [" + ep + "] exception: ", ex);
        }
        throw ex;
    }

    public Exception getServerException() {
        return this.serverException;
    }

    public Map getContext() {
        return this.context;
    }
}

