/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.server.MethodInfo;
import jeus.rmi.impl.transport.Connection;
import jeus.rmi.impl.transport.Transport;
import jeus.rmi.impl.transport.net.JeusConnection;
import jeus.rmi.impl.transport.net.help.RMIPropertiesConstant;
import jeus.rmi.spec.InterceptorContextProvider;
import jeus.rmi.spec.RemoteCall;
import jeus.rmi.spec.ServerInterceptor;
import jeus.util.properties.JeusRMIProperties;

public final class StreamRemoteCall
extends RemoteCall
implements InterceptorContextProvider {
    private Throwable throwableInServer;
    private Method intercepted_method;
    private Object intercepted_obj;
    private Object[] intercepted_params;
    private Map context = new HashMap();

    public StreamRemoteCall(Connection c) {
        this.conn = c;
    }

    public ObjectOutput getOutputStream(boolean resultStream) throws IOException {
        return this;
    }

    public DataOutput getDataOutputStream() throws IOException {
        if (this.dout == null) {
            this.dout = this.conn.getDataOutput();
        }
        return this.dout;
    }

    private ObjectOutput getInnerOutputStream() throws IOException {
        if (this.out == null) {
            Transport.transportLog.log(Log.VERBOSE, "getting output stream");
            this.out = this.conn.getObjectOutput();
        }
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseOutputStream() throws IOException {
        try {
            DataOutputStream wr;
            if (JeusRMIProperties.USE_JEUS_NETWORK) {
                if (RMIPropertiesConstant.useChannel) {
                    ((JeusConnection)this.conn).intializeBuffer(3);
                }
                wr = (DataOutputStream)this.conn.getDataOutput();
                wr.write(3);
            } else {
                wr = (DataOutputStream)this.conn.getDataOutput();
            }
            ServerInterceptor serverIntercepter = this.getServerIntercepter();
            if (this.throwableInServer != null) {
                wr.writeByte(2);
                this.getInnerOutputStream();
                this.out.writeObject(this.throwableInServer);
            } else if (this.isVoidReturn) {
                wr.writeByte(85);
                if (serverIntercepter != null) {
                    serverIntercepter.afterIntercept(this.getDataOutputStream(), this);
                }
            } else {
                wr.writeByte(1);
                switch (this.returnTypeNumber) {
                    case 1: {
                        wr.writeInt(this.int_Response_Value);
                        break;
                    }
                    case 2: {
                        wr.writeBoolean(this.boolean_Response_Value);
                        break;
                    }
                    case 3: {
                        wr.writeByte(this.byte_Response_Value);
                        break;
                    }
                    case 4: {
                        wr.writeChar(this.char_Response_Value);
                        break;
                    }
                    case 5: {
                        wr.writeShort(this.short_Response_Value);
                        break;
                    }
                    case 6: {
                        wr.writeLong(this.long_Response_Value);
                        break;
                    }
                    case 7: {
                        wr.writeFloat(this.float_Response_Value);
                        break;
                    }
                    case 8: {
                        wr.writeDouble(this.double_Response_Value);
                        break;
                    }
                    case 9: {
                        StreamRemoteCall.writeIntArray(wr, this.int_ARRARY_Response_Value);
                        break;
                    }
                    case 10: {
                        StreamRemoteCall.writeBooleanArray(wr, this.boolean_ARRARY_Response_Value);
                        break;
                    }
                    case 11: {
                        StreamRemoteCall.writeByteArray(wr, this.byte_ARRARY_Response_Value);
                        break;
                    }
                    case 12: {
                        StreamRemoteCall.writeCharArray(wr, this.char_ARRARY_Response_Value);
                        break;
                    }
                    case 13: {
                        StreamRemoteCall.writeShortArray(wr, this.short_ARRARY_Response_Value);
                        break;
                    }
                    case 14: {
                        StreamRemoteCall.writeLongArray(wr, this.long_ARRARY_Response_Value);
                        break;
                    }
                    case 15: {
                        StreamRemoteCall.writeFloatArray(wr, this.float_ARRARY_Response_Value);
                        break;
                    }
                    case 16: {
                        StreamRemoteCall.writeDoubleArray(wr, this.double_ARRARY_Response_Value);
                        break;
                    }
                    case 17: {
                        if (this.string_Response_Value == null) {
                            wr.writeByte(0);
                            break;
                        }
                        wr.writeByte(1);
                        if (MethodInfo.isStringSimple) {
                            wr.writeByte(2);
                            wr.writeUTF(this.string_Response_Value);
                            break;
                        }
                        wr.writeByte(3);
                        this.getInnerOutputStream();
                        this.out.writeObject(this.string_Response_Value);
                        break;
                    }
                    case 18: {
                        if (this.object_Response_Value == null) {
                            wr.writeByte(0);
                            break;
                        }
                        wr.writeByte(1);
                        if (MethodInfo.isStringSimple && this.object_Response_Value instanceof String) {
                            wr.writeByte(2);
                            wr.writeUTF((String)this.object_Response_Value);
                            break;
                        }
                        wr.writeByte(3);
                        this.getInnerOutputStream();
                        this.out.writeObject(this.object_Response_Value);
                    }
                }
                if (serverIntercepter != null) {
                    serverIntercepter.afterIntercept(this.getDataOutputStream(), this);
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.getServerIntercepter() != null) {
                this.getServerIntercepter().handleFinally(this);
            }
            try {
                if (this.out != null) {
                    this.out.flush();
                }
                this.conn.releaseOutputStream();
                if (JeusRMIProperties.USE_JEUS_NETWORK) {
                    ((JeusConnection)this.conn).writeReply();
                }
                Object var6_7 = null;
                this.out = null;
            }
            catch (Throwable throwable2) {
                Object var6_8 = null;
                this.out = null;
                throw throwable2;
            }
            throw throwable;
        }
        if (this.getServerIntercepter() != null) {
            this.getServerIntercepter().handleFinally(this);
        }
        try {
            if (this.out != null) {
                this.out.flush();
            }
            this.conn.releaseOutputStream();
            if (JeusRMIProperties.USE_JEUS_NETWORK) {
                ((JeusConnection)this.conn).writeReply();
            }
            Object var6_5 = null;
            this.out = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.out = null;
            throw throwable;
        }
    }

    public ObjectInput getInputStream() throws IOException {
        if (this.in == null) {
            Transport.transportLog.log(Log.VERBOSE, "getting input stream");
            this.in = this.conn.getObjectInput(null);
        }
        return this.in;
    }

    public DataInput getDataInputStream() throws IOException {
        if (this.din == null) {
            this.din = this.conn.getDataInput();
        }
        return this.din;
    }

    public ObjectOutput getResultStream(boolean success) throws IOException, StreamCorruptedException {
        return this;
    }

    public void executeCall() throws Exception {
        throw new StreamCorruptedException("should not be called");
    }

    public void setServerException(Throwable th) {
        this.throwableInServer = th;
    }

    public Map getContext() {
        return this.context;
    }
}

