/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Vector;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.runtime.NewThreadAction;
import jeus.rmi.impl.transport.proxy.RMIDirectSocketFactory;
import jeus.rmi.impl.transport.proxy.RMIHttpToCGISocketFactory;
import jeus.rmi.impl.transport.proxy.RMIHttpToPortSocketFactory;
import jeus.rmi.spec.server.LogStream;
import jeus.rmi.spec.server.RMISocketFactory;
import jeus.util.properties.JeusRMIProperties;

public class RMIMasterSocketFactory
extends RMISocketFactory {
    static int logLevel = LogStream.parseLevel(JeusRMIProperties.PROXY_LOG_LEVEL);
    static final Log proxyLog = Log.getLog("jeus.rmi.transport.tcp.proxy", "transport", logLevel);
    private static long connectTimeout = JeusRMIProperties.PROXY_CONNECTION_TO;
    private static final boolean eagerHttpFallback = JeusRMIProperties.ENABLE_HTTP_FALLBACK;
    private Hashtable successTable = new Hashtable();
    private static final int MaxRememberedHosts = 64;
    private Vector hostList = new Vector(64);
    protected RMISocketFactory initialFactory = new RMIDirectSocketFactory();
    protected Vector altFactoryList = new Vector(2);

    public RMIMasterSocketFactory() {
        boolean setFactories = false;
        try {
            String proxyHost = JeusRMIProperties.HTTP_PROXY_HOST;
            if (proxyHost == null) {
                proxyHost = JeusRMIProperties.PROXY_HOST;
            }
            if (!JeusRMIProperties.DISALBE_HTTP && proxyHost != null && proxyHost.length() > 0) {
                setFactories = true;
            }
        }
        catch (Exception e) {
            setFactories = true;
        }
        if (setFactories) {
            this.altFactoryList.addElement(new RMIHttpToPortSocketFactory());
            this.altFactoryList.addElement(new RMIHttpToCGISocketFactory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Socket createSocket(String host, int port) throws IOException {
        int i2;
        Object object;
        Socket fallbackSocket;
        RMISocketFactory factory;
        block50: {
            IOException initialFailure;
            AsyncConnector connector;
            block51: {
                if (proxyLog.isLoggable(Log.BRIEF)) {
                    proxyLog.log(Log.BRIEF, "host: " + host + ", port: " + port);
                }
                if (this.altFactoryList.size() == 0) {
                    return this.initialFactory.createSocket(host, port);
                }
                factory = (RMISocketFactory)this.successTable.get(host);
                if (factory != null) {
                    if (!proxyLog.isLoggable(Log.BRIEF)) return factory.createSocket(host, port);
                    proxyLog.log(Log.BRIEF, "previously successful factory found: " + factory);
                    return factory.createSocket(host, port);
                }
                fallbackSocket = null;
                connector = new AsyncConnector(this.initialFactory, host, port);
                initialFailure = null;
                try {
                    try {
                        Socket initialSocket;
                        object = connector;
                        // MONITORENTER : object
                        Thread t = (Thread)AccessController.doPrivileged(new NewThreadAction(connector, "AsyncConnector", true));
                        t.start();
                        try {
                            long now = System.currentTimeMillis();
                            long deadline = now + connectTimeout;
                            do {
                                connector.wait(deadline - now);
                            } while ((initialSocket = this.checkConnector(connector)) == null && (now = System.currentTimeMillis()) < deadline);
                        }
                        catch (InterruptedException e) {
                            throw new InterruptedIOException("interrupted while waiting for connector");
                        }
                        if (initialSocket == null) {
                            throw new NoRouteToHostException("connect timed out: " + host);
                        }
                        proxyLog.log(Log.BRIEF, "direct socket connection successful");
                        object = initialSocket;
                        Object var16_22 = null;
                        if (initialFailure == null) return object;
                        if (proxyLog.isLoggable(Log.BRIEF)) {
                            proxyLog.log(Log.BRIEF, "direct socket connection failed: ", initialFailure);
                        }
                        i2 = 0;
                        break block50;
                    }
                    catch (UnknownHostException e) {
                        initialFailure = e;
                        Object var16_23 = null;
                        if (initialFailure == null) break block51;
                        if (proxyLog.isLoggable(Log.BRIEF)) {
                            proxyLog.log(Log.BRIEF, "direct socket connection failed: ", initialFailure);
                        }
                        for (int i2 = 0; i2 < this.altFactoryList.size(); ++i2) {
                            factory = (RMISocketFactory)this.altFactoryList.elementAt(i2);
                            try {
                                if (proxyLog.isLoggable(Log.BRIEF)) {
                                    proxyLog.log(Log.BRIEF, "trying with factory: " + factory);
                                }
                                Socket testSocket = factory.createSocket(host, port);
                                InputStream in = testSocket.getInputStream();
                                int b = in.read();
                                testSocket.close();
                            }
                            catch (IOException ex2222) {
                                if (!proxyLog.isLoggable(Log.BRIEF)) continue;
                                proxyLog.log(Log.BRIEF, "factory failed: ", ex2222);
                                continue;
                            }
                            proxyLog.log(Log.BRIEF, "factory succeeded");
                            try {
                                fallbackSocket = factory.createSocket(host, port);
                            }
                            catch (IOException ex2222) {}
                            break;
                        }
                    }
                    catch (NoRouteToHostException e) {
                        initialFailure = e;
                        Object var16_24 = null;
                        if (initialFailure == null) break block51;
                        if (proxyLog.isLoggable(Log.BRIEF)) {
                            proxyLog.log(Log.BRIEF, "direct socket connection failed: ", initialFailure);
                        }
                        for (int i2 = 0; i2 < this.altFactoryList.size(); ++i2) {
                            IOException ex2222;
                            block55: {
                                factory = (RMISocketFactory)this.altFactoryList.elementAt(i2);
                                try {}
                                catch (IOException ex2222) {
                                    if (!proxyLog.isLoggable(Log.BRIEF)) continue;
                                    proxyLog.log(Log.BRIEF, "factory failed: ", ex2222);
                                    continue;
                                }
                                if (!proxyLog.isLoggable(Log.BRIEF)) break block55;
                                proxyLog.log(Log.BRIEF, "trying with factory: " + factory);
                            }
                            Socket testSocket = factory.createSocket(host, port);
                            InputStream in = testSocket.getInputStream();
                            int b = in.read();
                            testSocket.close();
                            proxyLog.log(Log.BRIEF, "factory succeeded");
                            try {}
                            catch (IOException ex2222) {}
                            fallbackSocket = factory.createSocket(host, port);
                            break;
                        }
                    }
                    catch (SocketException e) {
                        if (!eagerHttpFallback) throw e;
                        initialFailure = e;
                        Object var16_25 = null;
                        if (initialFailure == null) break block51;
                        if (proxyLog.isLoggable(Log.BRIEF)) {
                            proxyLog.log(Log.BRIEF, "direct socket connection failed: ", initialFailure);
                        }
                        for (int i2 = 0; i2 < this.altFactoryList.size(); ++i2) {
                            IOException ex2222;
                            block56: {
                                factory = (RMISocketFactory)this.altFactoryList.elementAt(i2);
                                try {}
                                catch (IOException ex2222) {
                                    if (!proxyLog.isLoggable(Log.BRIEF)) continue;
                                    proxyLog.log(Log.BRIEF, "factory failed: ", ex2222);
                                    continue;
                                }
                                if (!proxyLog.isLoggable(Log.BRIEF)) break block56;
                                proxyLog.log(Log.BRIEF, "trying with factory: " + factory);
                            }
                            Socket testSocket = factory.createSocket(host, port);
                            InputStream in = testSocket.getInputStream();
                            int b = in.read();
                            testSocket.close();
                            proxyLog.log(Log.BRIEF, "factory succeeded");
                            try {}
                            catch (IOException ex2222) {}
                            fallbackSocket = factory.createSocket(host, port);
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var16_26 = null;
                    if (initialFailure == null) throw throwable;
                    if (proxyLog.isLoggable(Log.BRIEF)) {
                        proxyLog.log(Log.BRIEF, "direct socket connection failed: ", initialFailure);
                    }
                    int i2 = 0;
                    while (i2 < this.altFactoryList.size()) {
                        block53: {
                            IOException ex2222;
                            block57: {
                                factory = (RMISocketFactory)this.altFactoryList.elementAt(i2);
                                try {}
                                catch (IOException ex2222) {
                                    if (proxyLog.isLoggable(Log.BRIEF)) {
                                        proxyLog.log(Log.BRIEF, "factory failed: ", ex2222);
                                    }
                                    break block53;
                                }
                                if (!proxyLog.isLoggable(Log.BRIEF)) break block57;
                                proxyLog.log(Log.BRIEF, "trying with factory: " + factory);
                            }
                            Socket testSocket = factory.createSocket(host, port);
                            InputStream in = testSocket.getInputStream();
                            int b = in.read();
                            testSocket.close();
                            proxyLog.log(Log.BRIEF, "factory succeeded");
                            try {}
                            catch (IOException ex2222) {
                                throw throwable;
                            }
                            fallbackSocket = factory.createSocket(host, port);
                            throw throwable;
                        }
                        ++i2;
                    }
                    throw throwable;
                }
            }
            Hashtable hashtable = this.successTable;
            // MONITORENTER : hashtable
            try {
                AsyncConnector t = connector;
                // MONITORENTER : t
                Socket initialSocket = this.checkConnector(connector);
                // MONITOREXIT : t
                if (initialSocket != null) {
                    if (fallbackSocket != null) {
                        fallbackSocket.close();
                    }
                    // MONITOREXIT : hashtable
                    return initialSocket;
                }
                connector.notUsed();
            }
            catch (UnknownHostException e) {
                initialFailure = e;
            }
            catch (NoRouteToHostException e) {
                initialFailure = e;
            }
            catch (SocketException e) {
                if (!eagerHttpFallback) throw e;
                initialFailure = e;
            }
            if (fallbackSocket == null) throw initialFailure;
            this.rememberFactory(host, factory);
            // MONITOREXIT : hashtable
            return fallbackSocket;
        }
        while (i2 < this.altFactoryList.size()) {
            block54: {
                IOException ex2222;
                block58: {
                    factory = (RMISocketFactory)this.altFactoryList.elementAt(i2);
                    try {}
                    catch (IOException ex2222) {
                        if (proxyLog.isLoggable(Log.BRIEF)) {
                            proxyLog.log(Log.BRIEF, "factory failed: ", ex2222);
                        }
                        break block54;
                    }
                    if (!proxyLog.isLoggable(Log.BRIEF)) break block58;
                    proxyLog.log(Log.BRIEF, "trying with factory: " + factory);
                }
                Socket testSocket = factory.createSocket(host, port);
                InputStream in = testSocket.getInputStream();
                int b = in.read();
                testSocket.close();
                proxyLog.log(Log.BRIEF, "factory succeeded");
                try {}
                catch (IOException ex2222) {
                    return object;
                }
                fallbackSocket = factory.createSocket(host, port);
                return object;
            }
            ++i2;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rememberFactory(String host, RMISocketFactory factory) {
        Hashtable hashtable = this.successTable;
        synchronized (hashtable) {
            while (this.hostList.size() >= 64) {
                this.successTable.remove(this.hostList.elementAt(0));
                this.hostList.removeElementAt(0);
            }
            this.hostList.addElement(host);
            this.successTable.put(host, factory);
        }
    }

    Socket checkConnector(AsyncConnector connector) throws IOException {
        Exception e = connector.getException();
        if (e != null) {
            e.fillInStackTrace();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new Error("internal error: unexpected checked exception: " + e.toString());
        }
        return connector.getSocket();
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return this.initialFactory.createServerSocket(port);
    }

    private class AsyncConnector
    implements Runnable {
        private RMISocketFactory factory;
        private String host;
        private int port;
        private Exception exception = null;
        private Socket socket = null;
        private boolean cleanUp = false;

        AsyncConnector(RMISocketFactory factory, String host, int port) {
            this.factory = factory;
            this.host = host;
            this.port = port;
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkConnect(host, port);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    Socket temp = this.factory.createSocket(this.host, this.port);
                    AsyncConnector asyncConnector = this;
                    synchronized (asyncConnector) {
                        this.socket = temp;
                        this.notify();
                    }
                    RMIMasterSocketFactory.this.rememberFactory(this.host, this.factory);
                    asyncConnector = this;
                    synchronized (asyncConnector) {
                        if (this.cleanUp) {
                            try {
                                this.socket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (Exception e) {
                    AsyncConnector asyncConnector = this;
                    synchronized (asyncConnector) {
                        this.exception = e;
                        this.notify();
                    }
                }
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                throw throwable;
            }
        }

        private synchronized Exception getException() {
            return this.exception;
        }

        private synchronized Socket getSocket() {
            return this.socket;
        }

        synchronized void notUsed() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.cleanUp = true;
        }
    }
}

