/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.support;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.runtime.NewThreadAction;
import jeus.rmi.impl.transport.Channel;
import jeus.rmi.impl.transport.ClientEndpoint;
import jeus.rmi.impl.transport.Connection;
import jeus.rmi.impl.transport.Endpoint;
import jeus.rmi.impl.transport.Transport;
import jeus.rmi.impl.transport.net.JeusConnection;
import jeus.rmi.impl.transport.support.ConnectionSupport;
import jeus.util.properties.JeusRMIProperties;

public abstract class ChannelSupport
implements Channel {
    protected final ClientEndpoint ep;
    protected final List freeList = new ArrayList();
    protected Reaper reaper = null;
    protected static final long idleTimeout = JeusRMIProperties.CONNECTION_KEEP_ALIVE_TO;

    public ChannelSupport(ClientEndpoint ep) {
        this.ep = ep;
    }

    public Endpoint getEndpoint() {
        return this.ep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Connection conn, boolean reuse) throws RemoteException {
        if (conn == null) {
            return;
        }
        if (reuse && conn.isReusable()) {
            long lastuse = System.currentTimeMillis();
            Transport.transportLog.log(Log.BRIEF, "reuse connection");
            List list = this.freeList;
            synchronized (list) {
                if (!this.freeList.contains(conn)) {
                    this.freeList.add(conn);
                    if (JeusRMIProperties.USE_JEUS_NETWORK) {
                        JeusConnection.removeConnectionToActiveList(((JeusConnection)conn).getSocketStream(), (JeusConnection)conn);
                    }
                    if (this.reaper == null) {
                        Transport.transportLog.log(Log.BRIEF, "create reaper");
                        this.reaper = new Reaper();
                        Thread t = (Thread)AccessController.doPrivileged(new NewThreadAction(this.reaper, "ConnectionExpiration-" + this.ep.toString(), true));
                        t.start();
                    }
                }
            }
            ((ConnectionSupport)conn).setLastUseTime(lastuse);
            ((ConnectionSupport)conn).setExpiration(lastuse + idleTimeout);
        } else {
            Transport.transportLog.log(Log.BRIEF, "close connection");
            try {
                List lastuse = this.freeList;
                synchronized (lastuse) {
                    this.freeList.remove(conn);
                    conn.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shedCache() {
        Object[] conn;
        List list = this.freeList;
        synchronized (list) {
            conn = this.freeList.toArray();
            this.freeList.clear();
        }
        int i = conn.length;
        while (--i >= 0) {
            Connection c = (Connection)conn[i];
            conn[i] = null;
            try {
                c.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean freeCachedConnections() {
        List list = this.freeList;
        synchronized (list) {
            int size = this.freeList.size();
            if (size > 0) {
                long time = System.currentTimeMillis();
                ListIterator iter = this.freeList.listIterator(size);
                while (iter.hasPrevious()) {
                    Object var9_7;
                    ConnectionSupport conn = (ConnectionSupport)iter.previous();
                    if (!conn.expired(time)) continue;
                    Transport.transportLog.log(Log.VERBOSE, "connection timeout expired");
                    try {
                        try {
                            conn.close();
                        }
                        catch (IOException e) {
                            var9_7 = null;
                            iter.remove();
                            continue;
                        }
                        var9_7 = null;
                        iter.remove();
                    }
                    catch (Throwable throwable) {
                        var9_7 = null;
                        iter.remove();
                        throw throwable;
                    }
                }
            }
            if (this.freeList.isEmpty()) {
                this.reaper = null;
                return false;
            }
            return true;
        }
    }

    private class Reaper
    implements Runnable {
        private Reaper() {
        }

        public void run() {
            do {
                try {
                    Thread.sleep(idleTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Transport.transportLog.log(Log.VERBOSE, "wake up");
            } while (ChannelSupport.this.freeCachedConnections());
            Transport.transportLog.log(Log.VERBOSE, "exit");
        }
    }
}

