/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.tcp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.util.List;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.transport.ClientEndpoint;
import jeus.rmi.impl.transport.Connection;
import jeus.rmi.impl.transport.Endpoint;
import jeus.rmi.impl.transport.Transport;
import jeus.rmi.impl.transport.support.ChannelSupport;
import jeus.rmi.impl.transport.tcp.TCPClientEndpoint;
import jeus.rmi.impl.transport.tcp.TCPConnection;
import jeus.rmi.impl.transport.tcp.TCPConnectionFactory;
import jeus.util.properties.JeusRMIProperties;

public final class TCPChannel
extends ChannelSupport {
    private static final int handshakeTimeout = JeusRMIProperties.CLIENT_HANDSHAKE_TO;
    private static final int responseTimeout = JeusRMIProperties.CLIENT_READ_TO;
    private static final boolean isConnectionCheck = JeusRMIProperties.ENABLE_CONNECTION_CHECK;

    public TCPChannel(ClientEndpoint ep) {
        super(ep);
    }

    public Endpoint getEndpoint() {
        return this.ep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection newConnection() throws RemoteException {
        TCPConnection conn;
        do {
            conn = null;
            List list = this.freeList;
            synchronized (list) {
                int elementPos = this.freeList.size() - 1;
                if (elementPos >= 0) {
                    conn = (TCPConnection)this.freeList.get(elementPos);
                    this.freeList.remove(elementPos);
                }
            }
            if (conn == null) continue;
            if (isConnectionCheck) {
                if (!conn.isDead()) {
                    Transport.transportLog.log(Log.BRIEF, "reuse connection");
                    return conn;
                }
            } else {
                return conn;
            }
            this.free(conn, false);
        } while (conn != null);
        return this.createConnection();
    }

    private Connection createConnection() throws RemoteException {
        TCPConnection conn;
        block10: {
            Transport.transportLog.log(Log.BRIEF, "create connection");
            Socket sock = ((TCPClientEndpoint)this.ep).newSocket();
            conn = TCPConnectionFactory.createTCPConnection(this, sock);
            try {
                DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                this.writeTransportHeader(out);
                if (!conn.isReusable()) {
                    out.writeByte(76);
                    out.flush();
                    break block10;
                }
                out.writeByte(75);
                out.flush();
                int originalSoTimeout = 0;
                try {
                    originalSoTimeout = sock.getSoTimeout();
                    sock.setSoTimeout(handshakeTimeout);
                }
                catch (Exception e) {
                    // empty catch block
                }
                DataInputStream in = new DataInputStream(conn.getInputStream());
                byte ack = in.readByte();
                if (ack != 78) {
                    throw new ConnectIOException(ack == 79 ? "JRMP StreamProtocol not supported by server" : "non-JRMP server at remote endpoint");
                }
                if (Transport.transportLog.isLoggable(Log.VERBOSE)) {
                    Transport.transportLog.log(Log.VERBOSE, "using " + this.ep.getHost() + ":" + this.ep.getPort());
                }
                try {
                    sock.setSoTimeout(originalSoTimeout != 0 ? originalSoTimeout : responseTimeout);
                }
                catch (Exception e) {
                    // empty catch block
                }
                out.flush();
            }
            catch (IOException e) {
                if (e instanceof RemoteException) {
                    throw (RemoteException)e;
                }
                throw new ConnectIOException("error during JRMP connection establishment", e);
            }
        }
        return conn;
    }

    private void writeTransportHeader(DataOutputStream out) throws RemoteException {
        try {
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(1246907721);
            dataOut.writeShort(2);
        }
        catch (IOException e) {
            throw new ConnectIOException("error writing JRMP transport header", e);
        }
    }
}

