/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.RemoteException;
import java.security.AccessControlContext;
import java.util.WeakHashMap;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.transport.Connection;
import jeus.rmi.impl.transport.StreamRemoteCall;
import jeus.rmi.impl.transport.Transport;
import jeus.rmi.impl.transport.tcp.TCPConnectionFactory;
import jeus.rmi.impl.transport.tcp.TCPServerEndpoint;
import jeus.rmi.impl.transport.tcp.TCPTransport;
import jeus.util.properties.JeusRMIProperties;
import sun.rmi.transport.proxy.HttpReceiveSocket;

public final class TCPConnectionHandler
implements Runnable {
    private static final int connectionReadTimeout = JeusRMIProperties.SERVER_READ_TO;
    private static final int POST = 1347375956;
    private AccessControlContext okContext;
    private WeakHashMap authCache;
    private SecurityManager cacheSecurityManager = null;
    private Socket socket;
    private String remoteHost;
    int remotePort;
    TCPTransport tcpTransport;
    private int port;

    TCPConnectionHandler(TCPTransport _tcpTransport, Socket socket) {
        this.tcpTransport = _tcpTransport;
        this.socket = socket;
    }

    String getClientHost() {
        return this.remoteHost;
    }

    void checkAcceptPermission(SecurityManager sm, AccessControlContext acc) {
        if (sm != this.cacheSecurityManager) {
            this.okContext = null;
            this.authCache = new WeakHashMap();
            this.cacheSecurityManager = sm;
        }
        if (acc.equals(this.okContext) || this.authCache.containsKey(acc)) {
            return;
        }
        InetAddress addr = this.socket.getInetAddress();
        String host = addr != null ? addr.getHostAddress() : "*";
        sm.checkAccept(host, this.socket.getPort());
        this.authCache.put(acc, new SoftReference<AccessControlContext>(acc));
        this.okContext = acc;
    }

    private void setSocketInfo(TCPServerEndpoint endpoint) {
        InetAddress clientAddr = this.socket.getInetAddress();
        this.remoteHost = clientAddr != null ? clientAddr.getHostAddress() : "0.0.0.0";
        this.remotePort = this.socket.getPort();
        if (Transport.transportLog.isLoggable(Log.VERBOSE)) {
            this.port = endpoint.getPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block20: {
            block19: {
                endpoint = (TCPServerEndpoint)this.tcpTransport.getEndpoint();
                this.setSocketInfo(endpoint);
                try {
                    this.socket.setTcpNoDelay(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (TCPConnectionHandler.connectionReadTimeout > 0) {
                        this.socket.setSoTimeout(TCPConnectionHandler.connectionReadTimeout);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    try {
                        sockIn = this.socket.getInputStream();
                        bufIn = sockIn.markSupported() != false ? sockIn : new BufferedInputStream(sockIn);
                        bufIn.mark(4);
                        in = new DataInputStream(bufIn);
                        magic = in.readInt();
                        if (magic == 1347375956) {
                            Transport.transportLog.log(sun.rmi.runtime.Log.BRIEF, "decoding HTTP-wrapped call");
                            bufIn.reset();
                            try {
                                this.socket = new HttpReceiveSocket(this.socket, bufIn, null);
                                this.remoteHost = "0.0.0.0";
                                sockIn = this.socket.getInputStream();
                                bufIn = new BufferedInputStream(sockIn);
                                in = new DataInputStream(bufIn);
                                magic = in.readInt();
                            }
                            catch (IOException e) {
                                throw new RemoteException("Error HTTP-unwrapping call", e);
                            }
                        }
                        version = in.readShort();
                        if (magic != 1246907721 || version != 2) {
                            TCPConnectionHandler.closeSocket(this.socket);
                            var13_11 = null;
                            break block19;
                        }
                        sockOut = this.socket.getOutputStream();
                        bufOut = new BufferedOutputStream(sockOut);
                        out = new DataOutputStream(bufOut);
                        if (Transport.transportLog.isLoggable(Log.BRIEF)) {
                            Transport.transportLog.log(Log.BRIEF, "accepted socket from [" + this.remoteHost + ":" + this.remotePort + "]");
                        }
                        protocol = in.readByte();
                        switch (protocol) {
                            case 76: {
                                conn = TCPConnectionFactory.createTCPConnection(null, this.socket, bufIn, bufOut);
                                this.handleMessages(conn, false);
                                ** break;
                            }
                            case 75: {
                                out.writeByte(78);
                                out.flush();
                                conn = TCPConnectionFactory.createTCPConnection(null, this.socket, bufIn, bufOut);
                                this.handleMessages(conn, true);
                                ** break;
                            }
                        }
                        out.writeByte(79);
                        out.flush();
                        break block20;
                    }
                    catch (IOException e) {
                        Transport.transportLog.log(Log.BRIEF, "terminated with exception:", e);
                        var13_13 = null;
                        TCPConnectionHandler.closeSocket(this.socket);
                        return;
                    }
                }
                catch (Throwable var12_21) {
                    var13_14 = null;
                    TCPConnectionHandler.closeSocket(this.socket);
                    throw var12_21;
                }
            }
            TCPConnectionHandler.closeSocket(this.socket);
            return;
        }
        var13_12 = null;
        TCPConnectionHandler.closeSocket(this.socket);
    }

    private static void closeSocket(Socket sock) {
        try {
            sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleMessages(Connection conn, boolean persistent) {
        block17: {
            block16: {
                port = this.tcpTransport.getEndpoint().getPort();
                try {
                    try {
                        in = (DataInputStream)conn.getDataInput();
                        while ((op = in.read()) != -1) {
                            switch (op) {
                                case 80: {
                                    call = new StreamRemoteCall(conn);
                                    if (Transport.serviceCall(call)) break;
                                    var9_9 = null;
                                    break block16;
                                }
                                case 82: {
                                    out = new DataOutputStream(conn.getOutputStream());
                                    out.writeByte(83);
                                    conn.releaseOutputStream();
                                    break;
                                }
                                default: {
                                    throw new IOException("unknown transport op " + op);
                                }
                            }
                            if (persistent) continue;
                            break block17;
                        }
                        break block17;
                    }
                    catch (IOException e) {
                        if (Transport.transportLog.isLoggable(Log.BRIEF)) {
                            Transport.transportLog.log(Log.BRIEF, "(port " + port + ") exception: ", e);
                        }
                        var9_11 = null;
                        try {
                            conn.close();
                            return;
                        }
                        catch (IOException ex) {
                            return;
                        }
                    }
                }
                catch (Throwable var8_17) {
                    var9_12 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 224->233)] { 
lbl37:
                    // 1 sources

                    conn.close();
                    throw var8_17;
lbl39:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                    throw var8_17;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 224->233)] { 
lbl44:
            // 1 sources

            conn.close();
            return;
lbl46:
            // 1 sources

            catch (IOException ex) {
                // empty catch block
            }
            return;
        }
        var9_10 = null;
        try {}
        catch (IOException ex) {}
        conn.close();
        return;
    }
}

