/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.impl.transport.tcp;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessController;
import java.util.MissingResourceException;
import jeus.rmi.impl.runtime.GetThreadPoolAction;
import jeus.rmi.impl.runtime.Log;
import jeus.rmi.impl.runtime.NewThreadAction;
import jeus.rmi.impl.runtime.ThreadPool;
import jeus.rmi.impl.transport.ServerEndpoint;
import jeus.rmi.impl.transport.Target;
import jeus.rmi.impl.transport.support.TransportSupport;
import jeus.rmi.impl.transport.tcp.TCPConnectionHandler;
import jeus.rmi.impl.transport.tcp.TCPServerEndpoint;
import jeus.rmi.spec.server.RMIFailureHandler;
import jeus.rmi.spec.server.RMISocketFactory;
import jeus.util.properties.JeusRMIProperties;

public final class TCPTransport
extends TransportSupport
implements Runnable {
    private static int threadNum = 0;
    private ServerSocket server = null;
    public static final boolean useThreadPool = JeusRMIProperties.USE_THREAD_POOL;
    public static ThreadPool threadPool = null;
    private transient long acceptFailureTime = 0L;
    private transient int acceptFailureCount;

    protected TCPTransport(ServerEndpoint ep) {
        super(ep);
    }

    public void exportObject(Target target) throws RemoteException {
        this.listen();
        target.setExportedTransport(this);
        super.exportObject(target);
    }

    private synchronized void listen() throws RemoteException {
        int port = this.ep.getPort();
        if (this.server == null) {
            if (transportLog.isLoggable(Log.BRIEF)) {
                transportLog.log(Log.BRIEF, "(port " + port + ") create server socket");
            }
            try {
                this.server = ((TCPServerEndpoint)this.ep).newServerSocket();
                Thread t = (Thread)AccessController.doPrivileged(new NewThreadAction(this, "TCP Accept-" + port, true));
                t.start();
            }
            catch (BindException e) {
                throw new ExportException("Port already in use: " + port, e);
            }
            catch (IOException e) {
                throw new ExportException("Listen failed on port: " + port, e);
            }
        } else {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkListen(port);
            }
        }
    }

    private synchronized boolean continueAfterAcceptFailure(Throwable t) {
        boolean f;
        RMIFailureHandler fh = RMISocketFactory.getFailureHandler();
        if (fh != null) {
            f = t instanceof Exception ? fh.failure((Exception)t) : fh.failure(new InvocationTargetException(t));
        } else {
            int NFAIL = 10;
            int NMSEC = 5000;
            long now = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || now - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = now;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ign) {
                        // empty catch block
                    }
                }
            }
            f = true;
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Throwable throwable;
        if (transportLog.isLoggable(Log.BRIEF)) {
            transportLog.log(Log.BRIEF, "listening on port " + this.getEndpoint().getPort());
        }
        if (useThreadPool && threadPool == null) {
            threadPool = GetThreadPoolAction.getUserThreadPool();
        }
        while (true) {
            Object var6_12;
            ServerSocket myServer;
            if ((myServer = this.server) == null) {
                return;
            }
            throwable = null;
            try {
                try {
                    Socket socket = myServer.accept();
                    if (useThreadPool) {
                        threadPool.execute(new TCPConnectionHandler(this, socket), "TCP Connection(" + ++threadNum + ")");
                    } else {
                        Thread t = (Thread)AccessController.doPrivileged(new NewThreadAction(new TCPConnectionHandler(this, socket), "TCP Connection(" + ++threadNum + ")", true, true));
                        t.start();
                    }
                }
                catch (IOException e) {
                    IOException iOException = e;
                    var6_12 = null;
                    if (iOException == null) continue;
                    if (iOException instanceof IOException || iOException instanceof OutOfMemoryError || iOException instanceof NoClassDefFoundError || iOException instanceof MissingResourceException || iOException instanceof SecurityException) {
                        if (this.continueAfterAcceptFailure(iOException)) continue;
                        return;
                    }
                    if (!(iOException instanceof RuntimeException)) throw (Error)((Object)iOException);
                    throw (RuntimeException)((Object)iOException);
                }
                catch (RuntimeException e) {
                    RuntimeException runtimeException = e;
                    var6_12 = null;
                    if (runtimeException == null) continue;
                    if (runtimeException instanceof IOException || runtimeException instanceof OutOfMemoryError || runtimeException instanceof NoClassDefFoundError || runtimeException instanceof MissingResourceException || runtimeException instanceof SecurityException) {
                        if (this.continueAfterAcceptFailure(runtimeException)) continue;
                        return;
                    }
                    if (!(runtimeException instanceof RuntimeException)) throw (Error)((Object)runtimeException);
                    throw runtimeException;
                }
                catch (Error e) {
                    Error error = e;
                    var6_12 = null;
                    if (error == null) continue;
                    if (error instanceof IOException || error instanceof OutOfMemoryError || error instanceof NoClassDefFoundError || error instanceof MissingResourceException || error instanceof SecurityException) {
                        if (this.continueAfterAcceptFailure(error)) continue;
                        return;
                    }
                    if (!(error instanceof RuntimeException)) throw error;
                    throw (RuntimeException)((Object)error);
                }
                var6_12 = null;
                if (throwable == null) continue;
            }
            catch (Throwable throwable2) {
                var6_12 = null;
                if (throwable == null) throw throwable2;
                if (throwable instanceof IOException || throwable instanceof OutOfMemoryError || throwable instanceof NoClassDefFoundError || throwable instanceof MissingResourceException || throwable instanceof SecurityException) {
                    if (this.continueAfterAcceptFailure(throwable)) throw throwable2;
                    return;
                } else {
                    if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
                    throw (RuntimeException)throwable;
                }
            }
            if (!(throwable instanceof IOException) && !(throwable instanceof OutOfMemoryError) && !(throwable instanceof NoClassDefFoundError) && !(throwable instanceof MissingResourceException) && !(throwable instanceof SecurityException)) break;
            if (!this.continueAfterAcceptFailure(throwable)) return;
        }
        if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
        throw (RuntimeException)throwable;
    }

    public static String getClientHost() throws ServerNotActiveException {
        return null;
    }
}

