/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.rmic;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class IndentingWriter
extends BufferedWriter {
    private boolean beginningOfLine = true;
    private int currentIndent = 0;
    private int indentStep = 4;
    private int tabSize = 8;

    public IndentingWriter(Writer out) {
        super(out);
    }

    public IndentingWriter(Writer out, int step) {
        this(out);
        if (this.indentStep < 0) {
            throw new IllegalArgumentException("negative indent step");
        }
        this.indentStep = step;
    }

    public IndentingWriter(Writer out, int step, int tabSize) {
        this(out);
        if (this.indentStep < 0) {
            throw new IllegalArgumentException("negative indent step");
        }
        this.indentStep = step;
        this.tabSize = tabSize;
    }

    public void write(int c) throws IOException {
        this.checkWrite();
        super.write(c);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            this.checkWrite();
        }
        super.write(cbuf, off, len);
    }

    public void write(String s, int off, int len) throws IOException {
        if (len > 0) {
            this.checkWrite();
        }
        super.write(s, off, len);
    }

    public void newLine() throws IOException {
        super.newLine();
        this.beginningOfLine = true;
    }

    protected void checkWrite() throws IOException {
        if (this.beginningOfLine) {
            int i;
            this.beginningOfLine = false;
            for (i = this.currentIndent; i >= this.tabSize; i -= this.tabSize) {
                super.write(9);
            }
            while (i > 0) {
                super.write(32);
                --i;
            }
        }
    }

    protected void indentIn() {
        this.currentIndent += this.indentStep;
    }

    protected void indentOut() {
        this.currentIndent -= this.indentStep;
        if (this.currentIndent < 0) {
            this.currentIndent = 0;
        }
    }

    public void pI() {
        this.indentIn();
    }

    public void pO() {
        this.indentOut();
    }

    public void p(String s) throws IOException {
        this.write(s);
    }

    public void pln() throws IOException {
        this.newLine();
    }

    public void pln(String s) throws IOException {
        this.p(s);
        this.pln();
    }

    public void plnI(String s) throws IOException {
        this.p(s);
        this.pln();
        this.pI();
    }

    public void pO(String s) throws IOException {
        this.pO();
        this.p(s);
    }

    public void pOln(String s) throws IOException {
        this.pO(s);
        this.pln();
    }

    public void pOlnI(String s) throws IOException {
        this.pO(s);
        this.pln();
        this.pI();
    }

    public void p(Object o) throws IOException {
        this.write(o.toString());
    }

    public void pln(Object o) throws IOException {
        this.p(o.toString());
        this.pln();
    }

    public void plnI(Object o) throws IOException {
        this.p(o.toString());
        this.pln();
        this.pI();
    }

    public void pO(Object o) throws IOException {
        this.pO();
        this.p(o.toString());
    }

    public void pOln(Object o) throws IOException {
        this.pO(o.toString());
        this.pln();
    }

    public void pOlnI(Object o) throws IOException {
        this.pO(o.toString());
        this.pln();
        this.pI();
    }
}

