/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.spec.registry;

import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import jeus.rmi.impl.registry.RegistryImpl;
import jeus.rmi.impl.server.RemoteProxy;
import jeus.rmi.spec.registry.Registry;
import jeus.util.properties.JeusNetPropertyValues;

public final class LocateRegistry {
    private LocateRegistry() {
    }

    public static Registry getRegistry() throws RemoteException {
        return LocateRegistry.getRegistry(null, 1099);
    }

    public static Registry getRegistry(int port) throws RemoteException {
        return LocateRegistry.getRegistry(null, port);
    }

    public static Registry getRegistry(String host) throws RemoteException {
        return LocateRegistry.getRegistry(host, 1099);
    }

    public static Registry getRegistry(String host, int port) throws RemoteException {
        return LocateRegistry.getRegistry(host, port, null);
    }

    public static Registry getRegistry(String host, int port, RMIClientSocketFactory csf) throws RemoteException {
        Registry registry = null;
        if (port <= 0) {
            port = 1099;
        }
        if (host == null || host.length() == 0) {
            try {
                host = JeusNetPropertyValues.getLocalInetAddress().getHostAddress();
            }
            catch (Exception e) {
                host = "";
            }
        }
        registry = csf == null ? (Registry)((Object)RemoteProxy.getStub("jeus.rmi.impl.registry.RegistryImpl", 0, host, port)) : (Registry)((Object)RemoteProxy.getStub("jeus.rmi.impl.registry.RegistryImpl", 0, host, port, csf));
        return registry;
    }

    public static Registry createRegistry(int port) throws RemoteException {
        return new RegistryImpl(port);
    }

    public static Registry createRegistry(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        return new RegistryImpl(port, csf, ssf);
    }
}

