/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.spec.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.Date;
import java.util.Hashtable;

public class LogStream
extends PrintStream {
    private static Hashtable known = new Hashtable(5);
    private static PrintStream defaultStream = System.err;
    private String name;
    private OutputStream logOut;
    private OutputStreamWriter logWriter;
    private StringBuffer buffer = new StringBuffer();
    private ByteArrayOutputStream bufOut = (ByteArrayOutputStream)this.out;
    public static final int SILENT = 0;
    public static final int BRIEF = 10;
    public static final int VERBOSE = 20;

    private LogStream(String name, OutputStream out) {
        super(new ByteArrayOutputStream());
        this.name = name;
        this.setOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogStream log(String name) {
        LogStream stream;
        Hashtable hashtable = known;
        synchronized (hashtable) {
            stream = (LogStream)known.get(name);
            if (stream == null) {
                stream = new LogStream(name, defaultStream);
            }
            known.put(name, stream);
        }
        return stream;
    }

    public static synchronized PrintStream getDefaultStream() {
        return defaultStream;
    }

    public static synchronized void setDefaultStream(PrintStream newDefault) {
        defaultStream = newDefault;
    }

    public synchronized OutputStream getOutputStream() {
        return this.logOut;
    }

    public synchronized void setOutputStream(OutputStream out) {
        this.logOut = out;
        this.logWriter = new OutputStreamWriter(this.logOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) {
        if (b == 10) {
            LogStream logStream = this;
            synchronized (logStream) {
                OutputStream outputStream = this.logOut;
                synchronized (outputStream) {
                    this.buffer.setLength(0);
                    this.buffer.append(new Date().toString());
                    this.buffer.append(':');
                    this.buffer.append(this.name);
                    this.buffer.append(':');
                    this.buffer.append(Thread.currentThread().getName());
                    this.buffer.append(':');
                    try {
                        try {
                            this.logWriter.write(this.buffer.toString());
                            this.logWriter.flush();
                            this.bufOut.writeTo(this.logOut);
                            this.logOut.write(b);
                            this.logOut.flush();
                        }
                        catch (IOException e) {
                            this.setError();
                            Object var6_5 = null;
                            this.bufOut.reset();
                        }
                        Object var6_4 = null;
                        this.bufOut.reset();
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        this.bufOut.reset();
                        throw throwable;
                    }
                }
            }
        }
        super.write(b);
    }

    public void write(byte[] b, int off, int len) {
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException(len);
        }
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    public String toString() {
        return this.name;
    }

    public static int parseLevel(String s) {
        if (s == null || s.length() < 1) {
            return -1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            if (s.length() < 1) {
                return -1;
            }
            if ("SILENT".startsWith(s.toUpperCase())) {
                return 0;
            }
            if ("BRIEF".startsWith(s.toUpperCase())) {
                return 10;
            }
            if ("VERBOSE".startsWith(s.toUpperCase())) {
                return 20;
            }
            return -1;
        }
    }
}

