/*
 * Decompiled with CFR 0.152.
 */
package jeus.rmi.spec.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public final class UID
implements Serializable {
    private static long ONE_SECOND = 1000L;
    private static final short hostUnique = UID.getHostUniqueNum();
    private static final Object lock = new Object();
    private static long lastTime = System.currentTimeMillis();
    private static short lastCount = Short.MIN_VALUE;
    private static final long serialVersionUID = -2689133130147565626L;
    private final short unique;
    private final long time;
    private final short count;

    private static short getHostUniqueNum() {
        return (short)new Object().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UID() {
        this.unique = hostUnique;
        Object object = lock;
        synchronized (object) {
            if (lastCount == Short.MAX_VALUE) {
                boolean done = false;
                while (!done) {
                    long now = System.currentTimeMillis();
                    if (now < lastTime + ONE_SECOND) {
                        try {
                            Thread.sleep(ONE_SECOND);
                        }
                        catch (InterruptedException e) {}
                        continue;
                    }
                    lastTime = now;
                    lastCount = Short.MIN_VALUE;
                    done = true;
                }
            }
            this.time = lastTime;
            short s = lastCount;
            lastCount = (short)(s + 1);
            this.count = s;
        }
    }

    public UID(long num) {
        this.unique = (short)-1;
        this.time = num;
        this.count = 0;
    }

    private UID(short unique, long time, short count) {
        this.unique = unique;
        this.time = time;
        this.count = count;
    }

    public int hashCode() {
        return (int)this.time + this.count;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof UID) {
            UID uid = (UID)obj;
            return this.unique == uid.unique && this.count == uid.count && this.time == uid.time;
        }
        return false;
    }

    public String toString() {
        return Integer.toString(this.unique, 16) + ":" + Long.toString(this.time, 16) + ":" + Integer.toString(this.count, 16);
    }

    public void write(DataOutput out) throws IOException {
        out.writeShort(this.unique);
        out.writeLong(this.time);
        out.writeShort(this.count);
    }

    public static UID read(DataInput in) throws IOException {
        short unique = in.readShort();
        long time = in.readLong();
        short count = in.readShort();
        return new UID(unique, time, count);
    }
}

