/*
 * Decompiled with CFR 0.152.
 */
package jeus.schedule;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import jeus.util.PooledExecutorFactory;

class SchedulerExecutor {
    private Timer timer;
    private ExecutorService poolExecutor;
    private int poolMin;
    private int poolMax;
    private long poolKeepAlive;
    private static AtomicInteger count = new AtomicInteger();

    SchedulerExecutor(int pool_min, int pool_max, long pool_keepalive) {
        this.poolMin = pool_min;
        this.poolMax = pool_max;
        this.poolKeepAlive = pool_keepalive;
    }

    synchronized void init() {
        if (this.timer == null) {
            this.timer = new Timer(true);
        }
        if (this.poolExecutor == null) {
            String poolName = "Scheduler" + count.incrementAndGet();
            this.poolExecutor = (ExecutorService)PooledExecutorFactory.createThreadPoolExecutor(poolName, this.poolMin, this.poolMax, this.poolKeepAlive);
        }
    }

    synchronized void scheduleAtFixedRate(TimerTask timerTask, Date firstTime, long period) {
        this.init();
        this.timer.scheduleAtFixedRate(timerTask, firstTime, period);
    }

    synchronized void schedule(TimerTask timerTask, Date firstTime) {
        this.init();
        this.timer.schedule(timerTask, firstTime);
    }

    synchronized void cancel() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    synchronized void shutdown() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.poolExecutor != null) {
            this.poolExecutor.shutdownNow();
            this.poolExecutor = null;
        }
    }

    synchronized void execute(Runnable worker) {
        this.init();
        this.poolExecutor.execute(worker);
    }
}

