/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.base;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import jeus.security.base.SecurityException;
import jeus.security.base.Subject;
import jeus.security.resource.PrincipalImpl;
import jeus.security.resource.SystemPassword;
import jeus.security.util.LoggerUtil;
import jeus.util.message.JeusMessage_Security;

public final class CodeSubject
extends Subject {
    public static String CODE_PRINCIPAL_NAME = "code";

    public CodeSubject(String domainName) {
        super(domainName, new PrincipalImpl(CODE_PRINCIPAL_NAME));
        SystemPassword.initialSystemPassword(this);
    }

    public CodeSubject() {
        super(null, new PrincipalImpl(CODE_PRINCIPAL_NAME));
        SystemPassword.initialSystemPassword(this);
    }

    public static boolean isCode(Subject s) {
        try {
            return s instanceof CodeSubject;
        }
        catch (Exception e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._6_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._6_LEVEL, JeusMessage_Security._6, (Throwable)e);
            }
            return false;
        }
    }

    public byte[] serialize() throws SecurityException {
        try {
            ByteArrayOutputStream bytesOutput = new ByteArrayOutputStream(1024);
            DataOutputStream output = new DataOutputStream(bytesOutput);
            output.write(2);
            String domain = this.getDomainName();
            output.writeInt(domain.length());
            output.writeBytes(domain);
            return bytesOutput.toByteArray();
        }
        catch (Throwable e) {
            throw new SecurityException("Exception occurred during serialization", e);
        }
    }
}

