/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.base;

import java.security.Permission;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import jeus.security.base.PermissionMap;
import jeus.security.base.Policy;
import jeus.security.base.Role;
import jeus.security.resource.GroupPrincipalImpl;
import jeus.security.resource.RolePermission;
import jeus.security.util.Constants;
import jeus.security.util.InstanceMaker;
import jeus.security.util.PermissionMaker;

public class CustomJeusPolicy
extends Policy {
    public PermissionMap.CheckResult checkPermission(String contextId, Principal[] principals, Permission permission) {
        Set currentPrincipal = this.principalRolePolicy.getCheckedPermissions().keys();
        Vector<Object> principalSet = new Vector<Object>();
        Vector<Permission> rolePerms = new Vector<Permission>();
        for (int k = 0; k < principals.length; ++k) {
            if (currentPrincipal.contains(principals[k])) continue;
            if (principals[k].getClass().getName().equals(this.rolePrincipalClassName)) {
                try {
                    Permission perm = PermissionMaker.makePermission(Constants.DEFAULT_PR_PERMISSION_CLASSNAME, principals[k].getName(), null);
                    rolePerms.add(perm);
                    continue;
                }
                catch (Exception e) {
                    return PermissionMap.DENIED;
                }
            }
            if (!principals[k].getClass().getName().equals(this.userPrincipalClassName)) continue;
            try {
                principalSet.add(InstanceMaker.makeInstance(Constants.DEFAULT_PRINCIPAL_IMPL_CLASSNAME, new Object[]{principals[k].getName()}));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (principalSet.size() > 0) {
            principals = principalSet.toArray(new Principal[0]);
            Iterator iter = rolePerms.iterator();
            while (iter.hasNext()) {
                this.principalRolePolicy.addPermission((Permission)iter.next(), principals, false, false);
            }
        }
        if (permission instanceof RolePermission) {
            PermissionMap.CheckResult result = this.principalRolePolicy.checkPermission(permission);
            if (result.equals(PermissionMap.EXCLUDED) || result.equals(PermissionMap.UNCHECKED)) {
                return result;
            }
            for (int i = 0; i < principals.length; ++i) {
                GroupPrincipalImpl gp;
                Principal p = principals[i];
                result = this.principalRolePolicy.checkPermission(p, permission);
                if (result.isGranted()) {
                    return PermissionMap.GRANTED;
                }
                if (!(p instanceof GroupPrincipalImpl) || !(result = this.recursiveGroupImpl(contextId, permission, gp = (GroupPrincipalImpl)p)).isGranted()) continue;
                return PermissionMap.GRANTED;
            }
        } else {
            PermissionMap map = this.getResourcePolicy(contextId);
            if (map == null) {
                return PermissionMap.DENIED;
            }
            PermissionMap.CheckResult result = map.checkPermission(permission);
            if (result.equals(PermissionMap.EXCLUDED) || result.equals(PermissionMap.UNCHECKED)) {
                return result;
            }
            for (Role role : map.getCheckedReversePermissionImplies(permission)) {
                RolePermission rolePermission = new RolePermission(role);
                result = this.principalRolePolicy.checkPermission(rolePermission);
                if (result.equals(PermissionMap.EXCLUDED) || result.equals(PermissionMap.UNCHECKED)) {
                    return result;
                }
                for (int i = 0; i < principals.length; ++i) {
                    GroupPrincipalImpl gp;
                    Principal p = principals[i];
                    result = this.principalRolePolicy.checkPermission(p, rolePermission);
                    if (result.isGranted()) {
                        return PermissionMap.GRANTED;
                    }
                    if (!(p instanceof GroupPrincipalImpl) || !(result = this.recursiveGroupImpl(contextId, permission, gp = (GroupPrincipalImpl)p)).isGranted()) continue;
                    return PermissionMap.GRANTED;
                }
            }
        }
        return PermissionMap.DENIED;
    }
}

