/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.base;

import java.io.File;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.ObjectName;
import jeus.security.base.AnonymousSubject;
import jeus.security.base.CodeSubject;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.impl.login.JeusSecurityConfiguration;
import jeus.security.resource.CacheInfo;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.spi.AuthenticationService;
import jeus.security.spi.AuthorizationRepositoryService;
import jeus.security.spi.AuthorizationService;
import jeus.security.spi.LoginService;
import jeus.security.spi.NetworkService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.spi.SubjectFactoryService;
import jeus.security.spi.UserCertMappingService;
import jeus.security.util.Constants;
import jeus.security.util.NameAndPathUtil;
import jeus.security.util.OneToManyMap;
import jeus.util.ArrayListStack;
import jeus.util.EnvironmentCall;

public final class Domain {
    public static final String SYSTEM_DOMAIN_NAME = "SYSTEM_DOMAIN";
    private static String theDefaultDomainName;
    public static final String DEFAULT_CONFIGURATION_DIRECTORY_PROPERTY_KEY = "jeus.security.default.configDir";
    public static final String DEFAULT_DOMAIN_NAME_PROPERTY_KEY = "jeus.security.default.domainName";
    public static final String DEFAULT_APPLICATION_DOMAIN_NAME;
    public static final String SHARED_DOMAIN_NAME = "SHARED_DOMAIN";
    private static ThreadLocal currentDomain;
    private static Map domains;
    private static ThreadLocal currentDomainObj;
    public static final Domain SHARED_DOMAIN;
    private OneToManyMap services = new OneToManyMap();
    private String name;
    private String description = "(Description not available)";
    private Object securityDomainMo = null;
    private static Map codeSubjects;
    private static Map anonymousSubjects;
    private Map onlyOneServices = new HashMap();
    private JeusSecurityConfiguration loginConfig = null;
    private CacheInfo cacheInfo;
    private KeyStore keyStore;
    private String keyStorePath;
    private char[] keyStorePass;
    private char[] keyStoreKeyPass;
    private String keyStoreAlias;
    private KeyStore trustStore;
    private String trustStorePath;
    private char[] trustStorePass;
    private String policyClassName = Constants.DEFAULT_POLICY_IMPL_CLASSNAME;
    private String userPrincipalClassName = Constants.DEFAULT_PRINCIPAL_IMPL_CLASSNAME;
    private String rolePrincipalClassName = Constants.DEFAULT_ROLE_PRINCIPAL_IMPL_CLASSNAME;
    private boolean enableDigistService;
    private boolean enableClientCertService;

    public JeusSecurityConfiguration getLoginConfig() {
        return this.loginConfig;
    }

    public void setLoginConfig(JeusSecurityConfiguration loginConfig) {
        this.loginConfig = loginConfig;
    }

    public Domain(String name) {
        this.name = name;
    }

    public Domain(String name, String description) {
        this(name);
        if (description != null) {
            this.description = description;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean containsService(Class type) {
        return this.services.containsKey(type);
    }

    public void addService(Service s) {
        s.setDomain(this);
        this.services.put(s.getType(), s);
        if (s.getType() == LoginService.class || s.getType() == AuthenticationService.class || s.getType() == AuthorizationService.class || s.getType() == AuthenticationRepositoryService.class || s.getType() == AuthorizationRepositoryService.class || s.getType() == NetworkService.class || s.getType() == UserCertMappingService.class || s.getType() == SubjectFactoryService.class) {
            this.onlyOneServices.put(s.getType(), s);
        }
    }

    public void removeService(Service s) {
        s.setDomain(null);
        this.services.removeValue(s.getType(), s);
        if (s.getType() == LoginService.class || s.getType() == AuthenticationService.class || s.getType() == AuthorizationService.class || s.getType() == AuthenticationRepositoryService.class || s.getType() == AuthorizationRepositoryService.class || s.getType() == NetworkService.class || s.getType() == UserCertMappingService.class || s.getType() == SubjectFactoryService.class) {
            this.onlyOneServices.remove(s.getType());
        }
    }

    public void createAll() throws ServiceException, SecurityException {
        for (Service s : this.services.values()) {
            s.create();
        }
    }

    public void destroyAll() {
        for (Service s : this.services.values()) {
            s.destroy();
        }
    }

    public void clearServices() {
        this.services.clear();
        this.onlyOneServices.clear();
    }

    public Collection getServices(Class type) throws ServiceException, SecurityException {
        ArrayList services = new ArrayList();
        Collection orgServices = this.services.get(type);
        services.addAll(orgServices);
        if (this != SHARED_DOMAIN) {
            services.addAll(SHARED_DOMAIN.getServices(type));
        }
        if (services.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        for (Service s : services) {
            if (s.isCreated()) continue;
            s.create();
        }
        return services;
    }

    public Service getOneService(Class type) throws ServiceException, SecurityException {
        Service service = (Service)this.onlyOneServices.get(type);
        if (service == null) {
            if (this.name.equals(SHARED_DOMAIN_NAME)) {
                return null;
            }
            service = SHARED_DOMAIN.getOneService(type);
            if (service == null) {
                throw new ServiceException("Error getting Service: no Service of type " + type.getName() + " in domain " + this.getName() + " was found");
            }
        }
        return service;
    }

    public Collection getOneOrMoreServices(Class type) throws ServiceException, SecurityException {
        Collection services = this.getServices(type);
        if (services.size() == 0) {
            throw new ServiceException("Error getting Service: no Service of type " + type.getName() + " in domain " + this.getName() + " was found");
        }
        return services;
    }

    public Collection getZeroOrMoreServices(Class type) throws ServiceException, SecurityException {
        return this.getServices(type);
    }

    public Collection getServices() {
        return this.services.values();
    }

    public boolean isEmptyService() {
        return this.services.isEmpty();
    }

    public static Domain getDomain(String name) throws ServiceException {
        Domain d = (Domain)domains.get(name);
        if (d == null) {
            throw new ServiceException("Error getting domain: the domain named " + name + " does not exist");
        }
        return d;
    }

    public static Collection getDomains() {
        return domains.values();
    }

    public static void addDomain(Domain d) throws ServiceException {
        if (d == null) {
            throw new ServiceException("Error adding domain: domain is null");
        }
        domains.put(d.getName(), d);
        codeSubjects.put(d.getName(), new CodeSubject(d.getName()));
        anonymousSubjects.put(d.getName(), new AnonymousSubject(d.getName()));
    }

    public static void removeDomain(Domain d) throws ServiceException {
        if (d == null) {
            throw new ServiceException("Error removing domain: domain is null");
        }
        domains.remove(d.getName());
        codeSubjects.remove(d.getName());
        anonymousSubjects.remove(d.getName());
    }

    public static void clearDomains() {
        domains.clear();
        codeSubjects.clear();
        anonymousSubjects.clear();
    }

    public static void setCurrentDomain(String domainName) throws ServiceException {
        Domain.setCurrentDomain(Domain.getDomain(domainName));
    }

    public static void setCurrentDomain(Domain d) {
        ArrayListStack s = (ArrayListStack)currentDomain.get();
        s.push(d);
        currentDomainObj.set(d);
    }

    public static Domain getCurrentDomain() throws ServiceException {
        Domain domain = (Domain)currentDomainObj.get();
        if (domain == null) {
            ArrayListStack s = (ArrayListStack)currentDomain.get();
            if (s.empty()) {
                if (!SecurityInstaller.isSecurityInstalled()) {
                    return null;
                }
                currentDomainObj.set(Domain.getDomain(SecurityInstaller.getEnvironment().defaultDomainName));
                return (Domain)currentDomainObj.get();
            }
            currentDomainObj.set(s.peek());
            return (Domain)currentDomainObj.get();
        }
        return domain;
    }

    public static void unsetCurrentDomain() throws ServiceException {
        ArrayListStack s = (ArrayListStack)currentDomain.get();
        if (s.empty()) {
            throw new ServiceException("Error unsetting current domain: current domain not set");
        }
        s.pop();
        if (s.empty()) {
            currentDomainObj.set(null);
        } else {
            currentDomainObj.set(s.peek());
        }
    }

    public static void clearCurrentDomains() {
        ArrayListStack s = (ArrayListStack)currentDomain.get();
        s.clear();
        currentDomainObj.set(null);
    }

    public void registerMBean(ObjectName parent) {
    }

    public void unregisterMBean() {
    }

    public String getObjectName() {
        return null;
    }

    public static CodeSubject getCodeSubject() {
        return Domain.getCodeSubject(null);
    }

    public static CodeSubject getCodeSubject(String name) {
        CodeSubject codeS;
        if (name == null || name.equals("")) {
            name = Domain.getCodeSubjectDomainName();
        }
        if ((codeS = (CodeSubject)codeSubjects.get(name)) == null) {
            codeS = new CodeSubject(name);
            codeSubjects.put(name, codeS);
            return codeS;
        }
        return codeS;
    }

    public static Subject getAnonymousSubject() {
        return Domain.getAnonymousSubject(null);
    }

    public static Subject getAnonymousSubject(String name) {
        Subject subject;
        if (name == null || name.equals("")) {
            name = DEFAULT_APPLICATION_DOMAIN_NAME;
        }
        if ((subject = (Subject)anonymousSubjects.get(name)) == null) {
            subject = new AnonymousSubject(name);
            anonymousSubjects.put(name, subject);
            return subject;
        }
        return subject;
    }

    private static String getCodeSubjectDomainName() {
        Domain domain = (Domain)currentDomainObj.get();
        if (domain == null) {
            return SYSTEM_DOMAIN_NAME;
        }
        return domain.getName();
    }

    public CacheInfo getCacheInfo() {
        return this.cacheInfo;
    }

    public void setCacheInfo(CacheInfo cacheInfo) {
        this.cacheInfo = cacheInfo;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public char[] getKeyStorePass() {
        return this.keyStorePass;
    }

    public void setKeyStorePass(char[] keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    public char[] getTrustStorePass() {
        return this.trustStorePass;
    }

    public void setTrustStorePass(char[] trustStorePass) {
        this.trustStorePass = trustStorePass;
    }

    public String getPolicyClassName() {
        return this.policyClassName;
    }

    public void setPolicyClassName(String policyClassName) {
        this.policyClassName = policyClassName;
    }

    public String getUserPrincipalClassName() {
        return this.userPrincipalClassName;
    }

    public void setUserPrincipalClassName(String userPrincipalClassName) {
        this.userPrincipalClassName = userPrincipalClassName;
    }

    public String getRolePrincipalClassName() {
        return this.rolePrincipalClassName;
    }

    public void setRolePrincipalClassName(String rolePrincipalClassName) {
        this.rolePrincipalClassName = rolePrincipalClassName;
    }

    public Object getDomainMBean() {
        return this.securityDomainMo;
    }

    public void setDomainMBean(Object domainBean) {
        this.securityDomainMo = domainBean;
    }

    public boolean isEnableClientCertService() {
        return this.enableClientCertService;
    }

    public void setEnableClientCertService(boolean enableClientCertService) {
        this.enableClientCertService = enableClientCertService;
    }

    public boolean isEnableDigistService() {
        return this.enableDigistService;
    }

    public void setEnableDigistService(boolean enableDigistService) {
        this.enableDigistService = enableDigistService;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public char[] getKeyStoreKeyPass() {
        return this.keyStoreKeyPass;
    }

    public void setKeyStoreKeyPass(char[] keyStoreKeyPass) {
        this.keyStoreKeyPass = keyStoreKeyPass;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public void setKeyStoreAlias(String keyStoreAlias) {
        this.keyStoreAlias = keyStoreAlias;
    }

    static {
        File theFile;
        String theConfigurationDirectory = System.getProperty(DEFAULT_CONFIGURATION_DIRECTORY_PROPERTY_KEY);
        if (theConfigurationDirectory == null) {
            String jeusConfigHome = EnvironmentCall.getJeusConfigHome();
            theConfigurationDirectory = jeusConfigHome == null ? "./" : jeusConfigHome + File.separator + EnvironmentCall.getLocalVirutalName() + File.separator + "security";
        }
        if ((theDefaultDomainName = System.getProperty(DEFAULT_DOMAIN_NAME_PROPERTY_KEY)) == null) {
            theDefaultDomainName = "DEFAULT_APPLICATION_DOMAIN";
        }
        if (!(theFile = new File(NameAndPathUtil.getPathWithEndingSeparator(theConfigurationDirectory) + theDefaultDomainName)).exists()) {
            theDefaultDomainName = SYSTEM_DOMAIN_NAME;
        }
        DEFAULT_APPLICATION_DOMAIN_NAME = theDefaultDomainName;
        currentDomain = new InheritableThreadLocal(){

            protected Object initialValue() {
                return new ArrayListStack();
            }

            protected Object childValue(Object parentValue) {
                ArrayListStack s = new ArrayListStack();
                ArrayListStack parentStack = (ArrayListStack)parentValue;
                if (!parentStack.isEmpty()) {
                    s.push(parentStack.peek());
                }
                return s;
            }
        };
        domains = new Hashtable();
        currentDomainObj = new ThreadLocal();
        SHARED_DOMAIN = new Domain(SHARED_DOMAIN_NAME);
        codeSubjects = new Hashtable();
        anonymousSubjects = new Hashtable();
    }
}

