/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.base;

import java.io.Serializable;
import java.security.Permission;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jeus.security.base.PermissionMap;
import jeus.security.base.Role;
import jeus.security.resource.GroupPrincipalImpl;
import jeus.security.resource.RolePermission;
import jeus.security.util.CopyOnWriteHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Policy
implements Cloneable,
Serializable {
    public static final String DEFAULT_CONTEXT_ID = "default";
    protected PermissionMap principalRolePolicy = new PermissionMap();
    protected Map<String, PermissionMap> roleResourcePolicy = new ConcurrentHashMap<String, PermissionMap>();
    protected String userPrincipalClassName;
    protected String rolePrincipalClassName;

    public PermissionMap getRolePolicy() {
        return this.principalRolePolicy;
    }

    public PermissionMap getResourcePolicy(String contextId, boolean create) {
        PermissionMap pm = this.roleResourcePolicy.get(contextId);
        if (pm == null && create) {
            pm = new PermissionMap(true);
            this.roleResourcePolicy.put(contextId, pm);
        }
        return pm;
    }

    public PermissionMap getResourcePolicy(String contextId) {
        return this.getResourcePolicy(contextId, false);
    }

    public void removeResourcePolicy(String contextId) {
        this.roleResourcePolicy.remove(contextId);
    }

    public Set<String> getResourcePolicyIds() {
        return this.roleResourcePolicy.keySet();
    }

    public Policy add(Policy otherPolicy) {
        if (otherPolicy != null && otherPolicy != this) {
            this.getRolePolicy().add(otherPolicy.getRolePolicy());
            for (String id : otherPolicy.getResourcePolicyIds()) {
                this.getResourcePolicy(id, true).add(otherPolicy.getResourcePolicy(id));
            }
        }
        return this;
    }

    public Policy remove(Policy otherPolicy) {
        if (otherPolicy == null) {
            return this;
        }
        if (otherPolicy == this) {
            this.getRolePolicy().clear();
            this.roleResourcePolicy.clear();
        } else {
            this.getRolePolicy().remove(otherPolicy.getRolePolicy());
            for (String id : otherPolicy.getResourcePolicyIds()) {
                PermissionMap pm = this.getResourcePolicy(id);
                if (pm == null) continue;
                pm.remove(otherPolicy.getResourcePolicy(id));
            }
        }
        return this;
    }

    public PermissionMap.CheckResult checkPermission(String contextId, Permission permission) {
        return this.checkPermission(contextId, (Principal)null, permission);
    }

    public PermissionMap.CheckResult checkPermission(Permission permission) {
        return this.checkPermission(DEFAULT_CONTEXT_ID, (Principal)null, permission);
    }

    public PermissionMap.CheckResult checkPermission(Principal principal, Permission permission) {
        return this.checkPermission(DEFAULT_CONTEXT_ID, principal, permission);
    }

    public PermissionMap.CheckResult checkPermission(String contextId, Principal principal, Permission permission) {
        if (this.isUnchecked()) {
            return PermissionMap.GRANTED;
        }
        if (permission instanceof RolePermission) {
            PermissionMap.CheckResult result = this.principalRolePolicy.checkPermission(permission);
            if (result.equals(PermissionMap.EXCLUDED) || result.equals(PermissionMap.UNCHECKED)) {
                return result;
            }
            result = this.principalRolePolicy.checkPermission(principal, permission);
            if (result.isGranted()) {
                return PermissionMap.GRANTED;
            }
        } else {
            PermissionMap map = this.getResourcePolicy(contextId);
            if (map == null) {
                return PermissionMap.DENIED;
            }
            PermissionMap.CheckResult result = map.checkPermission(permission);
            if (result.equals(PermissionMap.EXCLUDED) || result.equals(PermissionMap.UNCHECKED)) {
                return result;
            }
            for (Role role : map.getCheckedReversePermissionImplies(permission)) {
                RolePermission rolePermission = new RolePermission(role);
                result = this.principalRolePolicy.checkPermission(rolePermission);
                if (result.equals(PermissionMap.EXCLUDED) || result.equals(PermissionMap.UNCHECKED)) {
                    return result;
                }
                result = this.principalRolePolicy.checkPermission(principal, rolePermission);
                if (!result.isGranted()) continue;
                return PermissionMap.GRANTED;
            }
        }
        return PermissionMap.DENIED;
    }

    public PermissionMap.CheckResult checkPermission(String contextId, Principal[] principals, Permission permission) {
        if (this.isUnchecked()) {
            return PermissionMap.GRANTED;
        }
        if (permission instanceof RolePermission) {
            PermissionMap.CheckResult result = this.principalRolePolicy.checkPermission(permission);
            if (result.equals(PermissionMap.EXCLUDED) || result.equals(PermissionMap.UNCHECKED)) {
                return result;
            }
            for (int i = 0; i < principals.length; ++i) {
                GroupPrincipalImpl gp;
                Principal p = principals[i];
                result = this.principalRolePolicy.checkPermission(p, permission);
                if (result.isGranted()) {
                    return PermissionMap.GRANTED;
                }
                if (!(p instanceof GroupPrincipalImpl) || !(result = this.recursiveGroupImpl(contextId, permission, gp = (GroupPrincipalImpl)p)).isGranted()) continue;
                return PermissionMap.GRANTED;
            }
        } else {
            PermissionMap map = this.getResourcePolicy(contextId);
            if (map == null) {
                return PermissionMap.DENIED;
            }
            PermissionMap.CheckResult result = map.checkPermission(permission);
            if (result.equals(PermissionMap.EXCLUDED) || result.equals(PermissionMap.UNCHECKED)) {
                return result;
            }
            for (Role role : map.getCheckedReversePermissionImplies(permission)) {
                RolePermission rolePermission = new RolePermission(role);
                result = this.principalRolePolicy.checkPermission(rolePermission);
                if (result.equals(PermissionMap.EXCLUDED) || result.equals(PermissionMap.UNCHECKED)) {
                    return result;
                }
                for (int i = 0; i < principals.length; ++i) {
                    GroupPrincipalImpl gp;
                    Principal p = principals[i];
                    result = this.principalRolePolicy.checkPermission(p, rolePermission);
                    if (result.isGranted()) {
                        return PermissionMap.GRANTED;
                    }
                    if (!(p instanceof GroupPrincipalImpl) || !(result = this.recursiveGroupImpl(contextId, permission, gp = (GroupPrincipalImpl)p)).isGranted()) continue;
                    return PermissionMap.GRANTED;
                }
            }
        }
        return PermissionMap.DENIED;
    }

    protected boolean isUnchecked() {
        boolean isUnchecked = true;
        for (String contextId : this.roleResourcePolicy.keySet()) {
            if (this.roleResourcePolicy.get(contextId).isUnchecked()) continue;
            isUnchecked = false;
        }
        return isUnchecked;
    }

    protected PermissionMap.CheckResult recursiveGroupImpl(String contextId, Permission permission, GroupPrincipalImpl grpImpl) {
        Principal[] grpPrincipals;
        PermissionMap.CheckResult result = PermissionMap.DENIED;
        if (grpImpl != null && (grpPrincipals = grpImpl.getSubGroups()) != null) {
            result = this.checkPermission(contextId, grpPrincipals, permission);
        }
        return result;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("\n______________POLICY_______________\n\n");
        strBuf.append("ROLE PERMISSIONS:\n" + this.principalRolePolicy + "\n");
        strBuf.append("RESOURCE PERMISSIONS:\n");
        for (String id : this.getResourcePolicyIds()) {
            PermissionMap pm = this.getResourcePolicy(id);
            strBuf.append("Context id: " + id + "\n" + pm + "\n\n");
        }
        return strBuf.toString();
    }

    public boolean equals(Object anotherObject) {
        if (this == anotherObject) {
            return true;
        }
        if (anotherObject == null) {
            return false;
        }
        if (anotherObject instanceof Policy) {
            Policy dpc = (Policy)anotherObject;
            return this.getRolePolicy().equals(dpc.getRolePolicy()) && ((Object)this.roleResourcePolicy).equals(dpc.roleResourcePolicy);
        }
        return false;
    }

    public int hashCode() {
        return this.getRolePolicy().hashCode() + ((Object)this.roleResourcePolicy).hashCode();
    }

    public Object clone() {
        Policy newDPC = new Policy();
        newDPC.setUserPrincipalClassName(this.getUserPrincipalClassName());
        newDPC.setRolePrincipalClassName(this.getRolePrincipalClassName());
        newDPC.add(this);
        return newDPC;
    }

    public Collection getAllPermissions() {
        HashSet result = new HashSet();
        result.addAll(this.getRolePolicy().getAllPermissions());
        for (String id : this.getResourcePolicyIds()) {
            PermissionMap pm = this.getResourcePolicy(id);
            result.addAll(pm.getAllPermissions());
        }
        return new CopyOnWriteHashSet(result);
    }

    public String getUserPrincipalClassName() {
        return this.userPrincipalClassName;
    }

    public void setUserPrincipalClassName(String userPrincipalClassName) {
        this.userPrincipalClassName = userPrincipalClassName;
    }

    public String getRolePrincipalClassName() {
        return this.rolePrincipalClassName;
    }

    public void setRolePrincipalClassName(String rolePrincipalClassName) {
        this.rolePrincipalClassName = rolePrincipalClassName;
    }
}

