/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.container.web;

import java.security.Permission;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;

public class HTTPMethod {
    private HashSet methods = new HashSet();
    public static final int MAX_METHOD_SIZE = 8;
    public static final String GET_METHOD = "GET";
    public static final String POST_METHOD = "POST";
    public static final String PUT_METHOD = "PUT";
    public static final String DELETE_METHOD = "DELETE";
    public static final String HEAD_METHOD = "HEAD";
    public static final String OPTIONS_METHOD = "OPTIONS";
    public static final String TRACE_METHOD = "TRACE";
    public static final String PROPFIND_METHOD = "PROPFIND";
    public static final String[] ALL_METHODS = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE"};

    public HTTPMethod() {
    }

    public HTTPMethod(Permission perm) {
        this();
        String methods = perm.getActions();
        if (methods != null) {
            StringTokenizer st = new StringTokenizer(methods, ",");
            while (st.hasMoreTokens()) {
                this.addMethod(st.nextToken());
            }
        }
    }

    public HTTPMethod(String method) {
        this();
        this.addMethod(method.toUpperCase());
    }

    public HTTPMethod(HTTPMethod method) {
        this();
        this.merge(method);
    }

    public String getHTTPMethods() {
        if (this.methods.size() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.methods.iterator();
        buf.append((String)iter.next());
        while (iter.hasNext()) {
            String s = (String)iter.next();
            buf.append(",");
            buf.append(s);
        }
        return buf.toString();
    }

    public HTTPMethod getInverseHTTPMethod() {
        if (this.methods.size() == 0 || this.methods.size() == 8) {
            return null;
        }
        HTTPMethod inverseHTTPMethod = new HTTPMethod();
        for (int i = 0; i < ALL_METHODS.length; ++i) {
            String methodToCheck = ALL_METHODS[i];
            if (this.methods.contains(methodToCheck)) continue;
            inverseHTTPMethod.addMethod(methodToCheck);
        }
        if (inverseHTTPMethod.size() == 0) {
            return null;
        }
        return inverseHTTPMethod;
    }

    public String getInverseHTTPMethods() {
        if (this.methods.size() == 0 || this.methods.size() == 8) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.methods.iterator();
        buf.append((String)iter.next());
        while (iter.hasNext()) {
            String s = (String)iter.next();
            buf.append(",");
            buf.append(s);
        }
        return "!" + buf.toString();
    }

    public void addMethod(String method) {
        this.methods.add(method);
    }

    public HTTPMethod merge(HTTPMethod otherHTTPMethod) {
        if (otherHTTPMethod == null) {
            return this;
        }
        for (String method : otherHTTPMethod.methods) {
            this.addMethod(method);
        }
        return this;
    }

    public boolean equals(Object anotherObject) {
        if (anotherObject == this) {
            return true;
        }
        if (anotherObject == null) {
            return false;
        }
        if (anotherObject instanceof HTTPMethod) {
            HTTPMethod method = (HTTPMethod)anotherObject;
            return this.methods.equals(method.methods);
        }
        return false;
    }

    public int hashCode() {
        return this.methods.hashCode();
    }

    public static HTTPMethod union(HTTPMethod method1, HTTPMethod method2) {
        HTTPMethod method = new HTTPMethod();
        method.merge(method1);
        method.merge(method2);
        return method;
    }

    public int size() {
        return this.methods.size();
    }

    public String toString() {
        return this.methods.toString();
    }
}

