/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.network;

import java.io.IOException;
import java.net.Socket;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import jeus.io.protocol.message.ContentHandlerCreator;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.Endpoint;
import jeus.net.NoListenID;
import jeus.net.SocketID;
import jeus.net.impl.NodeInfo;
import jeus.security.base.Environment;
import jeus.security.base.NetworkMessage;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.impl.network.AbstractNetworkService;
import jeus.security.impl.network.ClientSecurityConnectionListener;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.LoggerUtil;
import jeus.util.EnvironmentCall;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Security;
import jeus.util.properties.JeusSecurityProperties;

public class ClientSocketNetworkService
extends AbstractNetworkService
implements ConnectionListenerFactory {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.security");

    protected Object processException(Exception e) {
        e.printStackTrace();
        return null;
    }

    protected boolean loginSubject(NetworkMessage message, boolean loggedIn) throws ServiceException, SecurityException {
        return false;
    }

    public Object getMBean() {
        return null;
    }

    protected MBeanInfo getMBeanInfo() {
        return null;
    }

    protected int getLocalPort() {
        return SecurityInstaller.getEnvironment().baseSecurityPort;
    }

    protected int getRemotePort(int hostIndex) {
        int[] ports = SecurityInstaller.getEnvironment().remoteBaseSecurityPorts;
        if (ports != null && ports.length > hostIndex && ports[hostIndex] >= 0) {
            return ports[hostIndex];
        }
        return this.getLocalPort();
    }

    protected int[] getRemotePorts() {
        return SecurityInstaller.getEnvironment().remoteBaseSecurityPorts;
    }

    protected String[] getHosts() {
        return SecurityInstaller.getEnvironment().hostNames;
    }

    protected void doCreate() throws ServiceException {
        try {
            Environment env = SecurityInstaller.getEnvironment();
            if (!env.client && !env.slave) {
                throw new RuntimeException("Failed to create ClientSocketNetworkService: JVM is not client or slave");
            }
            String name = "ClientSecurity";
            this.endpoint = new Endpoint(name, EnvironmentCall.getSecurityIOComponent("IO-" + name, 0, false), (SocketID)new NoListenID(env.client ? 2 : 1), new ContentHandlerCreator(), this, EnvironmentCall.getSecuritySSLContext(JeusSecurityProperties.USE_SSL));
            try {
                this.endpoint.export();
            }
            catch (IOException e) {
                throw new JeusRuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new ServiceException("Failed to create ClientSocketNetworkService: unexpected exception occured", e);
        }
    }

    public void doRegisterMBean(ObjectName parent) {
    }

    protected void connect() {
        String[] hosts = this.getHosts();
        if (hosts == null) {
            return;
        }
        for (int i = 0; i < hosts.length; ++i) {
            String host = hosts[i];
            int port = this.getRemotePort(i);
            try {
                NodeInfo nodeInfo = JeusSecurityProperties.USE_SSL ? new NodeInfo(host, EnvironmentCall.getSecuritySSLPort(), 0) : new NodeInfo(host, port, EnvironmentCall.getSecurityID(), 0);
                this.endpoint.getSocketStream(nodeInfo, retries, connectPiggybackData, 0, 0);
                continue;
            }
            catch (Exception e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._23_LEVEL)) continue;
                LoggerUtil.logger.log(JeusMessage_Security._23_LEVEL, JeusMessage_Security._23, (Throwable)e);
            }
        }
    }

    public void addClientConnect(String host, int port) {
        block2: {
            try {
                NodeInfo nodeInfo = JeusSecurityProperties.USE_SSL ? new NodeInfo(host, EnvironmentCall.getSecuritySSLPort(), 0) : new NodeInfo(host, port, EnvironmentCall.getSecurityID(), 0);
                this.endpoint.getSocketStream(nodeInfo, retries, connectPiggybackData, 0, 0);
            }
            catch (Exception e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._23_LEVEL)) break block2;
                LoggerUtil.logger.log(JeusMessage_Security._23_LEVEL, JeusMessage_Security._23, (Throwable)e);
            }
        }
    }

    public ConnectionListener createConnectionListener(Socket socket, SocketID socketID) {
        return new ClientSecurityConnectionListener(this);
    }
}

