/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.impl.network;

import java.io.IOException;
import java.util.logging.Level;
import jeus.net.AcceptorConnectionListenerSupport;
import jeus.net.SocketStream;
import jeus.net.impl.NodeInfo;
import jeus.security.base.Domain;
import jeus.security.base.Environment;
import jeus.security.base.NetworkMessage;
import jeus.security.base.ServiceException;
import jeus.security.impl.network.AbstractNetworkService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.LoggerUtil;
import jeus.util.WaitTimeoutException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Security;
import jeus.util.properties.JeusSecurityProperties;

public abstract class SecurityConnectionListener
extends AcceptorConnectionListenerSupport {
    protected AbstractNetworkService networkService;
    protected Environment remoteEnv;
    protected boolean waitForReply;
    protected Object reply;
    private Object lock = new Object();
    private JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.security");

    public SecurityConnectionListener(AbstractNetworkService networkService) {
        this.networkService = networkService;
    }

    public Environment getRemoteEnvironment() {
        return this.remoteEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getReply() throws Exception {
        long initialTime = System.currentTimeMillis();
        while (this.reply == null) {
            long waitTime = JeusSecurityProperties.SECURITY_WAIT_TIME_OUT - (System.currentTimeMillis() - initialTime);
            if (waitTime <= 0L) {
                throw new WaitTimeoutException("[ERROR] timeout to wait for security reply message");
            }
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.wait(waitTime);
                }
            }
            catch (InterruptedException e) {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._40_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._40_LEVEL, JeusMessage_Security._40, (Throwable)e);
                }
                throw e;
            }
        }
        this.waitForReply = false;
        Object result = this.reply;
        this.reply = null;
        return result;
    }

    public void setWaitReply() {
        this.waitForReply = true;
    }

    public void connectionClosed(Exception exception, SocketStream socketStream) {
        this.networkService.cleanup(this.remoteEnv);
        if (exception != null) {
            this.logger.log(Level.FINE, "Exception occurred from Security SocketStream connection", (Throwable)exception);
        }
    }

    public void connectionAccepted(SocketStream sockStream, int connectionType, Object piggybackedData) {
        this.remoteEnv = (Environment)piggybackedData;
        if (!this.remoteEnv.securitySwitch) {
            SecurityInstaller.disableSecurity();
        }
        String[] remoteDomains = this.remoteEnv.domains;
        for (int i = 0; i < remoteDomains.length; ++i) {
            try {
                Domain.getDomain(remoteDomains[i]);
                continue;
            }
            catch (ServiceException e) {
                try {
                    Domain.addDomain(new Domain(remoteDomains[i], "Remote domain added to client side domain"));
                    continue;
                }
                catch (ServiceException e1) {
                    // empty catch block
                }
            }
        }
        this.remoteEnv.setNodeInfo((NodeInfo)sockStream.getSocketID());
    }

    protected void receiveRequest(Object message, SocketStream sockStream) {
        block5: {
            NetworkMessage msg;
            try {
                msg = (NetworkMessage)message;
            }
            catch (Exception e) {
                throw new RuntimeException("Unknown message type : " + message, e);
            }
            boolean needReply = !msg.isBroadcasted();
            msg.setBroadcasted(false);
            Object reply = this.networkService.handleMessage(msg, sockStream);
            if (needReply && reply != null) {
                try {
                    sockStream.write(AbstractNetworkService.convertToStream(reply));
                }
                catch (IOException e) {
                    if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._45_LEVEL)) break block5;
                    LoggerUtil.logger.log(JeusMessage_Security._45_LEVEL, JeusMessage_Security._45, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveReply(Object message) {
        if (message instanceof NetworkMessage) {
            NetworkMessage msg = (NetworkMessage)message;
            switch (msg.getOpcode()) {
                case 65: {
                    this.reply = msg.getArguments()[0];
                    break;
                }
                case 64: {
                    this.reply = msg.getSubject();
                    break;
                }
                case 66: {
                    this.reply = Boolean.TRUE;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown opcode : " + msg.getOpcode());
                }
            }
        } else if (message instanceof Exception) {
            this.reply = message;
        } else {
            throw new RuntimeException("Unknown message type : " + message);
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }
}

