/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.util.Properties;
import jeus.security.base.CredentialFactory;
import jeus.security.base.CredentialFactoryException;
import jeus.security.base.EncryptionException;
import jeus.security.resource.Password;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.LoggerUtil;
import jeus.util.message.JeusMessage_Security;

public class DefaultPasswordFactory
extends Properties
implements CredentialFactory {
    public static final String PASSWORD_PROPERTY_KEY = "password";
    public static final String ALGORITHM_PROPERTY_KEY = "algorithm";

    public DefaultPasswordFactory() {
    }

    public DefaultPasswordFactory(String password) {
        this.setProperty(PASSWORD_PROPERTY_KEY, password);
    }

    public DefaultPasswordFactory(String algorithm, String password) {
        this.setProperty(ALGORITHM_PROPERTY_KEY, algorithm);
        try {
            this.setProperty(PASSWORD_PROPERTY_KEY, EncryptionUtil.encryptPassword(algorithm, password));
        }
        catch (EncryptionException e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._68_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._68_LEVEL, "[ERROR] encryption failed", (Throwable)e);
            }
            this.setProperty(PASSWORD_PROPERTY_KEY, null);
        }
    }

    public String getPassword() {
        return this.getProperty(PASSWORD_PROPERTY_KEY);
    }

    public String getAlgorithm() {
        return this.getProperty(ALGORITHM_PROPERTY_KEY);
    }

    public boolean equals(Object another) {
        if (another == null || !(another instanceof DefaultPasswordFactory)) {
            return false;
        }
        if (this == another) {
            return true;
        }
        return super.equals(another);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object getCredential() throws CredentialFactoryException {
        String password = this.getPassword();
        if (password == null) {
            throw new CredentialFactoryException("Error creating Password: the password property is null");
        }
        return new Password(this.getAlgorithm(), password);
    }

    public boolean isPublicCredential() {
        return false;
    }
}

