/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jeus.security.resource.PrincipalImpl;
import jeus.security.util.CompoundEnumeration;

public class GroupPrincipalImpl
extends PrincipalImpl
implements Group {
    private Hashtable individuals = new Hashtable();
    private Vector subgroups = new Vector();
    private String description = "No Description";

    public GroupPrincipalImpl(String groupName) {
        super(groupName);
    }

    public GroupPrincipalImpl(String groupName, String description) {
        super(groupName);
        this.description = description;
    }

    public Enumeration members() {
        Enumeration[] aenumeration = new Enumeration[]{this.individuals.keys(), this.subgroups.elements()};
        return new CompoundEnumeration(aenumeration);
    }

    public Principal[] getMembers() {
        if (this.individuals != null) {
            return this.individuals.values().toArray(new Principal[0]);
        }
        return null;
    }

    public Principal[] getSubGroups() {
        if (this.subgroups != null && this.subgroups.size() > 0) {
            return this.subgroups.toArray(new GroupPrincipalImpl[this.subgroups.size()]);
        }
        return null;
    }

    public int subGroupSize() {
        return this.subgroups.size();
    }

    public int principalSize() {
        return this.individuals.size();
    }

    public boolean removeMember(Principal user) {
        if (user instanceof Group) {
            return this.subgroups.removeElement(user);
        }
        return this.individuals.remove(user) != null;
    }

    public boolean addMember(Principal group) throws IllegalArgumentException {
        if (this.getName().equals(((Object)group).toString())) {
            throw new IllegalArgumentException("Group " + this.getName() + " can't be added to itself");
        }
        if (this.isMember(group)) {
            return false;
        }
        if (group instanceof Group) {
            this.subgroups.addElement(group);
        } else {
            this.individuals.put(group, group);
        }
        return true;
    }

    public boolean isMember(Principal member) {
        if (member instanceof Group) {
            Enumeration enum_ = this.subgroups.elements();
            while (enum_.hasMoreElements()) {
                Group group = (Group)enum_.nextElement();
                if (!group.equals(member) && !group.isMember(member)) continue;
                return true;
            }
        } else if (this.individuals.get(member) != null) {
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer(this.getName());
        tmp.append("(members:");
        Enumeration iter = this.members();
        while (iter.hasMoreElements()) {
            tmp.append(iter.nextElement());
            tmp.append(',');
        }
        tmp.setCharAt(tmp.length() - 1, ')');
        return tmp.toString();
    }

    private class IndexEnumeration
    implements Enumeration {
        private Enumeration iter;

        IndexEnumeration() {
            this.iter = GroupPrincipalImpl.this.subgroups.size() > 0 ? GroupPrincipalImpl.this.subgroups.elements() : GroupPrincipalImpl.this.individuals.keys();
        }

        public boolean hasMoreElements() {
            boolean hasMore = this.iter != null && this.iter.hasMoreElements();
            return hasMore;
        }

        public Object nextElement() {
            Object next = null;
            if (this.iter != null) {
                next = this.iter.nextElement();
            }
            return next;
        }
    }
}

