/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jeus.security.base.DecryptionException;
import jeus.security.base.EncryptionException;
import jeus.security.util.EncryptionUtil;
import jeus.security.util.LoggerUtil;
import jeus.util.message.JeusMessage_Security;

public class Password
implements Serializable {
    static final long serialVersionUID = -4429278291333984214L;
    static final Pattern pattern = Pattern.compile("(\\{([\\w]*)\\})?([\\w]+)");
    private String algorithm;
    private String password;
    private String plainPassword;

    public static Password createPassword(String expression) throws IllegalArgumentException {
        Matcher matcher = pattern.matcher(expression);
        if (!matcher.matches() || matcher.groupCount() < 3) {
            throw new IllegalArgumentException("invalid password expression : " + expression);
        }
        String algorithm = matcher.group(2);
        String password = matcher.group(3);
        if (algorithm != null && !EncryptionUtil.checkAlgorithm(algorithm)) {
            throw new IllegalArgumentException("invalid encryption algorithm " + algorithm);
        }
        return new Password(algorithm, password);
    }

    public Password(String password) {
        this.password = password;
        this.plainPassword = password;
    }

    public Password(String algorithm, String password) {
        this.algorithm = algorithm;
        this.password = password;
        if (algorithm != null && !algorithm.equalsIgnoreCase("SHA")) {
            try {
                this.plainPassword = EncryptionUtil.decryptPassword(algorithm, password);
            }
            catch (DecryptionException e) {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._62_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._62_LEVEL, JeusMessage_Security._62, new Object[]{"decryption", "password instantiation, password:" + password}, (Throwable)e);
                }
                this.plainPassword = null;
            }
        } else {
            this.plainPassword = password;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public String getPlainPassword() {
        return this.plainPassword;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public boolean equals(Object another) {
        if (another == null || !(another instanceof Password)) {
            return false;
        }
        Password pw = (Password)another;
        if (pw.password == null || this.password == null) {
            return false;
        }
        return this.password.equals(pw.password);
    }

    public int hashCode() {
        if (this.password == null) {
            return 0;
        }
        return this.password.hashCode();
    }

    public synchronized boolean implies(Password password) {
        if (this.algorithm != null && this.algorithm.equalsIgnoreCase("SHA")) {
            try {
                String encodePassword = EncryptionUtil.encryptPassword(this.getAlgorithm(), password.plainPassword);
                return this.password.equals(encodePassword);
            }
            catch (EncryptionException e) {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._62_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._62_LEVEL, "[ERROR] {0} failed while {1}", new Object[]{"encryption", "equal check"});
                }
                return false;
            }
        }
        return this.plainPassword.equals(password.plainPassword);
    }

    public String toString() {
        return "{algorithm=" + this.algorithm + ", password=" + this.password + "}";
    }
}

