/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.util.Properties;
import jeus.security.base.CredentialFactory;
import jeus.security.base.CredentialFactoryException;
import jeus.security.resource.Password;
import jeus.security.util.Base64Coder;

public class PasswordFactory
extends Properties
implements CredentialFactory {
    public static final String PASSWORD_PROPERTY_KEY = "password";

    public PasswordFactory() {
    }

    public PasswordFactory(String password) {
        this.setProperty(PASSWORD_PROPERTY_KEY, Base64Coder.encode(password));
    }

    public String getPassword() {
        return this.getProperty(PASSWORD_PROPERTY_KEY);
    }

    public boolean equals(Object another) {
        if (another == null || !(another instanceof PasswordFactory)) {
            return false;
        }
        if (this == another) {
            return true;
        }
        return super.equals(another);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object getCredential() throws CredentialFactoryException {
        String password = this.getPassword();
        if (password == null) {
            throw new CredentialFactoryException("Error creating Password: the password property is null");
        }
        return new Password(password);
    }

    public boolean isPublicCredential() {
        return false;
    }
}

