/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import jeus.security.resource.DefaultTimedEntry;
import jeus.security.resource.SecurityCache;
import jeus.security.util.TimedEntry;

public class TimerCache
extends TimerTask
implements SecurityCache {
    protected static Timer resolutionTimer = new Timer(true);
    protected Map entryMap;
    protected long defaultLifetime;
    protected boolean threadSafe;
    protected long now;
    protected int resolution;

    public TimerCache() {
        this(1800L, false, 0);
    }

    public TimerCache(long defaultLifetime) {
        this(defaultLifetime, false, 0);
    }

    public TimerCache(long defaultLifetime, boolean threadSafe, int resolution) {
        this.defaultLifetime = defaultLifetime;
        this.threadSafe = threadSafe;
        if (resolution <= 0) {
            resolution = 60;
        }
        this.resolution = resolution;
    }

    public void create() {
        this.entryMap = this.threadSafe ? Collections.synchronizedMap(new HashMap()) : new HashMap();
        this.now = System.currentTimeMillis();
    }

    public void start() {
        resolutionTimer.scheduleAtFixedRate((TimerTask)this, 0L, (long)(1000 * this.resolution));
    }

    public void stop() {
        super.cancel();
        this.flush();
    }

    public void destroy() {
        this.entryMap.clear();
    }

    public Object get(Object key) {
        TimedEntry entry = (TimedEntry)this.entryMap.get(key);
        if (entry == null) {
            return null;
        }
        if (!entry.isCurrent(this.now) && !entry.refresh()) {
            entry.destroy();
            this.entryMap.remove(key);
            return null;
        }
        return entry.getValue();
    }

    public Object peek(Object key) {
        TimedEntry entry = (TimedEntry)this.entryMap.get(key);
        Object value = null;
        if (entry != null) {
            value = entry.getValue();
        }
        return value;
    }

    public Object put(Object key, Object value) {
        if (this.entryMap.containsKey(key)) {
            return value;
        }
        TimedEntry entry = value instanceof TimedEntry ? (TimedEntry)value : new DefaultTimedEntry(this.defaultLifetime, value);
        entry.init(this.now);
        this.entryMap.put(key, entry);
        return null;
    }

    public void remove(Object key) {
        TimedEntry entry = (TimedEntry)this.entryMap.remove(key);
        if (entry != null) {
            entry.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Map tmpMap;
        TimerCache timerCache = this;
        synchronized (timerCache) {
            tmpMap = this.entryMap;
            this.entryMap = this.threadSafe ? Collections.synchronizedMap(new HashMap()) : new HashMap();
        }
        for (TimedEntry entry : tmpMap.values()) {
            entry.destroy();
        }
        tmpMap.clear();
    }

    public int size() {
        return this.entryMap.size();
    }

    public Collection values() {
        return this.entryMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getValidKeys() {
        ArrayList validKeys = new ArrayList();
        Map map = this.entryMap;
        synchronized (map) {
            for (Map.Entry entry : this.entryMap.entrySet()) {
                TimedEntry value = (TimedEntry)entry.getValue();
                if (!value.isCurrent(this.now)) continue;
                validKeys.add(entry.getKey());
            }
        }
        return validKeys;
    }

    public void remove(String key) {
        this.entryMap.remove(key);
    }

    public boolean containsKey(String key) {
        return this.entryMap.containsKey(key);
    }

    public long getDefaultLifetime() {
        return this.defaultLifetime;
    }

    public synchronized void setDefaultLifetime(int defaultLifetime) {
        this.defaultLifetime = defaultLifetime;
    }

    public int getResolution() {
        return this.resolution;
    }

    public synchronized void setResolution(int resolution) {
        if (resolution <= 0) {
            resolution = 60;
        }
        if (resolution != this.resolution) {
            this.resolution = resolution;
            resolutionTimer.cancel();
            resolutionTimer.scheduleAtFixedRate((TimerTask)this, 0L, (long)(1000 * resolution));
        }
    }

    public void run() {
        this.now = System.currentTimeMillis();
    }

    public long currentTimeMillis() {
        return this.now;
    }

    public TimedEntry peekEntry(Object key) {
        return (TimedEntry)this.entryMap.get(key);
    }
}

