/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.spi;

import jeus.security.base.Domain;
import jeus.security.base.Event;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.spi.EventHandlingService;
import jeus.security.spi.SecurityInstaller;

public abstract class AuthenticationService
extends Service {
    public static final String AUTHENTICATION_FAILED_EVENT_TYPE = "security.authentication.failed";

    public static Subject authenticate(Subject subject) throws ServiceException, SecurityException {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return null;
        }
        if (SecurityInstaller.isSecurityOff()) {
            return null;
        }
        return AuthenticationService.authenticate(subject, false);
    }

    public static Subject authenticate(Subject subject, boolean trusted) throws ServiceException, SecurityException {
        AuthenticationService as = (AuthenticationService)Domain.getCurrentDomain().getOneService(AuthenticationService.class);
        try {
            return as.doAuthenticate(subject, trusted);
        }
        catch (SecurityException se) {
            SecurityException lastSE = se;
            if (lastSE != null) {
                Event ev = new Event(lastSE.getMessage(), AUTHENTICATION_FAILED_EVENT_TYPE, Event.WARNING, lastSE, AuthenticationService.class.getName());
                ev.put("subject", subject);
                EventHandlingService.handleEvent(ev);
                throw lastSE;
            }
            throw new ServiceException("Authentication failed: no AuthenticationService instances configured");
        }
    }

    protected abstract Subject doAuthenticate(Subject var1, boolean var2) throws ServiceException, SecurityException;

    public final Class getType() {
        return AuthenticationService.class;
    }
}

