/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.spi;

import java.security.Permission;
import jeus.security.base.Domain;
import jeus.security.base.Event;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.spi.EventHandlingService;

public abstract class AuthorizationService
extends Service {
    public static final String AUTHORIZATION_FAILED_EVENT_TYPE = "security.authorization.failed";

    public static void authorize(String contextId, Permission permission, Subject subject) throws ServiceException, SecurityException {
        AuthorizationService as = (AuthorizationService)Domain.getCurrentDomain().getOneService(AuthorizationService.class);
        try {
            as.doAuthorize(contextId, permission, subject);
            return;
        }
        catch (SecurityException se) {
            SecurityException lastSE = se;
            if (lastSE != null) {
                Event ev = new Event(lastSE.getMessage(), AUTHORIZATION_FAILED_EVENT_TYPE, Event.WARNING, lastSE, AuthorizationService.class.getName());
                ev.put("contextid", contextId);
                ev.put("permission", permission);
                ev.put("subject", subject);
                EventHandlingService.handleEvent(ev);
                throw lastSE;
            }
            return;
        }
    }

    protected abstract void doAuthorize(String var1, Permission var2, Subject var3) throws ServiceException, SecurityException;

    public final Class getType() {
        return AuthorizationService.class;
    }
}

