/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.spi;

import jeus.security.base.Domain;
import jeus.security.base.Event;
import jeus.security.base.Service;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.LoggerUtil;
import jeus.util.message.JeusMessage_Security;

public abstract class EventHandlingService
extends Service {
    public static void handleEvent(Event event) {
        block6: {
            if (!SecurityInstaller.isSecurityInstalled()) {
                return;
            }
            try {
                if (event == null) {
                    return;
                }
                if (event.getLevel().hasSamePriorityAs(Event.FATAL)) {
                    System.out.println(event);
                }
                for (EventHandlingService handler : Domain.getCurrentDomain().getZeroOrMoreServices(EventHandlingService.class)) {
                    if (!handler.doHandlesEvent(event)) continue;
                    handler.doHandleEvent(event);
                }
            }
            catch (Exception e) {
                if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._30_LEVEL)) break block6;
                LoggerUtil.logger.log(JeusMessage_Security._30_LEVEL, JeusMessage_Security._30, (Throwable)e);
            }
        }
    }

    protected abstract void doHandleEvent(Event var1);

    protected abstract boolean doHandlesEvent(Event var1);

    public final Class getType() {
        return EventHandlingService.class;
    }
}

