/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.spi;

import java.security.SecurityPermission;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.ObjectName;
import jeus.security.base.Domain;
import jeus.security.base.Environment;
import jeus.security.base.Event;
import jeus.security.base.SecurityException;
import jeus.security.base.Service;
import jeus.security.base.ServiceException;
import jeus.security.impl.network.ClientSocketNetworkService;
import jeus.security.spi.EventHandlingService;
import jeus.security.spi.LoginService;
import jeus.security.spi.NetworkService;
import jeus.security.util.Converter;
import jeus.security.util.LoggerUtil;
import jeus.util.JeusPort;
import jeus.util.message.JeusMessage_Security;

public abstract class SecurityInstaller
extends Service {
    private static SecurityInstaller installer;
    public static final String SECURITY_INSTALLED_EVENT_TYPE = "security.install.successful";
    public static final String SECURITY_UNINSTALL_ATTEMPT_EVENT_TYPE = "security.uninstall.attempt";
    public static final String SECURITY_DISABLE_SECURITY_EVENT_TYPE = "security.disable.authorization";
    public static final String SECURITY_INSTALLER_CLASS_PROPERTY_KEY = "jeus.security.installer.classname";
    public static final String JEUS_SECURITY_INSTALLER_CLASS = "jeus.security.impl.installer.JeusSecurityInstaller";
    public static final String JEUS_SECURITY_DOMAIN_INSTALLER_CLASS = "jeus.security.impl.installer.JeusSecurityDomainInstaller";
    public static final String JEUS_CLIENT_SECURITY_INSTALLER_CLASS = "jeus.security.impl.installer.JeusClientSecurityInstaller";
    public static final String GLOBAL_PASSWORD_PROPERTY_KEY = "jeus.security.globalPassword";
    private static final String DEFAULT_GLOBAL_PASSWORD = "globalpass";
    private static String globalPassword;
    private static Environment theEnvironment;
    private static boolean securityOff;
    private static Hashtable clienthosts;

    public static String getGlobalPassword() {
        return globalPassword;
    }

    private static void addRequiredDomain(String domainName, Environment env) {
        if (env.domains == null || env.domains.length == 0) {
            env.domains = new String[]{domainName};
        } else {
            boolean found = false;
            for (int i = 0; i < env.domains.length; ++i) {
                if (!env.domains[i].equals(domainName)) continue;
                found = true;
                break;
            }
            if (!found) {
                Vector v = Converter.toVector(env.domains);
                v.add(domainName);
                env.domains = v.toArray(new String[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void installSecurity(Environment env) throws ServiceException, SecurityException {
        int i;
        if (SecurityInstaller.isSecurityInstalled()) {
            if (env.client) {
                SecurityInstaller.addClientSecurity(env);
                return;
            }
            throw new ServiceException("Can not run the install method twice without calling uninstallSecurity in between");
        }
        env.startTime = -1L;
        theEnvironment = env;
        SecurityInstaller.addRequiredDomain("SYSTEM_DOMAIN", theEnvironment);
        SecurityInstaller.addRequiredDomain(Domain.DEFAULT_APPLICATION_DOMAIN_NAME, theEnvironment);
        String installerClassName = System.getProperty(SECURITY_INSTALLER_CLASS_PROPERTY_KEY);
        if (installerClassName == null) {
            if (env.client) {
                installerClassName = JEUS_CLIENT_SECURITY_INSTALLER_CLASS;
            } else {
                installerClassName = System.getProperty(SECURITY_INSTALLER_CLASS_PROPERTY_KEY);
                if (installerClassName == null) {
                    installerClassName = JEUS_SECURITY_DOMAIN_INSTALLER_CLASS;
                }
            }
        }
        try {
            installer = (SecurityInstaller)Class.forName(installerClassName).newInstance();
        }
        catch (Exception e) {
            throw new ServiceException("Failed load security installer", e);
        }
        installer.create();
        installer.doInstallSecurity(theEnvironment);
        SecurityInstaller.theEnvironment.startTime = System.currentTimeMillis();
        if (env.securitySwitch) {
            securityOff = false;
        }
        for (i = 0; i < SecurityInstaller.theEnvironment.remoteBaseSecurityPorts.length; ++i) {
            clienthosts.put(SecurityInstaller.theEnvironment.hostNames[i] + ":" + SecurityInstaller.theEnvironment.remoteBaseSecurityPorts[i], "true");
        }
        i = 0;
        while (true) {
            block17: {
                Object var5_6;
                if (i >= SecurityInstaller.theEnvironment.domains.length) {
                    return;
                }
                try {
                    try {
                        LoginService.loginCodeSubject(SecurityInstaller.theEnvironment.domains[i]);
                        Event ev = new Event("Security system successfully installed", SECURITY_INSTALLED_EVENT_TYPE, Event.INFORMATION, null, SecurityInstaller.class.getName());
                        EventHandlingService.handleEvent(ev);
                    }
                    catch (Exception e) {
                        if (LoggerUtil.logger.isLoggable(JeusMessage_Security._33_LEVEL)) {
                            LoggerUtil.logger.log(JeusMessage_Security._33_LEVEL, JeusMessage_Security._33, (Throwable)e);
                        }
                        var5_6 = null;
                        LoginService.logout();
                        break block17;
                    }
                    var5_6 = null;
                }
                catch (Throwable throwable) {
                    var5_6 = null;
                    LoginService.logout();
                    throw throwable;
                }
                LoginService.logout();
            }
            ++i;
        }
    }

    public static synchronized void setEnvironment(Environment env) {
        if (env == null || env.hostNames == null) {
            return;
        }
        if (env.remoteBaseSecurityPorts == null) {
            env.remoteBaseSecurityPorts = new int[]{JeusPort.JeusBase};
        }
        SecurityInstaller.theEnvironment.hostNames = env.hostNames;
        SecurityInstaller.theEnvironment.remoteBaseSecurityPorts = env.remoteBaseSecurityPorts;
        clienthosts.clear();
        for (int i = 0; i < SecurityInstaller.theEnvironment.remoteBaseSecurityPorts.length; ++i) {
            clienthosts.put(SecurityInstaller.theEnvironment.hostNames[i] + ":" + SecurityInstaller.theEnvironment.remoteBaseSecurityPorts[i], "true");
        }
        if (LoggerUtil.logger.isLoggable(JeusMessage_Security._78_LEVEL)) {
            LoggerUtil.logger.log(JeusMessage_Security._78_LEVEL, JeusMessage_Security._78);
        }
    }

    private static void addClientSecurity(Environment env) throws ServiceException, SecurityException {
        Service s;
        NetworkService ns;
        String host = env.hostNames[0] + ":" + env.remoteBaseSecurityPorts[0];
        boolean flag = false;
        if (!clienthosts.containsKey(host)) {
            clienthosts.put(host, "true");
            String[] hostNames = new String[SecurityInstaller.theEnvironment.hostNames.length + 1];
            int[] ports = new int[SecurityInstaller.theEnvironment.hostNames.length + 1];
            for (int i = 0; i < SecurityInstaller.theEnvironment.hostNames.length; ++i) {
                hostNames[i] = SecurityInstaller.theEnvironment.hostNames[i];
                ports[i] = env.remoteBaseSecurityPorts[i];
            }
            hostNames[SecurityInstaller.theEnvironment.hostNames.length] = env.hostNames[0];
            ports[SecurityInstaller.theEnvironment.hostNames.length] = env.remoteBaseSecurityPorts[0];
            SecurityInstaller.theEnvironment.hostNames = hostNames;
            SecurityInstaller.theEnvironment.remoteBaseSecurityPorts = ports;
            flag = true;
        }
        if ((ns = (NetworkService)(s = Domain.getCurrentDomain().getOneService(NetworkService.class))).isCreated()) {
            if (flag) {
                ((ClientSocketNetworkService)ns).addClientConnect(env.hostNames[0], env.remoteBaseSecurityPorts[0]);
            } else {
                ns.create(true);
            }
        }
        SecurityInstaller.theEnvironment.startTime = System.currentTimeMillis();
    }

    protected abstract void doInstallSecurity(Environment var1) throws ServiceException, SecurityException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static synchronized void uninstallSecurity() {
        if (!SecurityInstaller.isSecurityInstalled()) {
            return;
        }
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new SecurityPermission("uninstallSecurity"));
        }
        for (int i = 0; i < SecurityInstaller.theEnvironment.domains.length; ++i) {
            LoginService.loginCodeSubject(SecurityInstaller.theEnvironment.domains[i]);
            Event ev = new Event("Security system uninstall attempted", SECURITY_UNINSTALL_ATTEMPT_EVENT_TYPE, Event.INFORMATION, null, SecurityInstaller.class.getName());
            EventHandlingService.handleEvent(ev);
            Object var3_3 = null;
            try {
                LoginService.logout();
            }
            catch (Exception e2) {}
            continue;
            {
                catch (Exception e) {
                    if (LoggerUtil.logger.isLoggable(JeusMessage_Security._33_LEVEL)) {
                        LoggerUtil.logger.log(JeusMessage_Security._33_LEVEL, JeusMessage_Security._33, (Throwable)e);
                    }
                    var3_3 = null;
                    try {
                        LoginService.logout();
                    }
                    catch (Exception e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var3_3 = null;
                try {
                    LoginService.logout();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        installer.doUninstallSecurity();
        installer.destroy();
        installer.disableSecurity();
        installer = null;
        theEnvironment = null;
    }

    protected abstract void doUninstallSecurity();

    public static void disableSecurity() {
        securityOff = true;
    }

    public static synchronized void registerMBean(ObjectName parent) {
        installer.doRegisterMBean(parent);
    }

    public static boolean isSecurityInstalled() {
        return theEnvironment != null && SecurityInstaller.theEnvironment.startTime != -1L;
    }

    public static boolean isServerSecurityInstalled() {
        if (SecurityInstaller.isSecurityInstalled()) {
            return !SecurityInstaller.theEnvironment.client;
        }
        return false;
    }

    public static Environment getEnvironment() {
        return theEnvironment;
    }

    public final Class getType() {
        return SecurityInstaller.class;
    }

    public static String getDefaultDomainName() {
        if (theEnvironment == null) {
            return Domain.DEFAULT_APPLICATION_DOMAIN_NAME;
        }
        return SecurityInstaller.theEnvironment.defaultDomainName;
    }

    public abstract String addDomain(String var1);

    public abstract void removeDomain(String var1);

    public static boolean isSecurityOff() {
        return securityOff;
    }

    static {
        globalPassword = DEFAULT_GLOBAL_PASSWORD;
        theEnvironment = null;
        securityOff = true;
        clienthosts = new Hashtable();
        String s = System.getProperty(GLOBAL_PASSWORD_PROPERTY_KEY);
        if (s != null) {
            globalPassword = s;
        }
    }
}

