/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import jeus.security.base.DecryptionException;
import jeus.security.base.EncryptionException;
import jeus.security.util.Base64Coder;
import jeus.security.util.Constants;
import jeus.security.util.EncryptionInfo;
import jeus.security.util.JeusSecurityRandom;
import jeus.security.util.LoggerUtil;
import jeus.util.CUtility;
import jeus.util.EnvironmentCall;
import jeus.util.message.JeusMessage_Security;
import jeus.util.properties.JeusPropertyValues;
import jeus.util.properties.JeusSecurityProperties;

public class EncryptionUtil {
    private static Cipher defaultPbeCipher = null;
    private static Cipher tmaxPbeCipher;
    private static String secretKeyPath;
    private static String secretKeyDir;
    private static String secretKeyFileName;
    private static Map cipherTable;
    private static Map encryptionInfoTable;
    private static Map secretKeyFileObjectTable;
    private static Map messageDigestTable;
    private static JeusSecurityRandom jeusRandom;
    private static final int DEFAULT_SALT_KEY_LENGTH = 8;
    private static final byte[] SALT_FOR_SECRET_KEY;
    private static final int ITERATION_COUNT = 1000;
    private static boolean isCreated;
    private static String passwordForSecretKey;
    private static final String DEFAULT_KEY_ENCRYPTION_ALGORITHM = "PBEWithSHA1AndDESede";
    private static final String TMAXPROVIDER_KEY_ENCRYPTION_ALGORITHM = "PBEWithSHAAnd2-KeyTripleDES-CBC";
    private static final int TRY_COUNT = 2;
    public static final int ENCODED_PASS_MAGIC_NUMBER = 537395984;
    public static final int ENCODED_PASS_MAX_LENGTH = 512;
    private static boolean reWrite;

    public static void init(String dirOrPath) {
        EncryptionUtil.init(dirOrPath, null);
    }

    public static void init(String dirOrPath, Provider provider) {
        if (!isCreated) {
            File secretDir = new File(dirOrPath);
            String absolute = secretDir.getAbsolutePath();
            if (secretDir.isDirectory()) {
                secretKeyDir = absolute;
                secretKeyPath = absolute + File.separator + secretKeyFileName;
            } else {
                int index = absolute.lastIndexOf(File.separatorChar);
                secretKeyDir = absolute.substring(0, index);
                secretKeyPath = absolute;
            }
            if (provider != null) {
                Security.addProvider(provider);
            }
            EncryptionUtil.initSalt();
            EncryptionUtil.loadSecretKeyFile();
            isCreated = true;
        }
    }

    public static boolean isCreated() {
        return isCreated;
    }

    public static void setSecretKeyDir(String dir) {
        secretKeyDir = dir;
        secretKeyPath = dir + File.separator + secretKeyFileName;
    }

    public static String getSecretKeyPath() {
        return secretKeyPath;
    }

    public static void initSalt() {
        if (jeusRandom == null) {
            jeusRandom = new JeusSecurityRandom();
            byte[] seedBytes = EncryptionUtil.getRandomBytes(null, 8);
            jeusRandom.setSeed(seedBytes);
        }
    }

    private static byte[] getSalt() {
        if (jeusRandom != null) {
            return jeusRandom.nextBytes(new byte[8]);
        }
        throw new SecurityException("jeusRandom Number Generator is not initialized");
    }

    private static byte[] getRandomBytes(String algorithm, int keyLength) {
        SecureRandom secureRandom;
        if (algorithm == null) {
            secureRandom = new SecureRandom();
        } else {
            try {
                secureRandom = SecureRandom.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                secureRandom = new SecureRandom();
            }
        }
        try {
            secureRandom.setSeed(System.getProperty("java.version", "default").getBytes());
            secureRandom.setSeed(System.getProperty("java.vendor", "default").getBytes());
            secureRandom.setSeed(System.getProperty("os.name", "default").getBytes());
            secureRandom.setSeed(System.getProperty("os.version", "default").getBytes());
            secureRandom.setSeed(System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] abyte0 = new byte[keyLength];
        secureRandom.nextBytes(abyte0);
        return abyte0;
    }

    private static boolean isRawSecretKeyExist(EncryptionInfo info) {
        return info.getSecretKey() != null || info.getSecretKeyBytes() != null;
    }

    public static boolean isProtected() {
        Set set = secretKeyFileObjectTable.keySet();
        for (String algorithm : set) {
            EncryptionInfo encryptionInfo = (EncryptionInfo)secretKeyFileObjectTable.get(algorithm);
            if (EncryptionUtil.isRawSecretKeyExist(encryptionInfo)) continue;
            return true;
        }
        return false;
    }

    public static String getPasswordForSecretKey() {
        return passwordForSecretKey;
    }

    public static void initMasterPassword() {
        for (int i = 0; i <= 2; ++i) {
            System.out.print("Input Your Password For Key Encryption> ");
            String pass = CUtility.getPassword();
            System.out.println("");
            System.out.print("Repeat Your Password For Key Encryption> ");
            String confirm = CUtility.getPassword();
            System.out.println("");
            if (pass.equals(confirm) && pass != null && !pass.equals("")) {
                String passwd = new String(pass);
                try {
                    passwordForSecretKey = EncryptionUtil.encryptPassword("base64", passwd);
                    break;
                }
                catch (EncryptionException e) {
                    if (LoggerUtil.logger.isLoggable(JeusMessage_Security._60_LEVEL)) {
                        LoggerUtil.logger.log(JeusMessage_Security._60_LEVEL, JeusMessage_Security._60, (Throwable)e);
                    }
                    throw new SecurityException();
                }
            }
            if (i == 2) {
                throw new SecurityException();
            }
            System.out.println("Retry!");
        }
        EncryptionUtil.cacheEncryptionInfo();
        if (!encryptionInfoTable.isEmpty()) {
            EncryptionUtil.writeSecretKey(null);
        }
    }

    public static void inputMasterPassword(PrintStream out, PrintStream err) {
        for (int i = 0; i <= 2; ++i) {
            if (i != 0) {
                out.println("Retry!");
            }
            out.println("secret key file is encrypted. Enter the master password.");
            out.print("password> ");
            String password = CUtility.getPassword();
            out.println("");
            out.println("");
            if (!EncryptionUtil.masterPasswordValidation(password)) continue;
            try {
                passwordForSecretKey = EncryptionUtil.encryptPassword("base64", password);
            }
            catch (EncryptionException e) {
                throw new SecurityException(e);
            }
            return;
        }
        err.println("master password is incorrect");
        if (LoggerUtil.logger.isLoggable(JeusMessage_Security._53_LEVEL)) {
            LoggerUtil.logger.log(JeusMessage_Security._53_LEVEL, "[ERROR] master password is incorrect, can not use secret keys in {0}", new Object[]{secretKeyPath});
        }
        throw new RuntimeException("master password is incorrect");
    }

    public static void setMasterPassword(String password) {
        try {
            passwordForSecretKey = EncryptionUtil.encryptPassword("base64", password);
        }
        catch (EncryptionException e) {
            throw new SecurityException(e);
        }
    }

    private static EncryptionInfo convertFromEncryptedToPlainInfo(EncryptionInfo encryptionInfo, String password) {
        if (passwordForSecretKey == null) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._54_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._54_LEVEL, "[ERROR] master password is not initialized");
            }
            throw new SecurityException("Security Exception : key-encryption password is null");
        }
        SecretKey secretKey = null;
        try {
            secretKey = EncryptionUtil.keyDecryptionWithTripleDES(password.toCharArray(), encryptionInfo);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
        encryptionInfo = new EncryptionInfo(encryptionInfo.getCipherAlgorithm(), secretKey, encryptionInfo.getIps());
        return encryptionInfo;
    }

    private static EncryptionInfo convertFromPlainToEncryptedInfo(EncryptionInfo encryptionInfo, String password) throws EncryptionException {
        byte[] encryptedSecretKey;
        block7: {
            if (passwordForSecretKey == null) {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._54_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._54_LEVEL, "[ERROR] master password is not initialized");
                }
                throw new SecurityException("Security Exception : key-encryption password is null");
            }
            encryptedSecretKey = null;
            try {
                if (encryptionInfo.getSecretKey() != null) {
                    encryptedSecretKey = EncryptionUtil.keyEncryptionWithTripleDES(password.toCharArray(), encryptionInfo.getSecretKey());
                    break block7;
                }
                if (encryptionInfo.getSecretKeyBytes() != null) {
                    SecretKeySpec secretKey = new SecretKeySpec(encryptionInfo.getSecretKeyBytes(), encryptionInfo.getCipherAlgorithm());
                    encryptedSecretKey = EncryptionUtil.keyEncryptionWithTripleDES(password.toCharArray(), secretKey);
                    break block7;
                }
                throw new SecurityException("There is no secret key");
            }
            catch (EncryptionException e) {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._68_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._68_LEVEL, JeusMessage_Security._68, (Throwable)e);
                }
                throw e;
            }
        }
        return new EncryptionInfo(encryptionInfo.getCipherAlgorithm(), encryptedSecretKey, encryptionInfo.getIps());
    }

    private static byte[] keyEncryptionWithTripleDES(char[] passwdForKey, SecretKey key) throws EncryptionException {
        if (defaultPbeCipher == null) {
            try {
                defaultPbeCipher = Cipher.getInstance(DEFAULT_KEY_ENCRYPTION_ALGORITHM);
            }
            catch (Throwable e) {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._59_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._59_LEVEL, JeusMessage_Security._59, new Object[]{DEFAULT_KEY_ENCRYPTION_ALGORITHM}, e);
                }
                throw new EncryptionException(e);
            }
        }
        try {
            PBEParameterSpec param = new PBEParameterSpec(SALT_FOR_SECRET_KEY, 1000);
            PBEKeySpec pbeKeySpec = new PBEKeySpec(passwdForKey);
            byte[] encodedKey = null;
            byte[] keyBytes = key.getEncoded();
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DEFAULT_KEY_ENCRYPTION_ALGORITHM);
            SecretKey secretKey = keyFactory.generateSecret(pbeKeySpec);
            defaultPbeCipher.init(1, (Key)secretKey, param);
            encodedKey = defaultPbeCipher.doFinal(keyBytes);
            return encodedKey;
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    private static SecretKey keyDecryptionWithTripleDES(char[] passwdForKey, EncryptionInfo encryptionInfo) throws DecryptionException {
        PBEParameterSpec param = new PBEParameterSpec(SALT_FOR_SECRET_KEY, 1000);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(passwdForKey, SALT_FOR_SECRET_KEY, 1000);
        byte[] encryptedKey = encryptionInfo.getEncryptedSecretKey();
        byte[] keyBytes = null;
        try {
            if (defaultPbeCipher == null) {
                defaultPbeCipher = Cipher.getInstance(DEFAULT_KEY_ENCRYPTION_ALGORITHM);
            }
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DEFAULT_KEY_ENCRYPTION_ALGORITHM);
            SecretKey secretKey = keyFactory.generateSecret(pbeKeySpec);
            defaultPbeCipher.init(2, (Key)secretKey, param);
            keyBytes = defaultPbeCipher.doFinal(encryptedKey);
        }
        catch (Exception e) {
            try {
                if (tmaxPbeCipher == null) {
                    tmaxPbeCipher = Cipher.getInstance(TMAXPROVIDER_KEY_ENCRYPTION_ALGORITHM);
                }
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(TMAXPROVIDER_KEY_ENCRYPTION_ALGORITHM);
                SecretKey secretKey = keyFactory.generateSecret(pbeKeySpec);
                tmaxPbeCipher.init(2, (Key)secretKey, param);
                keyBytes = tmaxPbeCipher.doFinal(encryptedKey);
                reWrite = true;
            }
            catch (Exception ef) {
                throw new DecryptionException(e);
            }
        }
        SecretKeySpec plainKey = new SecretKeySpec(keyBytes, encryptionInfo.getCipherAlgorithm());
        return plainKey;
    }

    public static String encode(String algorithm, String plainPassword) throws EncryptionException {
        Cipher cipher = (Cipher)cipherTable.get(algorithm);
        if (cipher == null) {
            algorithm = algorithm.toUpperCase();
            try {
                cipher = Cipher.getInstance(algorithm + "/CBC/PKCS5Padding");
            }
            catch (GeneralSecurityException e) {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._59_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._59_LEVEL, JeusMessage_Security._59, String.valueOf(algorithm), (Throwable)e);
                }
                throw new EncryptionException("[ERROR] algorithm {0} is not supported");
            }
            cipherTable.put(algorithm, cipher);
        }
        String encodePassword = null;
        EncryptionInfo encryptionInfo = (EncryptionInfo)encryptionInfoTable.get(algorithm);
        if (encryptionInfo == null) {
            try {
                encryptionInfo = EncryptionUtil.readSecretKey(algorithm);
            }
            catch (EOFException e) {
                encryptionInfo = null;
            }
            catch (IOException e) {
                encryptionInfo = null;
            }
            catch (ClassNotFoundException e) {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._67_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._67_LEVEL, JeusMessage_Security._67, new Object[]{secretKeyPath}, (Throwable)e);
                }
                throw new SecurityException(e);
            }
            if (encryptionInfo == null) {
                KeyGenerator keygen;
                try {
                    keygen = KeyGenerator.getInstance(algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    if (LoggerUtil.logger.isLoggable(JeusMessage_Security._59_LEVEL)) {
                        LoggerUtil.logger.log(JeusMessage_Security._59_LEVEL, JeusMessage_Security._59, String.valueOf(algorithm), (Throwable)e);
                    }
                    throw new EncryptionException("[ERROR] algorithm {0} is not supported");
                }
                SecretKey secretKey = keygen.generateKey();
                encodePassword = EncryptionUtil.encode(secretKey, plainPassword, cipher);
                byte[] iv = cipher.getIV();
                IvParameterSpec ips = new IvParameterSpec(iv);
                encryptionInfo = new EncryptionInfo(algorithm, secretKey, ips.getIV());
                EncryptionUtil.writeSecretKey(encryptionInfo);
                encryptionInfoTable.put(algorithm, encryptionInfo);
            } else if (EncryptionUtil.isRawSecretKeyExist(encryptionInfo)) {
                encryptionInfoTable.put(algorithm, encryptionInfo);
            } else {
                try {
                    String password = EncryptionUtil.decryptPassword("base64", passwordForSecretKey);
                    encryptionInfo = EncryptionUtil.convertFromEncryptedToPlainInfo(encryptionInfo, password);
                }
                catch (DecryptionException e) {
                    throw new EncryptionException(e);
                }
                encryptionInfoTable.put(algorithm, encryptionInfo);
            }
        }
        if (encryptionInfo.getSecretKey() != null) {
            encodePassword = EncryptionUtil.encode(encryptionInfo.getSecretKey(), new IvParameterSpec(encryptionInfo.getIps()), plainPassword, cipher);
        } else if (encryptionInfo.getSecretKeyBytes() != null) {
            SecretKeySpec secretKey = new SecretKeySpec(encryptionInfo.getSecretKeyBytes(), encryptionInfo.getCipherAlgorithm());
            encodePassword = EncryptionUtil.encode(secretKey, new IvParameterSpec(encryptionInfo.getIps()), plainPassword, cipher);
        }
        return encodePassword;
    }

    public static String encodeForConverter(String algorithm, String plainPassword, String dir) throws EncryptionException {
        secretKeyDir = dir;
        secretKeyPath = dir + File.separator + secretKeyFileName;
        Cipher cipher = (Cipher)cipherTable.get(algorithm);
        if (cipher == null) {
            algorithm = algorithm.toUpperCase();
            try {
                cipher = Cipher.getInstance(algorithm + "/CBC/PKCS5Padding");
            }
            catch (GeneralSecurityException e) {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._59_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._59_LEVEL, JeusMessage_Security._59, String.valueOf(algorithm), (Throwable)e);
                }
                throw new EncryptionException("[ERROR] algorithm {0} is not supported");
            }
            cipherTable.put(algorithm, cipher);
        }
        EncryptionInfo encryptionInfo = (EncryptionInfo)encryptionInfoTable.get(algorithm);
        String encodePassword = null;
        if (encryptionInfo == null) {
            try {
                encryptionInfo = EncryptionUtil.readSecretKey(algorithm);
            }
            catch (IOException e) {
                encryptionInfo = null;
            }
            catch (ClassNotFoundException e) {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._67_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._67_LEVEL, JeusMessage_Security._67, new Object[]{secretKeyPath}, (Throwable)e);
                }
                throw new SecurityException(e);
            }
            if (encryptionInfo == null) {
                KeyGenerator keygen;
                try {
                    keygen = KeyGenerator.getInstance(algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new EncryptionException(e);
                }
                SecretKey secretKey = keygen.generateKey();
                encodePassword = EncryptionUtil.encode(secretKey, plainPassword, cipher);
                byte[] iv = cipher.getIV();
                IvParameterSpec ips = new IvParameterSpec(iv);
                encryptionInfo = new EncryptionInfo(algorithm, secretKey, ips.getIV());
                EncryptionUtil.writeSecretKey(encryptionInfo);
                encryptionInfoTable.put(algorithm, encryptionInfo);
            } else {
                if (EncryptionUtil.isRawSecretKeyExist(encryptionInfo)) {
                    encryptionInfoTable.put(algorithm, encryptionInfo);
                } else {
                    try {
                        String password = EncryptionUtil.decryptPassword("base64", passwordForSecretKey);
                        encryptionInfo = EncryptionUtil.convertFromEncryptedToPlainInfo(encryptionInfo, password);
                    }
                    catch (DecryptionException e) {
                        throw new EncryptionException(e);
                    }
                    encryptionInfoTable.put(algorithm, encryptionInfo);
                }
                if (encryptionInfo.getSecretKey() != null) {
                    encodePassword = EncryptionUtil.encode(encryptionInfo.getSecretKey(), new IvParameterSpec(encryptionInfo.getIps()), plainPassword, cipher);
                } else if (encryptionInfo.getSecretKeyBytes() != null) {
                    SecretKeySpec secretKey = new SecretKeySpec(encryptionInfo.getSecretKeyBytes(), encryptionInfo.getCipherAlgorithm());
                    encodePassword = EncryptionUtil.encode(secretKey, new IvParameterSpec(encryptionInfo.getIps()), plainPassword, cipher);
                }
            }
        } else {
            if (!new File(secretKeyPath).exists()) {
                EncryptionUtil.writeSecretKey(encryptionInfo);
            }
            encodePassword = EncryptionUtil.encode(encryptionInfo.getSecretKey(), new IvParameterSpec(encryptionInfo.getIps()), plainPassword, cipher);
        }
        return encodePassword;
    }

    public static String decode(String algorithm, String encodedPassword) throws DecryptionException {
        String password;
        EncryptionInfo encryptionInfo;
        Cipher cipher = (Cipher)cipherTable.get(algorithm);
        if (cipher == null) {
            algorithm = algorithm.toUpperCase();
            try {
                cipher = Cipher.getInstance(algorithm + "/CBC/PKCS5Padding");
            }
            catch (GeneralSecurityException e) {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._59_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._59_LEVEL, JeusMessage_Security._59, String.valueOf(algorithm), (Throwable)e);
                }
                throw new DecryptionException(e);
            }
            cipherTable.put(algorithm, cipher);
        }
        if ((encryptionInfo = (EncryptionInfo)encryptionInfoTable.get(algorithm)) == null) {
            try {
                encryptionInfo = EncryptionUtil.readSecretKey(algorithm);
            }
            catch (IOException e) {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._64_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._64_LEVEL, JeusMessage_Security._64, new Object[]{encodedPassword, algorithm, secretKeyPath}, (Throwable)e);
                }
                throw new DecryptionException(e);
            }
            catch (ClassNotFoundException e) {
                throw new DecryptionException(e);
            }
            if (encryptionInfo == null) {
                return encodedPassword;
            }
            if (EncryptionUtil.isRawSecretKeyExist(encryptionInfo)) {
                encryptionInfoTable.put(algorithm, encryptionInfo);
            } else {
                password = EncryptionUtil.decryptPassword("base64", passwordForSecretKey);
                encryptionInfo = EncryptionUtil.convertFromEncryptedToPlainInfo(encryptionInfo, password);
                encryptionInfoTable.put(algorithm, encryptionInfo);
            }
        }
        if (encryptionInfo.getSecretKey() != null) {
            return EncryptionUtil.decode(encryptionInfo.getSecretKey(), new IvParameterSpec(encryptionInfo.getIps()), encodedPassword, cipher);
        }
        if (encryptionInfo.getSecretKeyBytes() != null) {
            SecretKeySpec secretKey = new SecretKeySpec(encryptionInfo.getSecretKeyBytes(), encryptionInfo.getCipherAlgorithm());
            return EncryptionUtil.decode(secretKey, new IvParameterSpec(encryptionInfo.getIps()), encodedPassword, cipher);
        }
        password = EncryptionUtil.decryptPassword("base64", passwordForSecretKey);
        encryptionInfo = EncryptionUtil.convertFromEncryptedToPlainInfo(encryptionInfo, password);
        SecretKeySpec secretKey = new SecretKeySpec(encryptionInfo.getSecretKeyBytes(), encryptionInfo.getCipherAlgorithm());
        return EncryptionUtil.decode(secretKey, new IvParameterSpec(encryptionInfo.getIps()), encodedPassword, cipher);
    }

    public static String createPasswordHash(String algorithm, String password) throws EncryptionException {
        byte[] passBytes;
        MessageDigest msgDigest = (MessageDigest)messageDigestTable.get(algorithm);
        try {
            if (msgDigest == null) {
                msgDigest = MessageDigest.getInstance(algorithm);
            }
            passBytes = password.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._58_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._58_LEVEL, JeusMessage_Security._58, (Throwable)e);
            }
            throw new EncryptionException(e);
        }
        catch (NoSuchAlgorithmException e) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._59_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._59_LEVEL, JeusMessage_Security._59, String.valueOf(algorithm), (Throwable)e);
            }
            throw new EncryptionException(e);
        }
        byte[] hash = msgDigest.digest(passBytes);
        return Base64Coder.byteArrayToBase64(hash);
    }

    public static String encryptPassword(String algorithm, String password) throws EncryptionException {
        if (algorithm == null) {
            return password;
        }
        if (algorithm.equalsIgnoreCase("base64")) {
            return Base64Coder.encode(password);
        }
        if (algorithm.equalsIgnoreCase("SHA")) {
            return EncryptionUtil.createPasswordHash(algorithm, password);
        }
        return EncryptionUtil.encode(algorithm, password);
    }

    public static String encryptPasswordForConverter(String algorithm, String password, String dir) throws EncryptionException {
        if (algorithm == null) {
            return password;
        }
        if (algorithm.equalsIgnoreCase("base64")) {
            return Base64Coder.encode(password);
        }
        if (algorithm.equalsIgnoreCase("SHA")) {
            return EncryptionUtil.createPasswordHash(algorithm, password);
        }
        return EncryptionUtil.encodeForConverter(algorithm, password, dir);
    }

    public static String encryptPassword(String password) throws EncryptionException {
        String onlyPassword = password;
        String algorithm = null;
        if (password.startsWith("{")) {
            int endIdx = password.indexOf("}");
            try {
                algorithm = password.substring(1, endIdx);
                if (EncryptionUtil.checkAlgorithm(algorithm)) {
                    onlyPassword = password.substring(endIdx + 1);
                }
            }
            catch (StringIndexOutOfBoundsException se) {
                throw new EncryptionException(se.getMessage());
            }
        }
        return EncryptionUtil.encryptPassword(algorithm, onlyPassword);
    }

    public static boolean checkAlgorithm(String algorithm) {
        if (algorithm == null) {
            return false;
        }
        for (int i = 0; i < Constants.DEFAULT_SUPPORT_ALGORITHM_VALUES.length; ++i) {
            if (!Constants.DEFAULT_SUPPORT_ALGORITHM_VALUES[i].equalsIgnoreCase(algorithm)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String decryptPassword(String algorithm, String password) throws DecryptionException {
        block14: {
            block15: {
                block16: {
                    if (algorithm == null) {
                        return password;
                    }
                    if (algorithm.equalsIgnoreCase("base64")) {
                        return Base64Coder.decode(password);
                    }
                    if (algorithm.equalsIgnoreCase("SHA")) {
                        try {
                            return EncryptionUtil.createPasswordHash(algorithm, password);
                        }
                        catch (EncryptionException e) {
                            throw new DecryptionException(e);
                        }
                    }
                    if (EncryptionUtil.isCreated()) break block14;
                    String secretKeyFilePath = JeusSecurityProperties.SECRET_KEY_PATH;
                    if (secretKeyFilePath == null) {
                        if (LoggerUtil.logger.isLoggable(JeusMessage_Security._56_LEVEL)) {
                            LoggerUtil.logger.log(JeusMessage_Security._56_LEVEL, "[ERROR] can not decrypt password since secret key file path is not initialized");
                        }
                        throw new DecryptionException("[ERROR] can not decrypt password since secret key file path is not initialized");
                    }
                    EncryptionUtil.init(secretKeyFilePath);
                    if (!EncryptionUtil.isProtected()) break block15;
                    String masterPassword = JeusSecurityProperties.MASTER_PASSWORD;
                    if (masterPassword == null) break block16;
                    if (EncryptionUtil.masterPasswordValidation(masterPassword)) {
                        try {
                            passwordForSecretKey = EncryptionUtil.encryptPassword("base64", masterPassword);
                        }
                        catch (EncryptionException e) {
                            throw new SecurityException(e);
                        }
                        if (LoggerUtil.logger.isLoggable(JeusMessage_Security._65_LEVEL)) {
                            LoggerUtil.logger.log(JeusMessage_Security._65_LEVEL, JeusMessage_Security._65);
                        }
                        break block15;
                    } else {
                        isCreated = false;
                        if (LoggerUtil.logger.isLoggable(JeusMessage_Security._53_LEVEL)) {
                            LoggerUtil.logger.log(JeusMessage_Security._53_LEVEL, "[ERROR] master password is incorrect, can not use secret keys in {0}", new Object[]{secretKeyPath});
                        }
                        throw new DecryptionException("master password validation failed");
                    }
                }
                isCreated = false;
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._53_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._53_LEVEL, "[ERROR] master password is incorrect, can not use secret keys in {0}", new Object[]{secretKeyPath});
                }
                throw new DecryptionException("you must set master password");
            }
            EncryptionUtil.cacheEncryptionInfo();
        }
        return EncryptionUtil.decode(algorithm, password);
    }

    public static String decryptPasswordForClientContainer(String password) throws DecryptionException {
        if (!isCreated) {
            if (JeusSecurityProperties.SECRET_KEY_PATH == null) {
                EncryptionUtil.init(JeusPropertyValues.JEUS_CONFIG_HOME + JeusPropertyValues.fs + EnvironmentCall.getLocalVirutalName() + JeusPropertyValues.fs + "security");
            } else {
                EncryptionUtil.init(JeusSecurityProperties.SECRET_KEY_PATH);
            }
        }
        if (password == null) {
            return password;
        }
        String onlyPassword = password;
        String algorithm = null;
        if (password.startsWith("{")) {
            int endIdx = password.indexOf("}");
            try {
                algorithm = password.substring(1, endIdx);
                if (EncryptionUtil.checkAlgorithm(algorithm)) {
                    onlyPassword = password.substring(endIdx + 1);
                }
            }
            catch (StringIndexOutOfBoundsException se) {
                throw new DecryptionException(se);
            }
        }
        return EncryptionUtil.decryptPassword(algorithm, onlyPassword);
    }

    public static String decryptPassword(String password) throws DecryptionException {
        if (password == null) {
            return password;
        }
        String onlyPassword = password;
        String algorithm = null;
        if (password.startsWith("{")) {
            int endIdx = password.indexOf("}");
            try {
                algorithm = password.substring(1, endIdx);
                if (EncryptionUtil.checkAlgorithm(algorithm)) {
                    onlyPassword = password.substring(endIdx + 1);
                }
            }
            catch (StringIndexOutOfBoundsException se) {
                throw new DecryptionException(se.getMessage());
            }
        }
        return EncryptionUtil.decryptPassword(algorithm, onlyPassword);
    }

    private static String decode(SecretKey secretKey, IvParameterSpec dps, String encodedPassword, Cipher cipher) throws DecryptionException {
        byte[] decodedText;
        try {
            cipher.init(2, (Key)secretKey, dps);
            byte[] encodePassword = Base64Coder.base64ToByteArray(encodedPassword);
            decodedText = cipher.doFinal(encodePassword);
        }
        catch (Exception e) {
            throw new DecryptionException(e);
        }
        String decode = new String(decodedText);
        int seperator = decode.indexOf(":");
        if (seperator <= 0) {
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._69_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._69_LEVEL, JeusMessage_Security._69);
            }
            return decode;
        }
        return decode.substring(seperator + 1);
    }

    private static String encode(SecretKey secretKey, String password, Cipher cipher) throws EncryptionException {
        byte[] ciphertext = new byte[]{};
        try {
            cipher.init(1, secretKey);
            String salt = String.valueOf(EncryptionUtil.getSalt());
            ciphertext = cipher.doFinal((salt + ":" + password).getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
        return Base64Coder.byteArrayToBase64(ciphertext);
    }

    private static String encode(SecretKey secretKey, IvParameterSpec dps, String password, Cipher cipher) throws EncryptionException {
        byte[] ciphertext = new byte[]{};
        try {
            cipher.init(1, (Key)secretKey, dps);
            String salt = String.valueOf(EncryptionUtil.getSalt());
            ciphertext = cipher.doFinal((salt + ":" + password).getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
        return Base64Coder.byteArrayToBase64(ciphertext);
    }

    public static void cacheEncryptionInfo() {
        Set set = secretKeyFileObjectTable.keySet();
        for (String algorithm : set) {
            EncryptionInfo encryptionInfo = (EncryptionInfo)secretKeyFileObjectTable.get(algorithm);
            if (!EncryptionUtil.isRawSecretKeyExist(encryptionInfo)) {
                try {
                    String password = EncryptionUtil.decryptPassword("base64", passwordForSecretKey);
                    encryptionInfo = EncryptionUtil.convertFromEncryptedToPlainInfo(encryptionInfo, password);
                }
                catch (DecryptionException e) {
                    if (LoggerUtil.logger.isLoggable(JeusMessage_Security._61_LEVEL)) {
                        LoggerUtil.logger.log(JeusMessage_Security._61_LEVEL, JeusMessage_Security._61, (Throwable)e);
                    }
                    throw new SecurityException(e);
                }
            }
            if (encryptionInfo.getSecretKey() != null) {
                encryptionInfo.convertSecretKeyToByteArray();
                if (!reWrite) {
                    reWrite = true;
                }
            }
            encryptionInfoTable.put(algorithm, encryptionInfo);
        }
        if (reWrite) {
            EncryptionUtil.writeSecretKey(null);
        }
    }

    public static boolean masterPasswordValidation(String password) {
        Set set = secretKeyFileObjectTable.keySet();
        for (String algorithm : set) {
            EncryptionInfo encryptionInfo = (EncryptionInfo)secretKeyFileObjectTable.get(algorithm);
            if (EncryptionUtil.isRawSecretKeyExist(encryptionInfo)) continue;
            try {
                EncryptionUtil.keyDecryptionWithTripleDES(password.toCharArray(), encryptionInfo);
            }
            catch (DecryptionException e) {
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._63_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._63_LEVEL, JeusMessage_Security._63, new Object[]{e.getMessage()}, (Throwable)e);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static EncryptionInfo readSecretKey(String algorithm) throws IOException, ClassNotFoundException {
        EncryptionInfo encryptionInfo;
        block14: {
            Object v0;
            FileInputStream bIn = null;
            ObjectInputStream deser = null;
            encryptionInfo = null;
            bIn = new FileInputStream(new File(secretKeyPath));
            deser = new ObjectInputStream(bIn);
            while (!(encryptionInfo = (EncryptionInfo)deser.readObject()).getCipherAlgorithm().equalsIgnoreCase(algorithm)) {
            }
            Object var6_4 = null;
            try {
                if (deser != null) {
                    deser.close();
                    deser = null;
                }
                v0 = null;
            }
            catch (Throwable throwable) {
                Object var8_8;
                v0 = var8_8 = null;
            }
            if (bIn != null) {
                bIn.close();
                bIn = null;
            }
            break block14;
            {
                catch (IOException e) {
                    throw e;
                }
                catch (ClassNotFoundException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object v1;
                Object var6_5 = null;
                try {
                    if (deser != null) {
                        deser.close();
                        deser = null;
                    }
                    v1 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_9;
                    v1 = var8_9 = null;
                }
                if (bIn != null) {
                    bIn.close();
                    bIn = null;
                }
                throw throwable;
            }
        }
        return encryptionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSecretKeyFile() {
        ObjectInputStream deser = null;
        FileInputStream bIn = null;
        try {
            try {
                bIn = new FileInputStream(secretKeyPath);
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._57_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._57_LEVEL, "Loading secret keys from \"{0}\"", new Object[]{secretKeyPath});
                }
                deser = new ObjectInputStream(bIn);
                while (true) {
                    EncryptionInfo encryptionInfo = (EncryptionInfo)deser.readObject();
                    secretKeyFileObjectTable.put(encryptionInfo.getCipherAlgorithm(), encryptionInfo);
                }
            }
            catch (EOFException e) {
                IOException e2222222;
                Object var4_8 = null;
                if (deser != null) {
                    try {
                        deser.close();
                        deser = null;
                    }
                    catch (IOException e2222222) {
                        // empty catch block
                    }
                }
                if (bIn != null) {
                    try {
                        bIn.close();
                        bIn = null;
                    }
                    catch (IOException e2222222) {}
                }
            }
            catch (FileNotFoundException e) {
                IOException e2222222;
                Object var4_9 = null;
                if (deser != null) {
                    try {
                        deser.close();
                        deser = null;
                    }
                    catch (IOException e2222222) {
                        // empty catch block
                    }
                }
                if (bIn != null) {
                    try {
                        bIn.close();
                        bIn = null;
                    }
                    catch (IOException e2222222) {}
                }
            }
            catch (ClassCastException e) {
                IOException e2222222;
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._67_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._67_LEVEL, JeusMessage_Security._67, new Object[]{secretKeyPath}, (Throwable)e);
                }
                Object var4_10 = null;
                if (deser != null) {
                    try {
                        deser.close();
                        deser = null;
                    }
                    catch (IOException e2222222) {
                        // empty catch block
                    }
                }
                if (bIn != null) {
                    try {
                        bIn.close();
                        bIn = null;
                    }
                    catch (IOException e2222222) {}
                }
            }
            catch (ClassNotFoundException e) {
                IOException e2222222;
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._67_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._67_LEVEL, JeusMessage_Security._67, new Object[]{secretKeyPath}, (Throwable)e);
                }
                Object var4_11 = null;
                if (deser != null) {
                    try {
                        deser.close();
                        deser = null;
                    }
                    catch (IOException e2222222) {
                        // empty catch block
                    }
                }
                if (bIn != null) {
                    try {
                        bIn.close();
                        bIn = null;
                    }
                    catch (IOException e2222222) {}
                }
            }
            catch (IOException iOException) {
                IOException e2222222;
                Object var4_12 = null;
                if (deser != null) {
                    try {
                        deser.close();
                        deser = null;
                    }
                    catch (IOException e2222222) {
                        // empty catch block
                    }
                }
                if (bIn != null) {
                    try {
                        bIn.close();
                        bIn = null;
                    }
                    catch (IOException e2222222) {}
                }
            }
        }
        catch (Throwable throwable) {
            IOException e2222222;
            Object var4_13 = null;
            if (deser != null) {
                try {
                    deser.close();
                    deser = null;
                }
                catch (IOException e2222222) {
                    // empty catch block
                }
            }
            if (bIn != null) {
                try {
                    bIn.close();
                    bIn = null;
                }
                catch (IOException e2222222) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    private static synchronized void writeSecretKey(EncryptionInfo encryptionInfo) {
        block22: {
            IOException ie22;
            ObjectOutputStream ser;
            FileOutputStream bOut;
            block21: {
                block20: {
                    bOut = null;
                    ser = null;
                    File secretDir = new File(secretKeyDir);
                    if (!secretDir.isDirectory()) {
                        secretDir.mkdirs();
                    }
                    bOut = new FileOutputStream(new File(secretKeyPath));
                    ser = new ObjectOutputStream(bOut);
                    for (EncryptionInfo info : encryptionInfoTable.values()) {
                        if (passwordForSecretKey != null) {
                            String password = EncryptionUtil.decryptPassword("base64", passwordForSecretKey);
                            info = EncryptionUtil.convertFromPlainToEncryptedInfo(info, password);
                        } else if (info.getSecretKey() != null) {
                            info.convertSecretKeyToByteArray();
                        }
                        ser.writeObject(info);
                    }
                    if (encryptionInfo == null) break block20;
                    if (passwordForSecretKey != null) {
                        String password = EncryptionUtil.decryptPassword("base64", passwordForSecretKey);
                        encryptionInfo = EncryptionUtil.convertFromPlainToEncryptedInfo(encryptionInfo, password);
                    }
                    if (encryptionInfo.getSecretKey() != null) {
                        encryptionInfo.convertSecretKeyToByteArray();
                    }
                    ser.writeObject(encryptionInfo);
                }
                Object var8_8 = null;
                if (ser == null) break block21;
                try {
                    ser.close();
                    ser = null;
                }
                catch (IOException ie22) {
                    // empty catch block
                }
            }
            if (bOut != null) {
                try {
                    bOut.close();
                    bOut = null;
                }
                catch (IOException ie22) {}
            }
            break block22;
            {
                catch (Exception e) {
                    throw new SecurityException(e);
                }
            }
            catch (Throwable throwable) {
                IOException ie22;
                Object var8_9 = null;
                if (ser != null) {
                    try {
                        ser.close();
                        ser = null;
                    }
                    catch (IOException ie22) {
                        // empty catch block
                    }
                }
                if (bOut != null) {
                    try {
                        bOut.close();
                        bOut = null;
                    }
                    catch (IOException ie22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    static {
        secretKeyFileName = "security.key";
        cipherTable = new HashMap();
        encryptionInfoTable = new HashMap();
        secretKeyFileObjectTable = new HashMap();
        messageDigestTable = new HashMap();
        SALT_FOR_SECRET_KEY = new byte[]{-35, -49, 95, -63, 44, 0, 121, -1};
        isCreated = false;
        passwordForSecretKey = null;
        reWrite = false;
    }
}

