/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.lang.reflect.InvocationTargetException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import jeus.security.util.Arrays;
import jeus.security.util.LoggerUtil;
import jeus.security.util.ReflectionUtil;
import jeus.util.message.JeusMessage_Security;

public class GenericMBean
implements DynamicMBean {
    private Object resource;
    private MBeanInfo info;

    public GenericMBean(Object resource, MBeanInfo info) {
        this.resource = resource;
        this.info = info;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        MBeanAttributeInfo[] attrs = this.info.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            if (!attrs[i].getName().equals(attribute)) continue;
            try {
                if (attrs[i].isIs()) {
                    return ReflectionUtil.invokeMethod(this.resource, "is" + attribute);
                }
                return ReflectionUtil.invokeMethod(this.resource, "get" + attribute);
            }
            catch (IllegalAccessException iae) {
                throw new ReflectionException(iae);
            }
            catch (NoSuchMethodException nsme) {
                throw new ReflectionException(nsme);
            }
            catch (InvocationTargetException ite) {
                throw new MBeanException(ite);
            }
        }
        throw new AttributeNotFoundException("Getter for attribute " + attribute + " does not exist");
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                Object o = this.getAttribute(attributes[i]);
                list.add(o);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return list;
    }

    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        int i;
        MBeanOperationInfo[] ops = this.info.getOperations();
        Class[] clSig = null;
        if (signature == null) {
            clSig = new Class[]{};
        } else {
            clSig = new Class[signature.length];
            for (i = 0; i < signature.length; ++i) {
                try {
                    clSig[i] = this.getClass(signature[i]);
                    continue;
                }
                catch (Exception e) {
                    throw new ReflectionException(e);
                }
            }
        }
        for (i = 0; i < ops.length; ++i) {
            if (!ops[i].getName().equals(actionName) || !this.signatureMatches(ops[i].getSignature(), signature)) continue;
            try {
                return ReflectionUtil.invokeMethod(this.resource, actionName, params, clSig);
            }
            catch (IllegalAccessException iae) {
                throw new ReflectionException(iae);
            }
            catch (NoSuchMethodException nsme) {
                throw new ReflectionException(nsme);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getCause();
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._38_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._38_LEVEL, JeusMessage_Security._38, t);
                }
                throw new MBeanException(ite);
            }
        }
        throw new ReflectionException(new Exception("The method " + actionName + " does not exist for the given signature"));
    }

    private boolean signatureMatches(MBeanParameterInfo[] infos, String[] classes) {
        if (infos == null) {
            return classes == null || classes.length == 0;
        }
        if (classes == null) {
            return infos == null || infos.length == 0;
        }
        if (classes.length != infos.length) {
            return false;
        }
        for (int i = 0; i < infos.length; ++i) {
            if (infos[i].getType().equals(classes[i])) continue;
            return false;
        }
        return true;
    }

    public void setAttribute(Attribute attribute) throws InvalidAttributeValueException, AttributeNotFoundException, MBeanException, ReflectionException {
        MBeanAttributeInfo[] attrs = this.info.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            if (!attrs[i].getName().equals(attribute.getName())) continue;
            try {
                Object o = attribute.getValue();
                if (!this.checkType(o.getClass(), attrs[i].getType())) {
                    throw new InvalidAttributeValueException("The argument object of type " + o.getClass().getName() + " is not compatible with the attribute's type " + attrs[i].getType());
                }
                ReflectionUtil.invokeMethod(this.resource, "set" + attribute.getName(), new Object[]{o}, new Class[]{this.getClass(attrs[i].getType())});
                return;
            }
            catch (IllegalAccessException iae) {
                throw new ReflectionException(iae);
            }
            catch (NoSuchMethodException nsme) {
                throw new ReflectionException(nsme);
            }
            catch (InvocationTargetException ite) {
                throw new MBeanException(ite);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ReflectionException(cnfe);
            }
        }
        throw new AttributeNotFoundException("Setter for attribute " + attribute.getName() + " does not exist");
    }

    private boolean checkType(Class passedIn, String allowed) {
        if (passedIn.getName().equals(allowed)) {
            return true;
        }
        if (passedIn == Integer.class && allowed.equals(Integer.TYPE.getName())) {
            return true;
        }
        if (passedIn == Float.class && allowed.equals(Float.TYPE.getName())) {
            return true;
        }
        if (passedIn == Double.class && allowed.equals(Double.TYPE.getName())) {
            return true;
        }
        if (passedIn == Character.class && allowed.equals(Character.TYPE.getName())) {
            return true;
        }
        if (passedIn == Boolean.class && allowed.equals(Boolean.TYPE.getName())) {
            return true;
        }
        if (passedIn == Short.class && allowed.equals(Short.TYPE.getName())) {
            return true;
        }
        if (passedIn == Long.class && allowed.equals(Long.TYPE.getName())) {
            return true;
        }
        return passedIn == Byte.class && allowed.equals(Byte.TYPE.getName());
    }

    private Class getClass(String type) throws ClassNotFoundException {
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (type.equals("int")) {
                return Integer.TYPE;
            }
            if (type.equals("float")) {
                return Float.TYPE;
            }
            if (type.equals("long")) {
                return Long.TYPE;
            }
            if (type.equals("double")) {
                return Double.TYPE;
            }
            if (type.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (type.equals("char")) {
                return Character.TYPE;
            }
            if (type.equals("byte")) {
                return Byte.TYPE;
            }
            if (type.equals("short")) {
                return Short.TYPE;
            }
            throw new ClassNotFoundException("Could not find class " + type);
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        if (attributes != null) {
            for (int i = 0; i < attributes.size(); ++i) {
                Attribute att = (Attribute)attributes.get(i);
                try {
                    this.setAttribute(att);
                    list.add(att);
                    continue;
                }
                catch (Exception e) {
                    if (!LoggerUtil.logger.isLoggable(JeusMessage_Security._35_LEVEL)) continue;
                    LoggerUtil.logger.log(JeusMessage_Security._35_LEVEL, JeusMessage_Security._35, (Throwable)e);
                }
            }
        }
        return list;
    }

    public static MBeanInfo mergeMBeanInfos(MBeanInfo primary, MBeanInfo secondary) {
        Object[] atts1 = primary.getAttributes();
        Object[] ops1 = primary.getOperations();
        Object[] cons1 = primary.getConstructors();
        Object[] nots1 = primary.getNotifications();
        String description = primary.getDescription();
        String className = primary.getClassName();
        Object[] atts2 = secondary.getAttributes();
        Object[] ops2 = secondary.getOperations();
        Object[] cons2 = secondary.getConstructors();
        Object[] nots2 = secondary.getNotifications();
        MBeanAttributeInfo[] mAtts = (MBeanAttributeInfo[])Arrays.mergeArrays(atts1, atts2, new MBeanAttributeInfo[atts1.length + atts2.length]);
        MBeanOperationInfo[] mOps = (MBeanOperationInfo[])Arrays.mergeArrays(ops1, ops2, new MBeanOperationInfo[ops1.length + ops2.length]);
        MBeanConstructorInfo[] mCons = (MBeanConstructorInfo[])Arrays.mergeArrays(cons1, cons2, new MBeanConstructorInfo[cons1.length + cons2.length]);
        MBeanNotificationInfo[] mNots = (MBeanNotificationInfo[])Arrays.mergeArrays(nots1, nots2, new MBeanNotificationInfo[nots1.length + nots2.length]);
        return new MBeanInfo(description, className, mAtts, mCons, mOps, mNots);
    }
}

