/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.security.Permission;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import jeus.security.base.Domain;
import jeus.security.base.PermissionMap;
import jeus.security.base.Policy;
import jeus.security.base.ServiceException;
import jeus.security.spi.PolicyNotExistsException;
import jeus.security.util.LoggerUtil;
import jeus.util.message.JeusMessage_Security;

public class PolicyContainer {
    private Hashtable policyTable = new Hashtable();

    public boolean isEmpty() {
        return this.policyTable.isEmpty();
    }

    public Policy getPolicy(String contextId) throws PolicyNotExistsException, ServiceException {
        if (contextId == null) {
            throw new PolicyNotExistsException("Failed getting Policy: context id is null");
        }
        Policy p = (Policy)this.policyTable.get(contextId);
        if (p == null) {
            Enumeration enu = this.policyTable.keys();
            String domain = Domain.getCurrentDomain().getName();
            if (LoggerUtil.logger.isLoggable(JeusMessage_Security._39_LEVEL)) {
                LoggerUtil.logger.log(JeusMessage_Security._39_LEVEL, JeusMessage_Security._39, (Object[])new String[]{domain, enu.toString()});
            }
            throw new PolicyNotExistsException("Failed getting policy: the Policy does not exist : " + domain + "/" + contextId);
        }
        return p;
    }

    public Set getContextIds() {
        HashSet result = new HashSet();
        result.addAll(this.policyTable.keySet());
        return result;
    }

    public void clearPolicies() {
        this.policyTable.clear();
    }

    public synchronized void addPolicy(Policy policy) throws ServiceException {
        if (policy == null) {
            throw new ServiceException("Failed adding Policy: Policy to add is null");
        }
        Policy p = this.getPolicyFromTable(policy);
        if (p == null) {
            this.addPolicyToTable(policy);
        } else {
            p.add(policy);
            this.addPolicyToTable(p);
        }
    }

    public synchronized void removePolicy(Policy policy) throws PolicyNotExistsException, ServiceException {
        if (policy == null) {
            throw new ServiceException("Failed removing Policy: Policy to remove is null");
        }
        Policy p = this.getPolicyFromTable(policy);
        if (p == null) {
            throw new PolicyNotExistsException("Failed removing Policy: Policy to remove does not exist");
        }
        p.remove(policy);
        this.removePolicyFromTable(p);
        this.addPolicyToTable(p);
    }

    public synchronized void removePolicy(String contextId) throws PolicyNotExistsException, ServiceException {
        if (contextId == null) {
            throw new ServiceException("Failed removing Policy: context id is null");
        }
        Policy p = (Policy)this.policyTable.get(contextId);
        if (p == null) {
            throw new PolicyNotExistsException("Failed removing Policy: Policy for context id " + contextId + " does not exist");
        }
        this.policyTable.remove(contextId);
    }

    public Policy[] getPoliciesAsArray() {
        return this.policyTable.values().toArray(new Policy[0]);
    }

    public void addPoliciesFromArray(Policy[] policies) throws ServiceException {
        for (int i = 0; i < policies.length; ++i) {
            this.addPolicy(policies[i]);
        }
    }

    private Policy getPolicyFromTable(Policy policy) {
        for (String id : policy.getResourcePolicyIds()) {
            Policy p = (Policy)this.policyTable.get(id);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    private void addPolicyToTable(Policy policy) {
        for (String id : policy.getResourcePolicyIds()) {
            this.policyTable.put(id, policy);
        }
    }

    private void removePolicyFromTable(Policy policy) {
        for (String id : policy.getResourcePolicyIds()) {
            this.policyTable.remove(id);
        }
    }

    public static boolean authorize(String contextId, Policy policy, Permission permission, Principal[] principals) {
        return PolicyContainer.authorize(contextId, policy, permission, principals, null, null);
    }

    public static boolean authorize(String contextId, Policy policy, Permission permission, Principal[] principals, java.security.Policy delegatePolicy, ProtectionDomain pdDomain) {
        if (policy == null && delegatePolicy == null) {
            return false;
        }
        if (policy != null) {
            if (principals != null) {
                PermissionMap.CheckResult result = policy.checkPermission(contextId, principals, permission);
                if (result == PermissionMap.EXCLUDED) {
                    return false;
                }
                if (result.isGranted()) {
                    return true;
                }
                if (result == PermissionMap.UNCHECKED) {
                    return true;
                }
            } else {
                PermissionMap.CheckResult result = policy.checkPermission(contextId, permission);
                if (result == PermissionMap.EXCLUDED) {
                    return false;
                }
                if (result.isGranted()) {
                    return true;
                }
                if (result == PermissionMap.UNCHECKED) {
                    return true;
                }
            }
        }
        if (delegatePolicy != null) {
            return delegatePolicy.implies(pdDomain, permission);
        }
        return false;
    }
}

