/*
 * Decompiled with CFR 0.152.
 */
package jeus.security.util;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jeus.security.base.Domain;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.resource.DefaultCache;
import jeus.security.resource.GroupPrincipalImpl;
import jeus.security.resource.LRUCache;
import jeus.security.resource.SecurityCache;
import jeus.security.spi.GroupNotExistsException;
import jeus.security.spi.SubjectNotExistsException;

public class SubjectManager {
    private SecurityCache userCache;
    private SecurityCache groupCache;

    public SubjectManager(int min, int max, long timeout) {
        if (timeout == -1L) {
            this.userCache = new LRUCache(min, max, true);
            this.groupCache = new LRUCache(min, max, true);
        } else {
            this.userCache = new DefaultCache(min, max, timeout);
            this.userCache.create();
            this.userCache.start();
            this.groupCache = new DefaultCache(min, max, timeout);
            this.groupCache.create();
            this.groupCache.start();
        }
    }

    public void stop() {
        this.userCache.stop();
        this.groupCache.stop();
    }

    public void clear() {
        this.userCache.destroy();
        this.groupCache.destroy();
    }

    public boolean isSubjectEmpty() {
        return this.userCache.size() <= 0;
    }

    public boolean isGroupsEmpty() {
        return this.groupCache.size() <= 0;
    }

    public synchronized void addSubject(Subject subject) throws ServiceException {
        Subject localSubject;
        if (subject == null) {
            throw new ServiceException("Failed to add Subject data: Subject is null");
        }
        if (subject.getPrincipal() == null) {
            throw new ServiceException("Failed to add Subject data: Subject Principal is null");
        }
        String name = subject.getPrincipal().getName();
        Object o = this.userCache.get(name);
        if (o == null) {
            localSubject = (Subject)subject.clone();
        } else {
            localSubject = (Subject)o;
            localSubject.add(subject);
        }
        this.userCache.put(name, localSubject);
    }

    public synchronized void removeSubject(Subject subject) throws SubjectNotExistsException, ServiceException {
        if (subject == null) {
            throw new ServiceException("Failed to remove Subject data: Subject is null");
        }
        if (subject.getPrincipal() == null) {
            throw new ServiceException("Failed to remove Subject data: Subject Principal is null");
        }
        String name = subject.getPrincipal().getName();
        Object o = this.userCache.get(name);
        if (o == null) {
            throw new SubjectNotExistsException("Could not remove Subject data: the Subject does not exist");
        }
        Subject localSubject = (Subject)o;
        localSubject.remove(subject);
        if (localSubject.isEmpty()) {
            this.userCache.remove(name);
        }
    }

    public synchronized void removeSubject(String name) throws SubjectNotExistsException, ServiceException {
        if (name == null) {
            throw new ServiceException("Failed to remove Subject: Subject name is null");
        }
        Object o = this.userCache.get(name);
        if (o == null) {
            throw new SubjectNotExistsException("Could not remove Subject: the Subject named " + name + " does not exist");
        }
        this.userCache.remove(name);
    }

    public Subject getSubject(String name) throws SubjectNotExistsException, ServiceException {
        if (name == null) {
            throw new ServiceException("Failed to get Subject data: name is null");
        }
        Object o = this.userCache.get(name);
        if (o == null) {
            throw new SubjectNotExistsException("Could not get Subject data: the Subject " + name + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        Subject localSubject = (Subject)o;
        return (Subject)localSubject.clone();
    }

    public Subject[] getSubjectsAsArray() {
        return this.userCache.values().toArray(new Subject[0]);
    }

    public void addSubjectsFromArray(Subject[] subjects) throws ServiceException {
        for (int i = 0; i < subjects.length; ++i) {
            this.addSubject(subjects[i]);
        }
    }

    public Set getSubjectNames() {
        HashSet result = new HashSet();
        result.addAll(this.userCache.getValidKeys());
        return result;
    }

    public boolean userExists(String userName) {
        return this.userCache.containsKey(userName);
    }

    public boolean groupExist(String groupName) {
        return this.groupCache.containsKey(groupName);
    }

    public synchronized void addGroup(Group group) throws ServiceException {
        Object o = this.groupCache.get(group.getName());
        if (o != null) {
            throw new ServiceException("Failed to add Group: Group name is duplicated");
        }
        this.groupCache.put(group.getName(), group);
    }

    public synchronized void addUserToGroup(String groupName, Principal principal) throws GroupNotExistsException, ServiceException {
        if (groupName == null) {
            throw new ServiceException("Failed to get Group data: name is null");
        }
        Object obj = this.groupCache.get(groupName);
        if (obj == null) {
            throw new GroupNotExistsException("Could not get Group data: the Group " + groupName + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        Object sobj = this.userCache.get(principal.getName());
        if (sobj == null) {
            throw new SubjectNotExistsException("Could not get Subject data: the Subject " + principal.getName() + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        GroupPrincipalImpl group = (GroupPrincipalImpl)obj;
        if (!group.addMember(principal)) {
            throw new ServiceException("Failed to add Group: Principal name is duplicated");
        }
        Subject sub = (Subject)sobj;
        sub.getPrincipals().add(group);
        this.addSubject(sub);
        this.groupCache.put(groupName, group);
    }

    public Group getGroup(String groupName) throws GroupNotExistsException, ServiceException {
        if (groupName == null) {
            throw new ServiceException("Failed to get Group data: name is null");
        }
        Object obj = this.groupCache.get(groupName);
        if (obj == null) {
            throw new GroupNotExistsException("Could not get Group data: the Group " + groupName + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        return (GroupPrincipalImpl)obj;
    }

    public Set getGroupNames() {
        HashSet result = new HashSet();
        result.addAll(this.groupCache.getValidKeys());
        return result;
    }

    public GroupPrincipalImpl[] getGroupList() {
        return this.groupCache.values().toArray(new GroupPrincipalImpl[0]);
    }

    public synchronized void removeGroup(String groupName) throws GroupNotExistsException, ServiceException {
        if (groupName == null) {
            throw new ServiceException("Failed to get Group data: name is null");
        }
        Object obj = this.groupCache.get(groupName);
        if (obj == null) {
            throw new GroupNotExistsException("Could not get Group data: the Group " + groupName + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        for (Subject subject : this.userCache.values()) {
            subject.removePrincipal((GroupPrincipalImpl)obj);
        }
        this.groupCache.remove(groupName);
    }

    public synchronized void removeUserToGroup(String groupName, Principal principal) throws GroupNotExistsException, ServiceException {
        if (groupName == null) {
            throw new ServiceException("Failed to get Group data: name is null");
        }
        Object obj = this.groupCache.get(groupName);
        if (obj == null) {
            throw new GroupNotExistsException("Could not get Group data: the Group " + groupName + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        Object sobj = this.userCache.get(principal.getName());
        if (sobj == null) {
            throw new SubjectNotExistsException("Could not get Subject data: the Subject " + principal.getName() + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        GroupPrincipalImpl group = (GroupPrincipalImpl)obj;
        if (group.removeMember(principal)) {
            Subject sub = (Subject)sobj;
            sub.removePrincipal(group);
            this.groupCache.put(groupName, group);
        }
    }

    public String getGroupDescriptor(String groupName) throws GroupNotExistsException, ServiceException {
        if (groupName == null) {
            throw new ServiceException("Failed to get Group data: name is null");
        }
        Object obj = this.groupCache.get(groupName);
        if (obj == null) {
            throw new GroupNotExistsException("Could not get Group data: the Group " + groupName + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        GroupPrincipalImpl group = (GroupPrincipalImpl)obj;
        return group.getDescription();
    }

    public boolean isMember(String groupName, Principal principal) throws GroupNotExistsException, ServiceException {
        if (groupName == null) {
            throw new ServiceException("Failed to get Group data: name is null");
        }
        Object obj = this.groupCache.get(groupName);
        if (obj == null) {
            throw new GroupNotExistsException("Could not get Group data: the Group " + groupName + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        GroupPrincipalImpl group = (GroupPrincipalImpl)obj;
        return group.isMember(principal);
    }

    public synchronized Enumeration getMembersFromGroup(String groupName) throws GroupNotExistsException, ServiceException {
        if (groupName == null) {
            throw new ServiceException("Failed to get Group data: name is null");
        }
        Object obj = this.groupCache.get(groupName);
        if (obj == null) {
            throw new GroupNotExistsException("Could not get Group data: the Group " + groupName + " does not exist, domain is " + Domain.getCurrentDomain().getName());
        }
        GroupPrincipalImpl group = (GroupPrincipalImpl)obj;
        return group.members();
    }

    public void setGroupTable(Map table) {
        for (String groupname : table.keySet()) {
            this.groupCache.put(groupname, table.get(groupname));
        }
    }
}

