/*
 * Decompiled with CFR 0.152.
 */
package jeus.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Vector;
import jeus.security.spi.LoginService;
import jeus.server.BootFailureException;
import jeus.server.ConfigFile;
import jeus.server.JeusServerException;
import jeus.server.util.ServerUtil;
import jeus.util.JarExtractor;
import jeus.util.JeusPort;
import jeus.util.JeusRuntimeException;
import jeus.util.StringUtil;
import jeus.util.VirtualDNS;
import jeus.util.cnet.SocketProxy;
import jeus.util.file.FileUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.message.JeusMessage_Manager1;
import jeus.util.properties.JeusManagerProperties;
import jeus.util.properties.JeusNetPropertyValues;

public class NodeControllerStub {
    private static final String fs = System.getProperty("file.separator");
    private static final char fsc = fs.charAt(0);
    private static final int connectionto = 15000;
    private static final long READ_TIMEOUT = JeusManagerProperties.DOWN_TIMEOUT_PER_CONTAINER * 2L;
    private static final int ftpTO = 60000;
    private static final int bufferSize = 33792;
    private static final int magicNum = 973630;
    private static final int ftpChunkSize = 32768;
    private Socket socket;
    private DataInputStream input;
    private DataOutputStream output;
    private byte[] fileBuffer = null;
    private File ftpFile;
    private FileOutputStream destination;
    public static final int OP_REGISTER_RA = 31;
    public static final int OP_START_RA = 33;
    public static final int OP_STOP_RA = 34;
    static final int OP_DEPLOY_EAR = 35;
    private byte[] serializedSubject;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.nodecontroller");
    private boolean local = false;
    public static final String NODE_CONTROLLER_ID = "NodeController";

    public NodeControllerStub() {
    }

    public NodeControllerStub(byte[] serializedSubject) {
        this.serializedSubject = serializedSubject;
    }

    private void setConnectionMode(String targetNodeName) {
        String localNodeName = JeusNetPropertyValues.LOCAL_HOSTNAME;
        if ((targetNodeName = VirtualDNS.getRealNodeName(targetNodeName)).lastIndexOf(58) != -1) {
            targetNodeName = targetNodeName.substring(0, targetNodeName.lastIndexOf(58));
        }
        this.local = localNodeName.equalsIgnoreCase(targetNodeName);
    }

    public synchronized void checkConnection(String node) throws JeusServerException {
        if (this.socket == null || this.socket.isClosed()) {
            this.connectTo(node);
        }
    }

    public synchronized void connectTo(String lnode) throws JeusServerException {
        this.connectTo(lnode, READ_TIMEOUT > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)READ_TIMEOUT);
    }

    public synchronized void connectTo(String lnode, int connectionTimeout, int timeout) throws JeusServerException {
        try {
            int port;
            String node;
            int idx = lnode.lastIndexOf(":");
            if (idx != -1) {
                node = lnode.substring(0, idx);
                port = Integer.parseInt(lnode.substring(idx + 1));
            } else {
                node = lnode;
                idx = node.lastIndexOf(":");
                if (idx == -1) {
                    node = lnode;
                    port = JeusPort.NodeController;
                } else {
                    node = lnode.substring(0, idx);
                    port = Integer.parseInt(lnode.substring(idx + 1));
                }
            }
            this.setConnectionMode(node);
            this.socket = SocketProxy.getConnection(node, port, NODE_CONTROLLER_ID, connectionTimeout, false);
            if (timeout != -1) {
                this.socket.setSoTimeout(timeout);
            }
            this.input = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 33792));
            this.output = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 33792));
            this.writeHeaderConnect();
            this.readHeaderConnect();
        }
        catch (Throwable ex) {
            this.close();
            throw new JeusServerException(JeusMessage_Manager._280, ex);
        }
    }

    public synchronized void connectTo(String lnode, int timeout) throws JeusServerException {
        this.connectTo(lnode, 15000, timeout);
    }

    public synchronized void close() {
        try {
            if (this.socket != null) {
                this.closeSocket();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void closeSocket() {
        try {
            this.socket.shutdownInput();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.socket.shutdownOutput();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized Vector boot() throws JeusServerException, BootFailureException {
        try {
            this.output.writeInt(1);
            this.output.flush();
            this.checkAuthentication();
            int num = this.input.readInt();
            if (num == -1) {
                throw new BootFailureException();
            }
            Vector<String> result = new Vector<String>(num);
            for (int i = 0; i < num; ++i) {
                result.add(this.input.readUTF());
            }
            return result;
        }
        catch (BootFailureException ex1) {
            throw ex1;
        }
        catch (Throwable ex2) {
            this.close();
            throw new JeusServerException(JeusMessage_Manager._281, ex2);
        }
    }

    private void readHeaderConnect() throws IOException {
        int isLoginSuccessful = this.input.read();
        if (isLoginSuccessful != 0) {
            throw new JeusRuntimeException(JeusMessage_Manager.MGR_16);
        }
    }

    private void checkAuthentication() throws IOException {
        int isAuthenticationSucceeded = this.input.readInt();
        if (isAuthenticationSucceeded == -1) {
            throw new JeusRuntimeException(JeusMessage_Manager._368);
        }
    }

    public synchronized boolean down() throws JeusServerException {
        try {
            this.output.writeInt(3);
            this.output.flush();
            this.checkAuthentication();
            return this.input.readBoolean();
        }
        catch (Throwable ex) {
            this.close();
            throw new JeusServerException(JeusMessage_Manager.MGR_27, ex);
        }
    }

    public synchronized boolean ftp(String src, String dest, boolean unjar) throws JeusServerException {
        return this.innerftp(src, dest, unjar, null);
    }

    private boolean innerftp(String src, String dest, boolean unjar, String clientJar) throws JeusServerException {
        if (this.local) {
            return this.innerftpLocal(src, dest, unjar, clientJar);
        }
        return this.innerftpRemote(src, dest, unjar, clientJar);
    }

    private boolean innerftpLocal(String src, String dest, boolean unjar, String clientJar) throws JeusServerException {
        if (src.equals(dest = ServerUtil.getNodeDependentPath(dest))) {
            return true;
        }
        File srcFile = new File(src);
        if (!srcFile.exists()) {
            throw new JeusServerException(JeusMessage_Manager._289, src);
        }
        try {
            int index;
            FileUtils.copy(src, dest);
            if (clientJar == null) {
                clientJar = "";
            }
            if (unjar && (index = dest.lastIndexOf(fsc)) != -1) {
                new JarExtractor().unJarEJB(dest, dest.substring(0, index), clientJar);
            }
        }
        catch (Throwable t) {
            logger.log(JeusMessage_Manager1._502_LEVEL, JeusMessage_Manager1._501, t);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean innerftpRemote(String src, String dest, boolean unjar, String clientJar) throws JeusServerException {
        if (this.fileBuffer == null) {
            this.fileBuffer = new byte[32768];
        }
        try {
            File file = new File(src);
            if (!file.exists()) {
                throw new JeusServerException(JeusMessage_Manager._284, src);
            }
            FileInputStream source = new FileInputStream(file);
            try {
                this.output.writeInt(5);
                this.output.writeUTF(dest);
                this.output.writeBoolean(unjar);
                if (unjar) {
                    if (clientJar != null) {
                        this.output.writeUTF(clientJar);
                    } else {
                        this.output.writeUTF("");
                    }
                }
                int filesize = (int)file.length();
                this.output.writeInt(filesize);
                if (filesize != 0) {
                    int num_read;
                    do {
                        try {
                            num_read = source.read(this.fileBuffer);
                            if (num_read == -1) {
                                throw new JeusServerException(JeusMessage_Manager._285, src);
                            }
                            this.output.write(this.fileBuffer, 0, num_read);
                        }
                        catch (Throwable t) {
                            throw new JeusServerException(JeusMessage_Manager._286, src, t);
                        }
                    } while ((filesize -= num_read) > 0);
                }
                this.output.flush();
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                source.close();
                throw throwable;
            }
            source.close();
            this.checkAuthentication();
            this.socket.setSoTimeout(60000);
            boolean retValue = this.input.readBoolean();
            this.socket.setSoTimeout(0);
            return retValue;
        }
        catch (Throwable ex) {
            this.close();
            throw new JeusServerException(JeusMessage_Manager._287, new String[]{src, dest}, ex);
        }
    }

    public synchronized void rftp(String src, String dest) throws JeusServerException {
        if (this.local) {
            this.rftpLocal(src, dest);
        } else {
            this.rftpRemote(src, dest);
        }
    }

    private synchronized void rftpLocal(String src, String dest) throws JeusServerException {
        if (dest.equals(src = ServerUtil.getNodeDependentPath(src))) {
            return;
        }
        File srcFile = new File(src);
        if (!srcFile.exists()) {
            throw new JeusServerException(JeusMessage_Manager._289, src);
        }
        try {
            FileUtils.copy(src, dest);
        }
        catch (IllegalArgumentException iae) {
            throw new JeusServerException(iae.getMessage());
        }
        catch (Throwable t) {
            logger.log(JeusMessage_Manager1._502_LEVEL, JeusMessage_Manager1._502, t);
        }
    }

    public synchronized void rftpRemote(String src, String dest) throws JeusServerException {
        try {
            this.output.writeInt(6);
            this.output.writeUTF(src);
            this.output.flush();
            this.checkAuthentication();
        }
        catch (Throwable t) {
            this.close();
            throw new JeusServerException(JeusMessage_Manager._288, t);
        }
        try {
            if (this.fileBuffer == null) {
                this.fileBuffer = new byte[32768];
            }
            this.createFile(dest);
            this.socket.setSoTimeout(60000);
            int size = this.input.readInt();
            if (size == -1) {
                throw new JeusServerException(JeusMessage_Manager._289, src);
            }
            if (size == -2) {
                throw new JeusServerException(JeusMessage_Manager._368);
            }
            if (size != 0) {
                int num_read;
                do {
                    num_read = this.input.read(this.fileBuffer);
                    this.destination.write(this.fileBuffer, 0, num_read);
                } while ((size -= num_read) > 0);
            }
            this.destination.flush();
            this.destination.close();
            this.destination = null;
            this.socket.setSoTimeout(0);
        }
        catch (Throwable ex) {
            this.close();
            try {
                this.destination.close();
                this.destination = null;
                this.ftpFile.delete();
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw new JeusServerException(JeusMessage_Manager._290, new String[]{src, dest}, ex);
        }
    }

    private void createFile(String fileName) throws JeusServerException {
        try {
            this.ftpFile = new File(fileName);
            if (this.ftpFile.getParent() != null) {
                new File(this.ftpFile.getParent()).mkdirs();
            }
            this.destination = new FileOutputStream(this.ftpFile);
        }
        catch (Throwable ex) {
            throw new JeusServerException(JeusMessage_Manager._291, fileName, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() {
        try {
            block4: {
                try {
                    if (this.output == null) break block4;
                    this.output.writeInt(7);
                    this.output.flush();
                }
                catch (IOException iOException) {
                    Object var3_2 = null;
                    this.close();
                }
            }
            Object var3_1 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.close();
            throw throwable;
        }
    }

    private void writeHeaderConnect() throws IOException {
        byte[] currentSubject;
        this.output.writeInt(973630);
        if (this.serializedSubject != null) {
            if (logger.isLoggable(JeusMessage_Manager._371_LEVEL)) {
                logger.log(JeusMessage_Manager._371_LEVEL, JeusMessage_Manager._371);
            }
            currentSubject = this.serializedSubject;
        } else {
            try {
                currentSubject = LoginService.getCurrentSubjectSerialized();
            }
            catch (Throwable e) {
                this.output.writeInt(-1);
                this.output.flush();
                throw new JeusRuntimeException("Internal exception", e);
            }
        }
        if (logger.isLoggable(JeusMessage_Manager._370_LEVEL)) {
            logger.log(JeusMessage_Manager._370_LEVEL, JeusMessage_Manager._370, (Object)currentSubject);
        }
        this.output.writeInt(currentSubject.length);
        this.output.write(currentSubject);
        this.output.flush();
    }

    public synchronized void restartContainer(String name) throws JeusServerException {
        try {
            this.output.writeInt(18);
            this.output.writeUTF(name);
            this.output.flush();
            this.checkAuthentication();
        }
        catch (Throwable ex) {
            this.close();
            throw new JeusServerException(JeusMessage_Manager._294, name, ex);
        }
    }

    public synchronized boolean startBackup() throws JeusServerException {
        try {
            this.output.writeInt(2);
            this.output.flush();
            this.checkAuthentication();
            return this.input.readBoolean();
        }
        catch (Throwable ex) {
            this.close();
            throw new JeusServerException(JeusMessage_Manager._282, ex);
        }
    }

    public synchronized boolean exit() throws JeusServerException {
        try {
            this.output.writeInt(19);
            this.output.flush();
            this.checkAuthentication();
            return this.input.readBoolean();
        }
        catch (IOException e) {
            return true;
        }
        catch (Throwable ex) {
            this.close();
            throw new JeusServerException(JeusMessage_Manager.MGR_25, ex);
        }
    }

    public synchronized String getHostName() throws JeusServerException {
        try {
            this.output.writeInt(30);
            this.output.flush();
            this.checkAuthentication();
            return this.input.readUTF();
        }
        catch (Throwable ex) {
            this.close();
            throw new JeusServerException(JeusMessage_Manager._296, ex);
        }
    }

    public synchronized Vector bootall(boolean dynamic) throws JeusServerException {
        try {
            this.output.writeInt(31);
            this.output.flush();
            this.checkAuthentication();
            int num = this.input.readInt();
            Vector<String> result = new Vector<String>(num);
            for (int i = 0; i < num; ++i) {
                result.addElement(this.input.readUTF());
            }
            return result;
        }
        catch (Throwable t) {
            this.close();
            throw new JeusServerException(JeusMessage_Manager._281, t);
        }
    }

    public synchronized ConfigFile getConfigDescriptor(ConfigFile configFile) throws JeusServerException, FileNotFoundException {
        try {
            this.output.writeInt(45);
            this.output.writeUTF(configFile.getPath());
            this.output.writeUTF(configFile.getEncoding());
            this.output.writeLong(configFile.lastModified());
            this.output.flush();
            this.checkAuthentication();
            int result = this.input.readInt();
            if (result > 0) {
                configFile.setModified(true);
                configFile.setLastModified(this.input.readLong());
                String encoding = this.input.readUTF();
                configFile.setEncoding(encoding);
                configFile.setContent(StringUtil.readString(this.input, encoding));
            } else if (result == 0) {
                configFile.setModified(false);
            } else {
                if (result == -1) {
                    throw new FileNotFoundException();
                }
                throw new RuntimeException();
            }
            return configFile;
        }
        catch (FileNotFoundException t) {
            throw t;
        }
        catch (Throwable t) {
            this.close();
            throw new JeusServerException("Fail to get config descriptor", t);
        }
    }

    public synchronized ConfigFile setConfigDescriptor(ConfigFile configFile) throws JeusServerException {
        try {
            this.output.writeInt(46);
            this.output.writeUTF(configFile.getPath());
            String encoding = configFile.getEncoding();
            this.output.writeUTF(encoding);
            StringUtil.writeString(this.output, configFile.getContent(), encoding);
            this.output.flush();
            this.checkAuthentication();
            configFile.setLastModified(this.input.readLong());
            return configFile;
        }
        catch (Throwable t) {
            this.close();
            throw new JeusServerException("Fail to set config descriptor", t);
        }
    }

    public synchronized Vector downall() throws JeusServerException {
        try {
            this.output.writeInt(32);
            this.output.flush();
            this.checkAuthentication();
            int num = this.input.readInt();
            Vector<String> result = new Vector<String>(num);
            for (int i = 0; i < num; ++i) {
                result.addElement(this.input.readUTF());
            }
            return result;
        }
        catch (Throwable ex) {
            this.close();
            throw new JeusServerException(JeusMessage_Manager.MGR_27, ex);
        }
    }

    public synchronized Vector exitall() throws JeusServerException {
        Vector<String> result = new Vector<String>();
        try {
            this.output.writeInt(33);
            this.output.flush();
            this.checkAuthentication();
            int num = this.input.readInt();
            for (int i = 0; i < num; ++i) {
                result.addElement(this.input.readUTF());
            }
            this.input.readBoolean();
            return result;
        }
        catch (IOException e) {
            return result;
        }
        catch (Throwable ex) {
            this.close();
            throw new JeusServerException(JeusMessage_Manager.MGR_25, ex);
        }
    }

    public synchronized String getVirtualHostName(String host) throws JeusServerException {
        try {
            this.output.writeInt(48);
            this.output.writeUTF(host);
            this.output.flush();
            this.checkAuthentication();
            return this.input.readUTF();
        }
        catch (IOException e) {
            this.close();
            throw new JeusServerException(JeusMessage_Manager.MGR_389, (Throwable)e);
        }
    }

    public synchronized String getFullHostName(String host) throws JeusServerException {
        try {
            this.output.writeInt(49);
            this.output.writeUTF(host);
            this.output.flush();
            this.checkAuthentication();
            return this.input.readUTF();
        }
        catch (IOException e) {
            this.close();
            throw new JeusServerException(JeusMessage_Manager.MGR_390, (Throwable)e);
        }
    }
}

