/*
 * Decompiled with CFR 0.152.
 */
package jeus.server.lifecycle;

import jeus.server.lifecycle.AlreadyStartedException;
import jeus.server.lifecycle.AlreadyStoppedException;
import jeus.server.lifecycle.LifeCycle;
import jeus.server.lifecycle.LifeCycleStates;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Lifecycle;

public abstract class LifeCycleSupport
implements LifeCycle {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.server");
    private volatile transient LifeCycleStates state = LifeCycleStates.STOPPED;

    protected abstract void doStart(Object[] var1) throws Throwable;

    protected abstract void doStop(Object[] var1) throws Throwable;

    public final synchronized void start(Object[] params) throws Throwable {
        if (this.state == LifeCycleStates.STARTED) {
            throw new AlreadyStartedException();
        }
        try {
            this.state = LifeCycleStates.STARTING;
            this.doStart(params);
            if (logger.isLoggable(JeusMessage_Lifecycle._1100_LEVEL)) {
                logger.log(JeusMessage_Lifecycle._1100_LEVEL, JeusMessage_Lifecycle._1100, (Object)this);
            }
            this.state = LifeCycleStates.STARTED;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_Lifecycle._1101_LEVEL)) {
                logger.log(JeusMessage_Lifecycle._1101_LEVEL, JeusMessage_Lifecycle._1101, (Object)this);
            }
            this.state = LifeCycleStates.FAILED;
            throw t;
        }
    }

    public void start() throws Throwable {
        this.start(new Object[0]);
    }

    public final synchronized void stop(Object[] params) throws Throwable {
        if (this.state.compareTo(LifeCycleStates.STARTING) < 0) {
            throw new AlreadyStoppedException();
        }
        try {
            this.state = LifeCycleStates.STOPPING;
            this.doStop(params);
            if (logger.isLoggable(JeusMessage_Lifecycle._1102_LEVEL)) {
                logger.log(JeusMessage_Lifecycle._1102_LEVEL, JeusMessage_Lifecycle._1102, (Object)this);
            }
            this.state = LifeCycleStates.STOPPED;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_Lifecycle._1103_LEVEL)) {
                logger.log(JeusMessage_Lifecycle._1103_LEVEL, JeusMessage_Lifecycle._1103, (Object)this);
            }
            this.state = LifeCycleStates.FAILED;
            throw t;
        }
    }

    public void stop() throws Throwable {
        this.stop(new Object[0]);
    }

    public boolean isRunning() {
        return this.state == LifeCycleStates.STARTED || this.state == LifeCycleStates.STARTING;
    }

    public boolean isStarted() {
        return this.state == LifeCycleStates.STARTED;
    }

    public boolean isStarting() {
        return this.state == LifeCycleStates.STARTING;
    }

    public boolean isStopping() {
        return this.state == LifeCycleStates.STOPPING;
    }

    public boolean isFailed() {
        return this.state == LifeCycleStates.FAILED;
    }

    public LifeCycleStates getState() {
        return this.state;
    }
}

